package com.ejianc.business.promaterial.check.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("check")
public class CheckBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ICheckService checkService;
	@Autowired
	private IOrderService orderService;
	@Autowired
	private IDeliveryService deliveryService;
	@Autowired
	private ICheckDetailService checkDetailService;
	@Autowired
	private IDeliveryDetailService deliveryDetailService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Value("${contract.generateBillCodeType:common}")
	private String GenerateBillCodeType;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
//		CheckEntity e = checkService.selectById(billId);
////		//获取项目电子开启状态
////		ElectronicFenceConfigEntity electronicFenceConfig = electronicFenceConfigService.getOneByProjectId(e.getProjectId(), true);
////		if(null != electronicFenceConfig && Integer.valueOf(1).equals(electronicFenceConfig.getEnable())) {
////			String checkRs = checkHasAbnormalImg(e);
////			if(StringUtils.isNotBlank(checkRs)) {
////				return CommonResponse.error(checkRs);
////			}
////		}
		return CommonResponse.success();
	}


	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){


		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		CheckEntity entity = checkService.selectById(billId);
		if ("2".equals(entity.getSourceType())){
			entity.setChangState("pass");
			checkService.saveOrUpdate(entity, false);
		}

		Map<Long, BigDecimal> checkDetailMap = entity.getCheckDetailList().stream().filter(e -> null != e.getOrderDetailId()).collect(Collectors.toMap(e -> e.getOrderDetailId(), e -> e.getCheckNum()));
		//回写发货单数据
		Integer checkStatus = 0;
		if (null != entity.getDeliveryType() && entity.getDeliveryType() == 1) {
			DeliveryEntity deliveryEntity = deliveryService.selectById(entity.getDeliveryId());
			//查询出所有的验收单详情,算出验收数据
			LambdaQueryWrapper<CheckDetailEntity> lambdaCheckDetail = Wrappers.<CheckDetailEntity>lambdaQuery();
			lambdaCheckDetail.eq(CheckDetailEntity::getDeliveryId, entity.getDeliveryId());
			List<CheckDetailEntity> checkDetailEntityList = checkDetailService.list(lambdaCheckDetail);
			if (CollectionUtils.isNotEmpty(checkDetailEntityList)) {
				Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getDeliveryDetailId));
				LambdaQueryWrapper<DeliveryDetailEntity> lambdaDeliveryDetail = Wrappers.<DeliveryDetailEntity>lambdaQuery();
				lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, entity.getDeliveryId());
				List<DeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailService.list(lambdaDeliveryDetail);

				for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
					List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
					if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
						BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNum)
								.reduce(BigDecimal.ZERO, BigDecimal::add);
						deliveryDetailEntity.setCheckNum(checkNum);
					}
					if (null == deliveryDetailEntity.getCheckNum()) {
						deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
					}
				}

				//判断发货单的验收状态
				Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getTimeDeliverNum()) > -1);
				Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
						(e.getCheckNum().compareTo(e.getTimeDeliverNum()) == -1));

				if (allCheck) {
					checkStatus = 2;
					deliveryEntity.setOrderFlag(1);
				}
				if (anyCheck) {
					checkStatus = 1;
				}
				//更新发货验收状态和验收数量

				deliveryEntity.setCheckState(checkStatus);
				deliveryService.updateById(deliveryEntity);
				deliveryDetailService.updateBatchById(deliveryDetailEntityList);
			}
		}
		if (null != entity.getOrderId()){
			OrderEntity orderEntity = orderService.selectById(entity.getOrderId());
			for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
				if (checkDetailMap.containsKey(orderDetailEntity.getId())){
					orderDetailEntity.setCheckNum(ComputeUtil.safeAdd(null != orderDetailEntity.getCheckNum() ? orderDetailEntity.getCheckNum() : BigDecimal.ZERO, checkDetailMap.get(orderDetailEntity.getId())));
				}
			}
		}

		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//是否被其他单据引用
//		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
//		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
//		if(!res.isSuccess()) {
//			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
//		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CheckEntity entity = checkService.selectById(billId);
		if ("2".equals(entity.getSourceType())){
			entity.setChangState("checking");
			checkService.saveOrUpdate(entity, false);
		}

		Map<Long, BigDecimal> checkDetailMap = entity.getCheckDetailList().stream().filter(e -> null != e.getOrderDetailId()).collect(Collectors.toMap(e -> e.getOrderDetailId(), e -> e.getCheckNum()));

		Integer checkStatus = 0;
		List<CheckDetailEntity> checkDetailList = entity.getCheckDetailList();
		DeliveryEntity deliveryEntity = deliveryService.selectById(entity.getDeliveryId());
		if (deliveryEntity != null) {
			List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
			Map<Long, CheckDetailEntity> checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity()));
			for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
				if (checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) {
					CheckDetailEntity checkDetailEntity = checkDetailEntityMap.get(deliveryDetailEntity.getId());
					deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
				}
			}

			//判断发货单的验收状态
			Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getTimeDeliverNum()) > -1);
			Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
					(e.getCheckNum().compareTo(e.getTimeDeliverNum()) == -1));

			if (allCheck) {
				checkStatus = 2;
			}
			if (anyCheck) {
				deliveryEntity.setOrderFlag(0);
				checkStatus = 1;
			}

			deliveryEntity.setCheckState(checkStatus);

			deliveryService.updateById(deliveryEntity);
			deliveryDetailService.updateBatchById(deliveryDetailList);
		}
		if (null != entity.getOrderId()){
			OrderEntity orderEntity = orderService.selectById(entity.getOrderId());
			for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
				if (checkDetailMap.containsKey(orderDetailEntity.getId())){
					orderDetailEntity.setCheckNum(ComputeUtil.safeSub(null != orderDetailEntity.getCheckNum() ? orderDetailEntity.getCheckNum() : BigDecimal.ZERO, checkDetailMap.get(orderDetailEntity.getId())));
				}
			}
			orderService.saveOrUpdate(orderEntity, false);
		}
		return CommonResponse.success();
	}

}
