package com.ejianc.business.promaterial.delivery.enums;

public enum CloseFlagEnum {

    /** 正常 */
    NORMAL(0,"正常"),
    /** 已关闭 */
    CLOSE(1,"已关闭");

    private Integer code;

    private String description;

    CloseFlagEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    };


    /**
     * 获取状态
     * @return 状态
     */
    public Integer getCode() {
        return this.code;
    }

    /**
     * 获取状态注释
     * @return 状态注释
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 根据状态获取状态枚举
     * @param planState 状态
     * @return 状态枚举
     */
    public static CloseFlagEnum getEnumByStateCode(Integer planState) {
        for (CloseFlagEnum enu : CloseFlagEnum
                .values()) {
            if (enu.getCode().equals(planState)) return enu;
        }
        return null;
    }

    /**
     * 根据状态获取状态注释
     * @param planState 状态
     * @return 状态注释
     */
    public static String getDescriptionByStateCode(Integer planState){
        CloseFlagEnum enu = getEnumByStateCode(planState);
        if (enu != null) return enu.getDescription();
        return null;
    }
}
