package com.ejianc.business.promaterial.delivery.enums;

public enum DeliverCheckStateEnum {

    /** 待验收 */
    WAIT_CHECK(0,"待验收"),
    /** 部分验收 */
    PART_CHECK(1,"部分验收"),
    /** 全部验收 */
    FULL_CHECK(2,"全部验收");

    private Integer code;

    private String description;

    DeliverCheckStateEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    };


    /**
     * 获取状态
     * @return 状态
     */
    public Integer getCode() {
        return this.code;
    }

    /**
     * 获取状态注释
     * @return 状态注释
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 根据状态获取状态枚举
     * @param planState 状态
     * @return 状态枚举
     */
    public static DeliverCheckStateEnum getEnumByStateCode(Integer planState) {
        for (DeliverCheckStateEnum enu : DeliverCheckStateEnum.values()) {
            if (enu.getCode().equals(planState)) return enu;
        }
        return null;
    }

    /**
     * 根据状态获取状态注释
     * @param planState 状态
     * @return 状态注释
     */
    public static String getDescriptionByStateCode(Integer planState){
        DeliverCheckStateEnum enu = getEnumByStateCode(planState);
        if (enu != null) return enu.getDescription();
        return null;
    }
}
