package com.ejianc.business.promaterial.reconciliation.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 对账单主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_reconciliation")
public class ReconciliationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="reconciliation_date")
    private Date reconciliationDate; // 对账日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="reconciliation_mny")
    private BigDecimal reconciliationMny; // 对账金额
    @TableField(value="reconciliation_tax_mny")
    private BigDecimal reconciliationTaxMny; // 对账金额(含税)
    @TableField(value="reconciliation_tax")
    private BigDecimal reconciliationTax; // 对账税额
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 产品金额(无税)
    @TableField(value="material_tax_mny")
    private BigDecimal materialTaxMny; // 产品金额
    @TableField(value="material_tax")
    private BigDecimal materialTax; // 产品税额
    @TableField(value="fee_mny")
    private BigDecimal feeMny; // 其他金额(无税)
    @TableField(value="fee_tax_mny")
    private BigDecimal feeTaxMny; // 其他金额
    @TableField(value="fee_tax")
    private BigDecimal feeTax; // 其他税额
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税）
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="sign_status")
    private Integer signStatus; // 签字状态，0-未签字,1-已签字
    @TableField(value="reconciliation_type")
    private Integer reconciliationType; // 对账单类型（0-物资采购对账单）
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_name")
    private String materialName; // 备注
    @TableField(value="total_reconciliation_num")
    private Integer totalReconciliationNum; // 累计对账数量

    @TableField(value="contract_invoice_tax_mny")
    private BigDecimal contractInvoiceTaxMny; // 合同收票金额
    @TableField(value="contract_invoice_mny")
    private BigDecimal contractInvoiceMny; // 合同收票金额（无税）
    @TableField(value="contract_pay_mny")
    private BigDecimal contractPayMny; // 合同已付金额
    @TableField(value="current_settlement_tax_mny")
    private BigDecimal currentSettlementTaxMny; // 含本期结算金额
    @TableField(value="current_settlement_mny")
    private BigDecimal currentSettlementMny; // 含本期结算金额

    @TableField(value="sum_settlement_tax_mny")
    private BigDecimal sumSettlementTaxMny; // 累计结算金额
    @TableField(value="sum_settlement_mny")
    private BigDecimal sumSettlementMny; // 累计结算金额

    @TableField(value = "settle_flag")
    private Integer settleFlag; // 是否结算1是0否

    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String systemId;

    @TableField(exist=false)
    @SubEntity(serviceName="reconciliationDetailService",pidName = "reconciliationId")//此处有pid="xxx"，默认值pid="pid"
    private List<ReconciliationDetailEntity> detailList = new ArrayList<>(); // 材料批次采购计划字表（采购清单）
    @TableField(exist=false)
    @SubEntity(serviceName="reconciliationCollectService",pidName = "reconciliationId")//此处有pid="xxx"，默认值pid="pid"
    private List<ReconciliationCollectEntity> collectDetailList = new ArrayList<>(); // 材料批次采购计划字表（采购清单）

    @TableField(exist=false)
    @SubEntity(serviceName="reconciliationFeeService",pidName = "reconciliationId")//此处有pid="xxx"，默认值pid="pid"
    private List<ReconciliationFeeEntity> reconciliationFeeList = new ArrayList<>(); // 其他费用表

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public BigDecimal getContractInvoiceTaxMny() {
        return contractInvoiceTaxMny;
    }

    public void setContractInvoiceTaxMny(BigDecimal contractInvoiceTaxMny) {
        this.contractInvoiceTaxMny = contractInvoiceTaxMny;
    }

    public BigDecimal getContractInvoiceMny() {
        return contractInvoiceMny;
    }

    public void setContractInvoiceMny(BigDecimal contractInvoiceMny) {
        this.contractInvoiceMny = contractInvoiceMny;
    }

    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }

    public BigDecimal getCurrentSettlementTaxMny() {
        return currentSettlementTaxMny;
    }

    public void setCurrentSettlementTaxMny(BigDecimal currentSettlementTaxMny) {
        this.currentSettlementTaxMny = currentSettlementTaxMny;
    }

    public BigDecimal getCurrentSettlementMny() {
        return currentSettlementMny;
    }

    public void setCurrentSettlementMny(BigDecimal currentSettlementMny) {
        this.currentSettlementMny = currentSettlementMny;
    }

    public BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    public void setSumSettlementTaxMny(BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }

    public BigDecimal getSumSettlementMny() {
        return sumSettlementMny;
    }

    public void setSumSettlementMny(BigDecimal sumSettlementMny) {
        this.sumSettlementMny = sumSettlementMny;
    }

    @TableField(value="org_code")
    private String orgCode; // 组织名称

    @TableField(value="supplier_employee_id")
    private Long supplierEmployeeId; // 供方经办人ID
    /**
     * 供方经办人名称
     */
    @TableField(value = "supplier_employee_name")
    private String supplierEmployeeName;

    /**
     * 数据来源1-采购方 2-供方
     */
    @TableField(value="source_type")
    private String sourceType;

    @TableField(value="chang_state")
    private String changState; // 供应商自己状态：未生效free、审核中checking、已生效pass，审核驳回returned
    @TableField(value="return_reason")
    private String returnReason; // 驳回原因

    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getChangState() {
        return changState;
    }

    public void setChangState(String changState) {
        this.changState = changState;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getTotalReconciliationNum() {
        return totalReconciliationNum;
    }

    public void setTotalReconciliationNum(Integer totalReconciliationNum) {
        this.totalReconciliationNum = totalReconciliationNum;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ReconciliationDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ReconciliationDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<ReconciliationCollectEntity> getCollectDetailList() {
        return collectDetailList;
    }

    public void setCollectDetailList(List<ReconciliationCollectEntity> collectDetailList) {
        this.collectDetailList = collectDetailList;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getReconciliationDate() {
        return reconciliationDate;
    }

    public void setReconciliationDate(Date reconciliationDate) {
        this.reconciliationDate = reconciliationDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getReconciliationMny() {
        return reconciliationMny;
    }

    public void setReconciliationMny(BigDecimal reconciliationMny) {
        this.reconciliationMny = reconciliationMny;
    }
    public BigDecimal getReconciliationTaxMny() {
        return reconciliationTaxMny;
    }

    public void setReconciliationTaxMny(BigDecimal reconciliationTaxMny) {
        this.reconciliationTaxMny = reconciliationTaxMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getReconciliationType() {
        return reconciliationType;
    }

    public void setReconciliationType(Integer reconciliationType) {
        this.reconciliationType = reconciliationType;
    }


    public List<ReconciliationFeeEntity> getReconciliationFeeList() {
        return reconciliationFeeList;
    }

    public void setReconciliationFeeList(List<ReconciliationFeeEntity> reconciliationFeeList) {
        this.reconciliationFeeList = reconciliationFeeList;
    }

    public BigDecimal getReconciliationTax() {
        return reconciliationTax;
    }

    public void setReconciliationTax(BigDecimal reconciliationTax) {
        this.reconciliationTax = reconciliationTax;
    }

    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }

    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }

    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }

    public BigDecimal getFeeMny() {
        return feeMny;
    }

    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }

    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }

    public BigDecimal getFeeTax() {
        return feeTax;
    }

    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
}
