package com.ejianc.business.promaterial.reconciliation.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.mapper.ReconciliationMapper;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 对账单主表
 * 
 * @author generator
 * 
 */
@Service("reconciliationService")
public class ReconciliationServiceImpl extends BaseServiceImpl<ReconciliationMapper, ReconciliationEntity> implements IReconciliationService{
    @Autowired
    private IContractService contractService;//合同
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String  OPERATE= "SETTLMENT_JS";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/reconciliation/saveReconciliation";
    private static final String XHC_BILL_TYPE = "BT220310000000001";//此处需要根据实际修改
    private static final String HNT_BILL_TYPE = "BT220316000000003";//此处需要根据实际修改


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void checkContract(ReconciliationEntity entity) {
        if(CollectionUtils.isNotEmpty(entity.getDetailList())){
            ContractEntity contractEntity = contractService.selectById(entity.getContractId());
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            if(CollectionUtils.isEmpty(contractDetailList)){
                throw new BusinessException("对账明细在合同【"+entity.getContractName()+"】中不存在，请变更合同后再对账");
            }
            List<String> materialIds = contractDetailList.stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).map(item->item.getMaterialId().toString()).collect(Collectors.toList());
            List<String> materialTypeIds = contractDetailList.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId()!=null &&!ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).map(item->item.getMaterialTypeId().toString()).collect(Collectors.toList());
            for (ReconciliationDetailEntity detail : entity.getDetailList()) {
                if(!"del".equals(detail.getRowState())){
                    boolean flag = true;
                    String materialTypeId = detail.getMaterialTypeId()==null?"":detail.getMaterialTypeId().toString();
                    String materialId = detail.getMaterialId()==null?"":detail.getMaterialId().toString();
                    if(materialTypeIds.contains(materialTypeId)){//结算明细有合同分类
                        flag = false;
                    }
                    if(materialIds.contains(materialId)){//结算明细有合同明细
                        flag = false;
                    }
                    if(flag){
                        throw new BusinessException("材料【"+detail.getMaterialName()+"】在合同【"+entity.getContractName()+"】中不存在，请变更合同后再对账");
                    }
                }
            }
        }
    }

    @Override
    public IPage<ReconciliationVO> queryData(QueryParam param) {
        IPage<ReconciliationVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<ReconciliationVO> list = baseMapper.queryData(changeToQueryWrapper(param), page);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

}
