/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"order"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "XHC_ORDER";
    @Autowired
    private IOrderService service;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISupplierApi supplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveOrUpdateVO) {
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OrderEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(id));
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        List deliveryEntityList = this.deliveryService.list((Wrapper)new QueryWrapper().eq((Object)"order_id", (Object)vo.getId()));
        List checkEntityList = this.checkService.list((Wrapper)new QueryWrapper().eq((Object)"order_id", (Object)vo.getId()));
        vo.setDeliveryList(BeanMapper.mapList((Iterable)deliveryEntityList, DeliveryVO.class));
        vo.setCheckList(BeanMapper.mapList((Iterable)checkEntityList, CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OrderVO orderVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, OrderVO.class);
            voList.forEach(c -> {
                if (null != c.getDeliverState()) {
                    switch (c.getDeliverState()) {
                        case 0: {
                            c.setDeliverStateName("\u5f85\u9001\u8d27");
                            break;
                        }
                        case 1: {
                            c.setDeliverStateName("\u90e8\u5206\u9001\u8d27");
                            break;
                        }
                        case 2: {
                            c.setDeliverStateName("\u5df2\u9001\u8d27");
                        }
                    }
                }
                if (null != c.getOrderFlag()) {
                    switch (c.getOrderFlag()) {
                        case 0: {
                            c.setOrderFlagName("\u6b63\u5e38");
                            break;
                        }
                        case 1: {
                            c.setOrderFlagName("\u5df2\u5173\u95ed");
                        }
                    }
                }
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("Order-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOrderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> refOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orderFlag", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"contractId")) {
            param.getParams().put("contractId", new Parameter("eq", (Object)Long.valueOf(String.valueOf(_con.get((Object)"contractId")))));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u4fee\u6539\u53d1\u8d27\u72b6\u6001")
    @RequestMapping(value={"/updateDeliver"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<String> updateDeliver(@RequestBody OrderVO orderVO) {
        return this.service.updateDeliver(orderVO.getId(), orderVO.getDeliverState());
    }

    @ApiOperation(value="\u5173\u95ed")
    @RequestMapping(value={"/close"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> close(@RequestParam Long id) {
        this.service.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"id", (Object)id)).set((Object)"order_flag", (Object)1));
        return CommonResponse.success((String)"\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u5408\u540cid\u67e5\u8be2\u8ba2\u5355\u7d2f\u8ba1\u91d1\u989d")
    @RequestMapping(value={"/getOrderDataByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> getOrderDataByContractId(@RequestParam Long contractId, @RequestParam(value="orderId", required=false) Long orderId) {
        List entityList;
        OrderVO orderVO = new OrderVO();
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.eq((Object)"contract_id", (Object)contractId);
        orderQueryWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        if (null != orderId) {
            orderQueryWrapper.ne((Object)"id", (Object)orderId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(entityList = this.service.list((Wrapper)orderQueryWrapper))) && entityList.size() > 0) {
            orderVO.setContractNoOrderTaxMny(entityList.stream().map(e -> e.getOrderTaxMny() == null ? BigDecimal.ZERO : e.getOrderTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add));
            orderVO.setContractNoOrderMny(entityList.stream().map(e -> e.getOrderMny() == null ? BigDecimal.ZERO : e.getOrderMny()).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)orderVO);
    }

    @RequestMapping(value={"/pageGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageGFList(@RequestBody QueryParam param) {
        CommonResponse commonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("linkName");
        CommonResponse response = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)response.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("tenant_id", new Parameter("in", (Object)systemIdList));
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), OrderVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelGFExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelGFExport(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse commonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("linkName");
        CommonResponse cooperResponse = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!cooperResponse.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)cooperResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)cooperResponse.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("tenant_id", new Parameter("in", (Object)systemIdList));
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, OrderVO.class);
            voList.forEach(c -> {
                if (null != c.getDeliverState()) {
                    switch (c.getDeliverState()) {
                        case 0: {
                            c.setDeliverStateName("\u5f85\u9001\u8d27");
                            break;
                        }
                        case 1: {
                            c.setDeliverStateName("\u90e8\u5206\u9001\u8d27");
                            break;
                        }
                        case 2: {
                            c.setDeliverStateName("\u5df2\u9001\u8d27");
                        }
                    }
                }
                if (null != c.getOrderFlag()) {
                    switch (c.getOrderFlag()) {
                        case 0: {
                            c.setOrderFlagName("\u6b63\u5e38");
                            break;
                        }
                        case 1: {
                            c.setOrderFlagName("\u5df2\u5173\u95ed");
                        }
                    }
                }
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("OrderGF-export.xlsx", beans, response);
    }
}

