/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.settlement.service.impl;

import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlement")
public class SettlementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISettlementService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if ("2".equals(entity.getSourceType())) {
            entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
            entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
            entity.setChangState("pass");
        }
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if ("2".equals(entity.getSourceType())) {
            entity.setEmployeeId(null);
            entity.setEmployeeName(null);
            entity.setChangState("checking");
        }
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if (1 == state && "2".equals(entity.getSourceType())) {
            entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
            entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
            entity.setChangState("pass");
        }
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u5f00\u59cb\uff01");
        if (entity.getContractId() != null && entity.getSignatureType() == 1) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res2 = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res2.isSuccess() + "----" + res2.getMsg());
        if (!res2.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if ("2".equals(entity.getSourceType())) {
            entity.setEmployeeId(null);
            entity.setEmployeeName(null);
            entity.setChangState("checking");
        }
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null && entity.getSignatureType() == 1) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01");
        }
        return CommonResponse.success();
    }
}

