/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.settlement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.returnGoods.bean.ReturnGoodsEntity;
import com.ejianc.business.promaterial.returnGoods.service.IReturnGoodsService;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.mapper.SettlementMapper;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.ContractSettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementService")
public class SettlementServiceImpl
extends BaseServiceImpl<SettlementMapper, SettlementEntity>
implements ISettlementService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayContractService payContractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE_C = "JS_CODE";
    @Autowired
    private IContractService contractService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IReconciliationService reconciliationService;
    @Autowired
    private IReturnGoodsService returnGoodsService;

    @Override
    public SettlementRecordVO querySettleRecord(Long contractId) {
        SettlementRecordVO vo = new SettlementRecordVO();
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        vo.setContractId(contractId);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.in(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.orderByAsc(BaseEntity::getCreateTime);
        List list = super.list((Wrapper)wrapper);
        List vos = BeanMapper.mapList((Iterable)list, SettlementVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            BigDecimal totalSettlementTaxMny = vos.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementVO::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalSettlementTaxMny(totalSettlementTaxMny);
        } else {
            vo.setTotalSettlementTaxMny(BigDecimal.ZERO);
        }
        if (vo.getContractTaxMny() == null || BigDecimal.ZERO.compareTo(vo.getContractTaxMny()) == 0) {
            vo.setSettleRatio(BigDecimal.ZERO);
        } else {
            vo.setSettleRatio(vo.getTotalSettlementTaxMny().divide(vo.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        vo.setSettlementList(vos);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper2.eq(BaseEntity::getDr, (Object)0);
        wrapper2.eq(SettlementEntity::getSignatureType, (Object)1);
        List list2 = super.list((Wrapper)wrapper2);
        vo.setFlag(Boolean.valueOf(!CollectionUtils.isNotEmpty((Collection)list2)));
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper3.eq(BaseEntity::getDr, (Object)0);
        wrapper3.notIn(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper3.eq(SettlementEntity::getSignatureType, (Object)0);
        List list3 = super.list((Wrapper)wrapper3);
        vo.setFlagTwo(Boolean.valueOf(!CollectionUtils.isNotEmpty((Collection)list3)));
        return vo;
    }

    @Override
    public CommonResponse<SettlementVO> saveOrUpdate(SettlementVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper;
        SettlementEntity entity = (SettlementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null != entity.getContractId() && this.queryExist(entity.getContractId())) {
                throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE_C, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        HashSet<Long> CheckDelSet = new HashSet<Long>();
        HashSet<Long> CheckAddSet = new HashSet<Long>();
        HashSet<Long> dzDelSet = new HashSet<Long>();
        HashSet<Long> dzAddSet = new HashSet<Long>();
        HashSet<Long> returnDelSet = new HashSet<Long>();
        HashSet<Long> returnAddSet = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getSettlementDetailList())) {
            for (SettlementDetailVO detailVO : saveOrUpdateVO.getSettlementDetailList()) {
                if ("del".equals(detailVO.getRowState())) {
                    if (0 == detailVO.getSourceType()) {
                        dzDelSet.add(detailVO.getReconciliationId());
                        continue;
                    }
                    if (1 == detailVO.getSourceType()) {
                        CheckDelSet.add(detailVO.getSourceId());
                        continue;
                    }
                    if (2 != detailVO.getSourceType()) continue;
                    returnDelSet.add(detailVO.getSourceId());
                    continue;
                }
                if (0 == detailVO.getSourceType()) {
                    dzAddSet.add(detailVO.getReconciliationId());
                    continue;
                }
                if (1 == detailVO.getSourceType()) {
                    CheckAddSet.add(detailVO.getSourceId());
                    continue;
                }
                if (2 != detailVO.getSourceType()) continue;
                returnAddSet.add(detailVO.getSourceId());
            }
        }
        entity.setSignStatus(0);
        super.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty(CheckDelSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, CheckDelSet);
            updateWrapper.set(CheckEntity::getSettleFlag, (Object)0);
            this.checkService.update((Wrapper)updateWrapper);
        }
        if (CollectionUtils.isNotEmpty(CheckAddSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, CheckAddSet);
            updateWrapper.set(CheckEntity::getSettleFlag, (Object)1);
            this.checkService.update((Wrapper)updateWrapper);
        }
        if (CollectionUtils.isNotEmpty(dzDelSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, dzDelSet);
            updateWrapper.set(ReconciliationEntity::getSettleFlag, (Object)0);
            this.reconciliationService.update((Wrapper)updateWrapper);
        }
        if (CollectionUtils.isNotEmpty(dzAddSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, dzAddSet);
            updateWrapper.set(ReconciliationEntity::getSettleFlag, (Object)1);
            this.reconciliationService.update((Wrapper)updateWrapper);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(returnDelSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, returnDelSet);
            updateWrapper.set(ReturnGoodsEntity::getSettleFlag, (Object)0);
            this.returnGoodsService.update((Wrapper)updateWrapper);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(returnAddSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, returnAddSet);
            updateWrapper.set(ReturnGoodsEntity::getSettleFlag, (Object)1);
            this.returnGoodsService.update((Wrapper)updateWrapper);
        }
        SettlementVO vo = (SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public boolean queryExist(Long contractId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper.notIn(SettlementEntity::getBillState, new Object[]{1, 3});
        List list = super.list((Wrapper)wrapper);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        String sTDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            SettlementEntity settlementEntity = (SettlementEntity)((Object)list.get(0));
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            sTDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny", currentTaxMny);
        map.put("currentMny", currentMny);
        map.put("sTDate", sTDate);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            map.put("settlementNum", list.size());
        } else {
            map.put("settlementNum", 0);
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u91d1\u989d\u548c\u65f6\u95f4\u3001\u7ed3\u7b97\u6b21\u6570\u6210\u529f,\uff01", map);
    }

    @Override
    public CommonResponse<String> delete(List<SettlementVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            for (SettlementVO vo : vos) {
                LambdaUpdateWrapper updateWrapper;
                SettlementEntity entity = (SettlementEntity)((Object)super.selectById((Serializable)vo.getId()));
                HashSet<Long> CheckDelSet = new HashSet<Long>();
                HashSet<Long> dzDelSet = new HashSet<Long>();
                HashSet<Long> returnDelSet = new HashSet<Long>();
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
                    for (SettlementDetailEntity detailVO : entity.getSettlementDetailList()) {
                        if (0 == detailVO.getSourceType()) {
                            dzDelSet.add(detailVO.getReconciliationId());
                            continue;
                        }
                        if (1 == detailVO.getSourceType()) {
                            CheckDelSet.add(detailVO.getSourceId());
                            continue;
                        }
                        if (2 != detailVO.getSourceType()) continue;
                        returnDelSet.add(detailVO.getSourceId());
                    }
                }
                if (CollectionUtils.isNotEmpty(CheckDelSet)) {
                    updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.in(BaseEntity::getId, CheckDelSet);
                    updateWrapper.set(CheckEntity::getSettleFlag, (Object)0);
                    this.checkService.update((Wrapper)updateWrapper);
                }
                if (CollectionUtils.isNotEmpty(dzDelSet)) {
                    updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.in(BaseEntity::getId, dzDelSet);
                    updateWrapper.set(ReconciliationEntity::getSettleFlag, (Object)0);
                    this.reconciliationService.update((Wrapper)updateWrapper);
                }
                if (!CollectionUtils.isNotEmpty(returnDelSet)) continue;
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, returnDelSet);
                updateWrapper.set(ReturnGoodsEntity::getSettleFlag, (Object)0);
                this.returnGoodsService.update((Wrapper)updateWrapper);
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public ContractSettlementRecordVO queryDetailRecord(Long contractId) {
        ContractSettlementRecordVO settleRecordVO = new ContractSettlementRecordVO();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"settlement_date");
        List list = super.list((Wrapper)listQuery);
        List rentSettlementVOS = BeanMapper.mapList((Iterable)list, SettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractSettleMny = list.stream().map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);
        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        } else {
            settleRecordVO.setSettleRate(settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    @Override
    public List<SettlementVO> querySettlementByContractId(SettlementVO settlementVO) {
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        List<Object> rtnList = new ArrayList<SettlementVO>();
        if (CollectionUtils.isNotEmpty(list)) {
            rtnList = BeanMapper.mapList(list, SettlementVO.class);
            for (SettlementVO settlementVO2 : rtnList) {
                settlementVO2.setSettlementDateStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementVO2.getSettlementDate()));
                settlementVO2.setBillCodeLink(settlementVO2.getBillCode());
                settlementVO2.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)settlementVO2.getBillState()).getDescription());
            }
        }
        return rtnList;
    }

    @Override
    public IPage<SettlementVO> queryForList(QueryParam queryParam, boolean isEs) {
        boolean payApplyFlagHasFree = queryParam.getParams().containsKey("payApplyFlagHasFree");
        queryParam.getParams().remove("payApplyFlagHasFree");
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            List purchaseSettlementVOS = BeanMapper.mapList((Iterable)entityPage.getRecords(), SettlementVO.class);
            if (payApplyFlagHasFree && CollectionUtils.isNotEmpty((Collection)purchaseSettlementVOS)) {
                List<Long> settleIds = purchaseSettlementVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
                Map<Long, BigDecimal> settleApplyData = this.payContractService.getApplyMnyHasFree(settleIds, null);
                for (SettlementVO purchaseSettlementRefVo : purchaseSettlementVOS) {
                    BigDecimal sumApplyMnyHasFree = settleApplyData.get(purchaseSettlementRefVo.getId());
                    purchaseSettlementRefVo.setCurrentApplyAmount(sumApplyMnyHasFree);
                    BigDecimal surplusApplyMny = ComputeUtil.safeSub((BigDecimal)purchaseSettlementRefVo.getSettlementTaxMny(), (BigDecimal)sumApplyMnyHasFree);
                    purchaseSettlementRefVo.setRemainCanApplyAmount(surplusApplyMny);
                }
            }
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(purchaseSettlementVOS);
        }
        return voPage;
    }

    private List<SettlementEntity> queryListByContractId(SettlementVO settlementVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)settlementVO.getContractId()));
        queryParam.getOrderMap().put("settlementDate", "desc");
        return super.queryList(queryParam, false);
    }
}

