package com.ejianc.business.promaterial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractChangeEntity;
import com.ejianc.business.promaterial.contract.service.IContractChangeService;
import com.ejianc.business.promaterial.contract.vo.ContractChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 变更-合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contractChange")
@Api(value = "变更-合同实体", tags = {"变更-合同实体"})
public class ContractChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractChangeService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractChangeVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractChangeVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.insertOrUpdate(saveorUpdateVO,false));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractChangeVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更需要的主合同字段
     * @param contractId
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractChangeVO> addConvertByConId(Long contractId, Long changeId) {
        ContractChangeVO vo = service.addConvertByConId(contractId, changeId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Description  查询当前合同下变更列表
     * @param id
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractChangeVO> queryDetailRecord(Long id) {
        ContractChangeVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author yangst
     * @Description  查询变更记录
     * @param
     */
    @RequestMapping(value = "/queryChangeRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractChangeVO> queryChangeRecord(Long contractId, Long changeId) {
        ContractChangeVO vo = service.queryChangeRecord(contractId, changeId);
        return CommonResponse.success("变更记录查询成功！",vo);
    }
    /**
     * @Author yangst
     * @Description  查询变更对比
     * @param
     */
    @RequestMapping(value = "/queryChangeCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryChangeCompare(Long id) {
        Map returnMap = service.queryChangeCompare(id);
        return CommonResponse.success("查询对比数据成功！", returnMap);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractChangeVO> vos) {
        return service.deleteById(vos.get(0).getId());
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ContractChangeEntity> page = service.queryPage(param,false);
        IPage<ContractChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContractChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ContractChange-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refContractChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractChangeVO>> refContractChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ContractChangeEntity> page = service.queryPage(param,false);
        IPage<ContractChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
