package com.ejianc.business.promaterial.delivery.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import org.springframework.web.multipart.MultipartFile;

/**
 * 消耗材-发货单
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("delivery")
@Api(value = "消耗材-发货单", tags = {"消耗材-发货单"})
public class DeliveryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XHC-DELIVERY-CODE";//此处需要根据实际修改

    @Autowired
    private IDeliveryService service;
    @Autowired
    private ICheckService checkService;

    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DeliveryVO saveOrUpdateVO) {
        DeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, DeliveryEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }



    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(@RequestParam Long id) {
        DeliveryEntity entity = service.selectById(id);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        List<CheckEntity> checkEntityList = checkService.list(new QueryWrapper<CheckEntity>().in("bill_state",Arrays.asList(1,3)).eq("delivery_id", vo.getId()));
        vo.setCheckList(BeanMapper.mapList(checkEntityList, CheckVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }




    @ApiOperation("发货单关闭接口")
    @RequestMapping(value = "/closeDelivery", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> closeDelivery(@RequestParam Long id) {
        DeliveryVO vo = service.closeDelivery(id);
        return CommonResponse.success("发货单关闭成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DeliveryVO vo : vos) {
            }
        }
        service.removeByIds(vos.stream().map(DeliveryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @ApiOperation("查询采购方待验收列表")
    @RequestMapping(value = "/queryCGFList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryCGFList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orderBillCode");
        fuzzyFields.add("deliverName");
        fuzzyFields.add("licensePlate");
        fuzzyFields.add("deliveryNum");
        fuzzyFields.add("customerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //移动端特殊处理
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(Long.valueOf(param.getParams().get("orgId").getValue().toString())).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<DeliveryEntity> page = service.queryPage(param, false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<DeliveryVO> deliveryVOS = BeanMapper.mapList(page.getRecords(), DeliveryVO.class);
        pageData.setRecords(deliveryVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orderBillCode");
        fuzzyFields.add("deliverName");
        fuzzyFields.add("licensePlate");
        fuzzyFields.add("deliveryNum");
        fuzzyFields.add("customerName");

        //供方我的框架协议
        //1, 先根据供方租户主键查询到合作的企业(采购租户的租户主键)
        // 查询合作企业的租户主键
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
        logger.info("合作企业信息：{}",systemIdList);
        if(CollectionUtils.isNotEmpty(systemIdList)){
            param.getParams().put("tenant_id", new Parameter("in",systemIdList));
        }
        // 2，先根据供方租户主键查询到自己在采购方对应的供应商主键
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();

        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));

        IPage<DeliveryEntity> page = service.queryPage(param,false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<DeliveryVO> deliveryVOS = BeanMapper.mapList(page.getRecords(), DeliveryVO.class);
        pageData.setRecords(deliveryVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orderBillCode");
        fuzzyFields.add("deliverName");
        fuzzyFields.add("licensePlate");
        fuzzyFields.add("deliveryNum");
        fuzzyFields.add("customerName");

        //供方我的框架协议
        //1, 先根据供方租户主键查询到合作的企业(采购租户的租户主键)
        // 查询合作企业的租户主键
        CommonResponse<List<String>> cooperResponse = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!cooperResponse.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",cooperResponse.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = cooperResponse.getData();
        logger.info("合作企业信息：{}",systemIdList);
        if(CollectionUtils.isNotEmpty(systemIdList)){
            param.getParams().put("tenant_id", new Parameter("in",systemIdList));
        }
        // 2，先根据供方租户主键查询到自己在采购方对应的供应商主键
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();

        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));

        List<DeliveryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        List<DeliveryVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            voList = BeanMapper.mapList(list,DeliveryVO.class);
            voList.forEach(c -> {
                if(null!=c.getDeliverState()){
                    switch (c.getDeliverState()){
                        case  0:c.setDeliverStateName("待送货");break;
                        case  1:c.setDeliverStateName("部分送货");break;
                        case  2:c.setDeliverStateName("已送货");break;
                    }
                }
                if(null!=c.getOrderFlag()){
                    switch (c.getOrderFlag()){
                        case  0:c.setOrderFlagName("正常");break;
                        case  1:c.setOrderFlagName("已关闭");break;
                    }
                }
                if(null!=c.getCheckState()){
                    switch (c.getCheckState()){
                        case  0:c.setCheckStateName("未验收");break;
                        case  1:c.setCheckStateName("部分验收");break;
                        case  2:c.setCheckStateName("全部验收");break;
                    }
                }
                //流程状态
                c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DeliveryEntity> page = service.queryPage(param,false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }



    // 国万新做

    @ApiOperation("初始化送货单详情")
    @RequestMapping(value = "/queryInitDelivery", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryInitDelivery(@RequestBody OrderVO saveOrUpdateVO) {
        return CommonResponse.success("初始化成功！",service.queryInitDelivery(saveOrUpdateVO));
    }

    @ApiOperation("查询详情(验收用)")
    @RequestMapping(value = "/queryDetailToCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetailToCheck(@RequestParam Long id) {
        CheckVO vo = service.queryDetailToCheck(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }
}
