package com.ejianc.business.promaterial.delivery.service;

import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 消耗材-发货单
 * 
 * @author generator
 * 
 */
public interface IDeliveryService extends IBaseService<DeliveryEntity> {


    DeliveryVO closeDelivery(Long id);


    DeliveryVO queryInitDelivery(OrderVO deliveryVO);


    CheckVO queryDetailToCheck(Long id);

    /**
     * 根据orderId查询当前订单下已送货的材料数量
     *
     * @param orderId 订单id
     * @return 已送货材料数量
     */
    Map<Long, BigDecimal> sumDeliveredGroupByDetailId(Long orderId);
}
