package com.ejianc.business.promaterial.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.finance.bean.PayRecordSettleEntity;
/**
 * 付款申请记录实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_record")
public class PayRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="payapply_id")
    private Long payapplyId; // 付款申请主键
    @TableField(value="apply_type")
    private String applyType; // 付款申请类型：合同付款，零星采购，报销，押金
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="fee_type")
    private Long feeType; // 支付类型：1-预付款，2-过程款，3-其他
    @TableField(value="apply_user_id")
    private Long applyUserId; // 申请人
    @TableField(value="apply_user_name")
    private String applyUserName; // 申请人名称
    @TableField(value="apply_time")
    private Date applyTime; // 申请时间
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="supplier_employee_id")
    private Long supplierEmployeeId; // 供方经办人
    @TableField(value="supplier_employee_name")
    private String supplierEmployeeName; // 供方经办人名称
    @TableField(value="receive_unit_id")
    private Long receiveUnitId; // 收款单位
    @TableField(value="receive_unit_name")
    private String receiveUnitName; // 收款单位名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    @TableField(value="approve_time")
    private Date approveTime; // 审批时间
    @TableField(value="this_pay_mny")
    private BigDecimal thisPayMny; // 本期支付金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="account_id")
    private Long accountId; // 收款账户
    @TableField(value="account_name")
    private String accountName; // 账户名称
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_bank")
    private String accountBank; // 开户行
    @TableField(value="pay_way")
    private Long payWay; // 付款方式
    @TableField(value="pay_way_name")
    private String payWayName; // 付款方式名称
    @TableField(value="explanation")
    private String explanation; // 说明：付款事由
    @TableField(value="account_bank_id")
    private Long accountBankId; // 开户行
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="payRecordSettleService")
    private List<PayRecordSettleEntity> settleList = new ArrayList<>(); // 付款申请记录结算实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }
    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }
    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }
    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }
    public BigDecimal getThisPayMny() {
        return thisPayMny;
    }

    public void setThisPayMny(BigDecimal thisPayMny) {
        this.thisPayMny = thisPayMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }
    public Long getPayWay() {
        return payWay;
    }

    public void setPayWay(Long payWay) {
        this.payWay = payWay;
    }
    public String getPayWayName() {
        return payWayName;
    }

    public void setPayWayName(String payWayName) {
        this.payWayName = payWayName;
    }
    public String getExplanation() {
        return explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }
    public Long getAccountBankId() {
        return accountBankId;
    }

    public void setAccountBankId(Long accountBankId) {
        this.accountBankId = accountBankId;
    }


    public List<PayRecordSettleEntity> getSettleList() {
        return settleList;
    }

    public void setSettleList(List<PayRecordSettleEntity> settleList) {
        this.settleList = settleList;
    }
}
