package com.ejianc.business.promaterial.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 付款申请记录结算实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_record_settle")
public class PayRecordSettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="record_id")
    private Long recordId; // 付款记录主键
    @TableField(value="payapply_id")
    private Long payapplyId; // 付款申请单主键
    @TableField(value="settle_id")
    private Long settleId; // 来源结算单主键
    @TableField(value="settle_apply_mny")
    private BigDecimal settleApplyMny; // 申请金额
    @TableField(value="settle_pay_mny")
    private BigDecimal settlePayMny; // 本期支付金额
    /**
     * 退回金额
     */
    @TableField(exist = false)
    private BigDecimal returnPayMny;

    public BigDecimal getReturnPayMny() {
        return returnPayMny;
    }

    public void setReturnPayMny(BigDecimal returnPayMny) {
        this.returnPayMny = returnPayMny;
    }



    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    public BigDecimal getSettleApplyMny() {
        return settleApplyMny;
    }

    public void setSettleApplyMny(BigDecimal settleApplyMny) {
        this.settleApplyMny = settleApplyMny;
    }
    public BigDecimal getSettlePayMny() {
        return settlePayMny;
    }

    public void setSettlePayMny(BigDecimal settlePayMny) {
        this.settlePayMny = settlePayMny;
    }
    
}
