package com.ejianc.business.promaterial.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.promaterial.finance.vo.*;
import com.ejianc.business.promaterial.utils.BigDecimalUtil;
import com.ejianc.business.promaterial.utils.MathUtil;
import com.ejianc.business.promaterial.utils.NumberToCN;
import com.ejianc.business.promaterial.utils.ParamSearchUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractService;

/**
 * 合同付款申请实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payContract")
public class PayContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayContractService contractService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改



    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value = "/queryAllList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryAllList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        JSONObject page = contractService.queryAllList(param,"main");
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * excel导出全部页签数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelAllList", method = RequestMethod.POST)
    @ResponseBody
    public void excelAllList(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        List<PayApplyPubVO> records = new ArrayList<>();
        JSONObject jsonObject = contractService.queryAllList(queryParam,"main");
        if (jsonObject != null && jsonObject.get("records") != null) {
            records = (List<PayApplyPubVO>) jsonObject.get("records");
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("all-payapply-export.xlsx", beans, response);
    }
    /**
     * excel导出全部页签数据(支付记录维度)
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelAllDetailList", method = RequestMethod.POST)
    @ResponseBody
    public void excelAllDetailList(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        List<PayApplyPubVO> records = new ArrayList<>();
        JSONObject jsonObject = contractService.queryAllList(queryParam,"detail");
        if (jsonObject != null && jsonObject.get("records") != null) {
            records = (List<PayApplyPubVO>) jsonObject.get("records");
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("all-detail-payapply-export.xlsx", beans, response);
    }


    @RequestMapping(value = "/handleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayContractVO> handleData() {
        long start = System.currentTimeMillis();

        QueryParam param = new QueryParam();
        List<PayContractEntity> payContractEntities = contractService.queryList(param);
        for (PayContractEntity payContractEntity : payContractEntities) {

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, payContractEntity.getContractId()));
            queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, payContractEntity.getOrgId()));
            queryParam.getParams().put("applyTime", new Parameter(QueryParam.LT, payContractEntity.getApplyTime()));

            List<PayContractEntity> entities = contractService.queryList(queryParam);
            BigDecimal sumApplyMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(entities)) {
                //截止上期已申请
                for (PayContractEntity pce : entities) {
                    sumApplyMny = BigDecimalUtil.safeAdd(sumApplyMny, pce.getApplyMny());
                }
                payContractEntity.setSumApplyMny(sumApplyMny);
            }
            //金额大写
            payContractEntity.setApplyMnyCn(NumberToCN.number2CN(payContractEntity.getApplyMny()));

            // 截止本期申请比例（按合同
            BigDecimal sumApplyMnyWithThis = BigDecimalUtil.safeAdd(sumApplyMny, payContractEntity.getApplyMny());
            BigDecimal _endthisPayScaleByContract = BigDecimalUtil.safeDiv(sumApplyMnyWithThis, payContractEntity.getContractMny());
            BigDecimal endthisPayScaleByContract = BigDecimalUtil.safeMultiply(_endthisPayScaleByContract, BigDecimalUtil.ONE_HUNDRED);

            payContractEntity.setEndthisPayScaleByContract(endthisPayScaleByContract);


        }
        contractService.saveOrUpdateBatch(payContractEntities);

        long end = System.currentTimeMillis();
        String msg = "程序运行时间：" + (end - start) + "ms，处理数据：" + payContractEntities.size() + "条。";
        return CommonResponse.success(msg);
    }

    /**
     * @param payContractVO
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayContractVO> saveOrUpdate(@RequestBody PayContractVO payContractVO) {
        List<PayContractSettleVO> settleVOS = payContractVO.getSettleVOList();
        if (CollectionUtils.isNotEmpty(settleVOS)) {
            List<Long> settleIds = settleVOS.stream().filter(t -> !"del".equals(t.getRowState())).map(e -> e.getSettleId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(settleIds)) {
                Map<Long, BigDecimal> settleApplyData = contractService.getApplyMnyHasFree(settleIds, payContractVO.getId());
                for (PayContractSettleVO settleVO : settleVOS) {
                    BigDecimal settleTaxMny = settleVO.getSettleMny();
                    BigDecimal sumApplyMny = settleApplyData.get(settleVO.getSettleId());
                    BigDecimal sumApplyMnyHasThis = ComputeUtil.safeAdd(sumApplyMny, settleVO.getBodyApplyMny());
                    if (ComputeUtil.isGreaterThan(ComputeUtil.scaleTwo(sumApplyMnyHasThis), ComputeUtil.scaleTwo(settleTaxMny))) {
                        throw new BusinessException("结算单【单据编号：" + settleVO.getSettleCode() + "】累计申请金额(含本期)：" + ComputeUtil.scaleTwo(sumApplyMnyHasThis) + " 大于结算金额：" + ComputeUtil.scaleTwo(settleTaxMny) + " ，不能保存！");
                    }
                }
            }
        }

        PayContractVO backVO = contractService.insertOrUpdate(payContractVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }


    /**
     * @param vo
     * @description: 更新是否含有发票
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.PayContractVO>
     * @author songlx
     * @date: 2021/7/22
     */
    @RequestMapping(value = "/updateInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayContractVO> updateInfo(@RequestBody PayContractVO vo) {
        PayContractEntity entity = BeanMapper.map(vo, PayContractEntity.class);
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            //更新是否含有发票
            LambdaUpdateWrapper<PayContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(PayContractEntity::getId, entity.getId());
            updateWrapper.set(PayContractEntity::getInvoiceFlag, entity.getInvoiceFlag());
            contractService.update(updateWrapper);
        }

        return CommonResponse.success("修改成功！", vo);
    }


    /**
     * @param id
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayContractVO> queryDetail(Long id) {
        PayContractVO backVO = contractService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }

    /**
     * @param id
     * @Author yqls
     * @Date 2020/5/28
     * @Description queryPrint 查询打印详情
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayContract", contractService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！", json);
    }

    /**
     * @param param
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
        ParamSearchUtil.handleQueryParam(param);
        JSONObject page = contractService.queryPageJson(param, false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryApproveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("approveTime", QueryParam.DESC);
        JSONObject page = contractService.queryPageJson(param, false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayContractVO> vos) {
        List<Long> ids = vos.stream().map(PayContractVO::getId).collect(Collectors.toList());
        String msg = contractService.delete(ids);
        return CommonResponse.success("删除成功！");
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        // 单据权限控制支持--仅制单人查看
        if (StringUtils.isNotEmpty(queryParam.getBillTypeId()) && contractService.viewSelf(queryParam.getBillTypeId()) && queryParam.getParams().get("createUserCode") == null && queryParam.getParams().get("create_user_code") == null) {
            queryParam.getParams().put("createUserCode", new Parameter("eq", InvocationInfoProxy.getUsercode()));
        }

        List<PayContractVO> supplierVos = contractService.queryExportList(queryParam);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("contract-payapply-export.xlsx", beans, response);
    }




    /**
     * 查询收款账户信息
     *
     * @param receiveUnitId
     * @return
     */
    @RequestMapping(value = "/queryReceiveInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayContractVO> queryReceiveInfo(Long receiveUnitId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("receiveUnitId", new Parameter(QueryParam.EQ, receiveUnitId));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<PayContractEntity> entityList = contractService.queryList(queryParam, false);
        PayContractVO backVO = !entityList.isEmpty() ? BeanMapper.map(entityList.get(0), PayContractVO.class) : new PayContractVO();
        return CommonResponse.success("查询数据成功！", backVO);
    }

    /**
     * @param contractId
     * @param orgId
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询预付款金额与已支付金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "getSumPayMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SumPayMnyVO> getSumPayMny(@RequestParam(value = "contractId", required = true) Long contractId,
                                                    @RequestParam(value = "orgId", required = true) Long orgId,
                                                    @RequestParam(value = "applyMnyContainFree", required = false) Boolean applyMnyContainFree
    ) {
        SumPayMnyVO vo = contractService.getSumPayMny(contractId, orgId, applyMnyContainFree);
        return CommonResponse.success("查询成功！", vo);
    }


    /**
     * @param param
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询待处理列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPendingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryPendingList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        JSONObject page = contractService.queryPendingPageJson(param, false);
        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * excel导出待处理
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPending", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportPending(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        List<PayApplyPubVO> records = contractService.queryExportPendingList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("pending-payapply-export.xlsx", beans, response);
    }

    /**
     * @param vos
     * @Author yqls
     * @Date 2020/8/04
     * @Description saveOrUpdate 批量支付
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/batchConfirm", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> batchConfirm(@RequestBody List<PayApplyPubVO> vos) {
        String msg = contractService.batchConfirm(vos);
        return CommonResponse.success("批量支付成功！");
    }


    /**
     * @param param
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取付款申请 合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
        return CommonResponse.success("查询成功！", contractService.getTotalColumnInfo(param, false));
    }


    /**
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取支出管理 合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getApproveTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("approveTime", QueryParam.DESC);
        return CommonResponse.success("查询成功！", contractService.getApproveTotalColumnInfo(param, false));
    }

    /**
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取支出管理(未处理) 合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getPendingTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getPendingTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        return CommonResponse.success("查询成功！", contractService.getPendingTotalColumnInfo(param, false,"pending"));
    }

    @RequestMapping(value = "getALLTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getALLTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        return CommonResponse.success("查询成功！", contractService.getPendingTotalColumnInfo(param, false,"all"));
    }


    /**
     * 付款关闭
     *
     * @param id 付款申请id
     *
     * @return {@link CommonResponse}<{@link Void}>
     */
    @RequestMapping(value = "/closePayment", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Void> closePayment(@RequestParam(value = "id") Long id) {
        contractService.closePayment(id);
        return CommonResponse.success("付款关闭成功！");
    }
}
