package com.ejianc.business.promaterial.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.finance.vo.*;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 合同付款申请实体
 * 
 * @author generator
 * 
 */
public interface IPayContractService extends IBaseService<PayContractEntity> {
    PayContractVO insertOrUpdate(PayContractVO payContractVO);

    PayContractVO queryDetail(Long id);

    List<PayContractVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);


    /**
     * @description:
     *
     * @param contractId
     * @param orgId
     * @param applyMnyContainFree 截止上期已申请金额是否包含自由态的applyMnyContainFreeFlag
     * @return {@link SumPayMnyVO}
     * @author songlx
     * @date: 2022/12/28
     */
    SumPayMnyVO getSumPayMny(Long contractId, Long orgId, Boolean applyMnyContainFree);


    JSONObject queryPendingPageJson(QueryParam param, boolean isEs);

    JSONObject queryAllList(QueryParam param,String type);

    List<PayApplyPubVO> queryExportPendingList(QueryParam param);

    String batchConfirm(List<PayApplyPubVO> vos);


    TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getPendingTotalColumnInfo(QueryParam param, boolean isEs,String type);


    /**
     * 付款关闭
     *
     * @param id 付款申请id
     */
    void closePayment(Long id);


    Map<Long, BigDecimal> getApplyMnyHasFree(List<Long> settleIds, Long id);

    boolean writeBackSumApplyMny(Long billId, PayContractEntity entity, boolean b);

}
