package com.ejianc.business.promaterial.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.promaterial.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.bean.PayContractSettleEntity;
import com.ejianc.business.promaterial.finance.bean.PayRecordEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.finance.service.IPayContractSettleService;
import com.ejianc.business.promaterial.finance.service.IPayRecordService;
import com.ejianc.business.promaterial.utils.MathUtil;
import com.ejianc.business.promaterial.utils.NumberToCN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service("payContract") 
public class PayContractBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IPayContractService service;

	@Autowired
	private IPayContractSettleService settleService;

	@Autowired
	private IPayRecordService recordService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PayContractEntity entity = service.selectById(billId);
		//回写结算单累计申请金额、剩余可申请金额
		service.writeBackSumApplyMny(billId, entity, true);

		LambdaUpdateWrapper<PayContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(PayContractEntity::getId, billId);
		updateWrapper.set(PayContractEntity::getApproveTime, new Date());
		service.update(updateWrapper);
		return CommonResponse.success("回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PayContractEntity entity = service.selectById(billId);
		// 校验审批时间
		if (!validateApproveTime(entity)) return CommonResponse.error("该单据在本组织下非最新付款申请，不能撤回!");
		// 校验存在未生效单据
		if (!validateEffective(entity)) return CommonResponse.error("该合同在本组织下存在未生效付款申请，不能撤回!");

		return CommonResponse.success("校验通过");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PayContractEntity entity = service.selectById(billId);
		// 已确认回写，未确认不回写


		//回写结算单累计申请金额、剩余可申请金额
		service.writeBackSumApplyMny(billId, entity, false);

		// 逆回写时，重置付款申请子表已支付金额
		LambdaUpdateWrapper<PayContractSettleEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.eq(PayContractSettleEntity::getPayapplyId, billId);
		wrapper.set(PayContractSettleEntity::getSumPayMny, BigDecimal.ZERO);
		if (Optional.ofNullable(entity.getCloseFlag()).orElse(false)) {
			// 还原子表申请金额
			wrapper.setSql("body_apply_mny = body_apply_mny_before_close");

			// 还原付款申请主表申请金额
			entity.setApplyMny(entity.getApplyMnyBeforeClose());
			entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));
			// 重置付款申请主表关闭字段
			entity.setApplyMnyBeforeClose(null);
			entity.setCloseFlag(Boolean.FALSE);
			entity.setCloseState(null);
			entity.setCloseTime(null);
			entity.setCloseUser(null);
		}
		settleService.update(wrapper);

		entity.setPayMny(null);
		entity.setPayStatus(1);
		entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);
		entity.setApproveTime(null);
		entity.setConfirmTime(null);
		service.saveOrUpdate(entity);

		// 删除付款记录表，因service.writeBackSumPayMny已全部撤回已支付合同及结算单，则不需要重新撤回结算单已支付金额，如需要再处理
		recordService.remove(new QueryWrapper<PayRecordEntity>().eq("payapply_id", billId));


		logger.info("进入审批后回写--- entity:"+entity);
		return CommonResponse.success("回调处理成功！");
	}

	/**
	 * 校验存在未生效单据
	 * @param entity
	 * @return
	 */
	private boolean validateEffective(PayContractEntity entity) {
		Long contractId = entity.getContractId();
		QueryWrapper wrapper = new QueryWrapper<PayContractEntity>();
		wrapper.eq("contract_id", contractId);
		wrapper.eq("org_id", entity.getOrgId());
		wrapper.ne("bill_state", 1);
		wrapper.ne("bill_state", 3);
		List<PayContractEntity> list = service.list(wrapper);
		if(!list.isEmpty()){
			return false;
		}
		return true;
	}

	/**
	 * 校验审批时间
	 * @param entity
	 * @return
	 */
	private boolean validateApproveTime(PayContractEntity entity) {
		Long contractId = entity.getContractId();
		QueryWrapper wrapper = new QueryWrapper<PayContractEntity>();
		wrapper.eq("contract_id", contractId);
		wrapper.eq("org_id", entity.getOrgId());
		/* edit by yqls 2021-06-16 使用申请时间判断 */
		wrapper.gt("apply_time", entity.getApplyTime());
		List<PayContractEntity> list = service.list(wrapper);
		if(!list.isEmpty()){
			return false;
		}
		return true;
	}


}
