package com.ejianc.business.promaterial.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.bean.PayContractSettleEntity;
import com.ejianc.business.promaterial.finance.bean.PayRecordSettleEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.finance.service.IPayContractSettleService;
import com.ejianc.business.promaterial.finance.service.IPayRecordSettleService;
import com.ejianc.business.promaterial.finance.vo.PayRecordVO;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.utils.MathUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.finance.mapper.PayRecordMapper;
import com.ejianc.business.promaterial.finance.bean.PayRecordEntity;
import com.ejianc.business.promaterial.finance.service.IPayRecordService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 付款申请记录实体
 * 
 * @author generator
 * 
 */
@Service("payRecordService")
public class PayRecordServiceImpl extends BaseServiceImpl<PayRecordMapper, PayRecordEntity> implements IPayRecordService{

    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPayContractSettleService contractSettleService;

    @Autowired
    private IPayRecordSettleService settleService;
    @Autowired
    private ISettlementService settlementService;

    @Override
    public PayRecordVO insertOrUpdate(PayRecordVO vo, boolean isBatchPay) {
        PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);

        BigDecimal msgPayMny = BigDecimal.ZERO;
            PayContractEntity contract = contractService.selectById(entity.getPayapplyId());

            entity.setBillCode(contract.getBillCode());// 单据编号
            entity.setContractId(contract.getContractId());
            // 合同
            entity.setContractName(contract.getContractName());
            entity.setProjectId(contract.getProjectId());// 项目
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());// 组织
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());// 申请人
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());// 申请时间
            entity.setApplyMny(contract.getApplyMny());// 申请金额
            entity.setReceiveUnitId(contract.getReceiveUnitId());// 收款单位
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());
            //付款-预付款
            entity.setExplanation(contract.getPayReason()); // 付款事由
            // 保存主表
            super.saveOrUpdate(entity);
            contract.setPayStatus(2);// 已支付
            contract.setConfirmTime(entity.getConfirmTime());// 确认时间
            contract.setEmployeeId(entity.getEmployeeId());// 经办人
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = contract.getPayMny();

            // 查询付款记录
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper<PayRecordEntity> wrapper = changeToQueryWrapper(queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = super.getOne(wrapper);
            if (payRecordEntity != null) {
                contract.setPayAccountName(payRecordEntity.getAccountName());
                contract.setPayAccountNum(payRecordEntity.getAccountNum());
                contract.setPayAccountBank(payRecordEntity.getAccountBank());
            }

            // 保存
            contractService.saveOrUpdate(contract);
            // 计算结算单支付金额并保存
            List<PayRecordSettleEntity> settleList = this.calculateSettlePayMny(entity);

            // 确认支付回写累计付款与累计预付款金额
            // this.writeBackSumPayMny(entity.getPayapplyId(), entity, settleList, true);
        //支付成功后发送消息给申请人
        PayRecordVO payRecordVO = BeanMapper.map(entity, PayRecordVO.class);
        payRecordVO.setMsgPayMny(msgPayMny);//含本期累计支付金额
        payRecordVO.setMsgBillCode(entity.getBillCode());
        payRecordVO.setMsgId(entity.getId());
        String[] receivers = String.valueOf(payRecordVO.getApplyUserId()).split(",");
        //payRecordMessageService.sendMsg(payRecordVO, receivers, NoticeEnum.PAY_SUCCESS);
        return payRecordVO;
    }
    /**
     * 计算结算单支付金额并保存
     * @param entity
     */
    private List<PayRecordSettleEntity> calculateSettlePayMny(PayRecordEntity entity) {
        BigDecimal pendPayMny = entity.getThisPayMny();// 待结算单分摊付款金额。初始值为本期支付金额
        List<PayContractSettleEntity> contractSettleList = contractSettleService.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", entity.getPayapplyId()));
        List<PayRecordSettleEntity> settleLsit = new ArrayList<>();
        for (PayContractSettleEntity contractSettle : contractSettleList) {
            BigDecimal surplusPayMny = MathUtil.safeSub(contractSettle.getBodyApplyMny(), contractSettle.getSumPayMny());// 剩余可支付金额
            // 如果有待支付且该结算单有剩余可支付金额
            if (MathUtil.safeCompareTo(pendPayMny, BigDecimal.ZERO) > 0 && MathUtil.safeCompareTo(surplusPayMny, BigDecimal.ZERO) > 0) {
                PayRecordSettleEntity settle = new PayRecordSettleEntity();
                settle.setRecordId(entity.getId());
                settle.setPayapplyId(entity.getPayapplyId());
                settle.setSettleId(contractSettle.getSettleId());
                settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
                if (MathUtil.safeCompareTo(pendPayMny, surplusPayMny) > 0) {// 待支付大于剩余可支付
                    settle.setSettlePayMny(surplusPayMny);// 支付剩余可支付金额
                } else {
                    settle.setSettlePayMny(pendPayMny);// 支付所有待支付金额
                }
                pendPayMny = MathUtil.safeSub(pendPayMny, settle.getSettlePayMny());// 待支付减去已支付金额
                contractSettle.setSumPayMny(MathUtil.safeAdd(contractSettle.getSumPayMny(), settle.getSettlePayMny()));// 结算单累计已支付金额
                settleLsit.add(settle);
            }
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            settleService.saveOrUpdateBatch(settleLsit);
            contractSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }


    /**
     * 付款退回
     *
     * @param vo 付款申请记录
     *
     * @return {@link PayRecordVO}
     */
    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);
        // 增加一个负数的付款记录单；
        entity.setThisPayMny(entity.getThisPayMny().negate());
        PayContractEntity contract = contractService.selectById(entity.getPayapplyId());
        entity.setBillCode(contract.getBillCode());// 单据编号
        entity.setContractId(contract.getContractId());// 合同
        entity.setContractName(contract.getContractName());
        entity.setProjectId(contract.getProjectId());// 项目
        entity.setProjectName(contract.getProjectName());
        entity.setOrgId(contract.getOrgId());// 组织
        entity.setOrgName(contract.getOrgName());
        entity.setApplyUserId(contract.getApplyUserId());// 申请人
        entity.setApplyUserName(contract.getApplyUserName());
        entity.setApplyTime(contract.getApplyTime());// 申请时间
        entity.setApplyMny(contract.getApplyMny());// 申请金额
        entity.setReceiveUnitId(contract.getReceiveUnitId());// 收款单位
        entity.setReceiveUnitName(contract.getReceiveUnitName());
        entity.setFeeType(contract.getFeeType());//付款-预付款
        entity.setExplanation(contract.getPayReason()); // 付款事由
        super.saveOrUpdate(entity);

        // 退回后回写合同付款申请单
        contract.setPayStatus(2);// 已支付
        contract.setConfirmTime(entity.getConfirmTime());// 确认时间
        contract.setEmployeeId(entity.getEmployeeId());// 经办人
        contract.setEmployeeName(entity.getEmployeeName());
        // 【已付款金额】修改为【已付款金额】-【退回金额】 即：【已付款金额】=【已付款金额】+ （-【退回金额】）
        contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));// 累计支付金额

        contractService.saveOrUpdate(contract);

        // 付款退回修改表体每个结算单的【本期支付金额】：按照结算单时间，后进先出进行回退重新分摊
        List<PayRecordSettleEntity> settleList = this.calcSettlePayMnyAfterReturnPayment(entity);

        // 确认支付回写累计付款与累计预付款金额
        //this.writeBackSumPayMnyAfterReturnPayment(entity, settleList);

        // 付款关闭
        if (vo.getClosed()) {
            contractService.closePayment(vo.getPayapplyId());
        }

        //支付成功后发送消息给申请人
        PayRecordVO payRecordVO = BeanMapper.map(entity, PayRecordVO.class);
        return payRecordVO;
    }


    /**
     * 付款退回后重新分摊
     *
     * @param entity 付款申请记录
     *
     * @return {@link List}<{@link PayRecordSettleEntity}>
     */
    private List<PayRecordSettleEntity> calcSettlePayMnyAfterReturnPayment(PayRecordEntity entity) {
        List<PayRecordSettleEntity> settleLsit = new ArrayList<>();
        BigDecimal pendPayMny = entity.getThisPayMny().negate();// 待结算单分摊付款金额。初始值为本期支付金额
        // 按照结算单时间，后进先出进行回退
        List<PayContractSettleEntity> contractSettleList = contractSettleService.list(new LambdaQueryWrapper<PayContractSettleEntity>()
                .eq(PayContractSettleEntity::getPayapplyId, entity.getPayapplyId())
                .orderByDesc(PayContractSettleEntity::getCreateTime));

        for (PayContractSettleEntity contractSettle : contractSettleList) {
            if (MathUtil.safeCompareTo(pendPayMny, BigDecimal.ZERO) > 0) {
                PayRecordSettleEntity settle = new PayRecordSettleEntity();
                settle.setRecordId(entity.getId());
                settle.setPayapplyId(entity.getPayapplyId());
                settle.setSettleId(contractSettle.getSettleId());
                settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
                // 够摊
                if (MathUtil.safeCompareTo(contractSettle.getSumPayMny(), pendPayMny) >= 0) {
                    settle.setReturnPayMny(pendPayMny);
                    contractSettle.setSumPayMny(MathUtil.safeSub(contractSettle.getSumPayMny(), pendPayMny));
                    pendPayMny = BigDecimal.ZERO;
                } else {
                    settle.setReturnPayMny(contractSettle.getSumPayMny());
                    pendPayMny = MathUtil.safeSub(pendPayMny, contractSettle.getSumPayMny());// 待支付减去已支付金额
                    contractSettle.setSumPayMny(BigDecimal.ZERO);
                }
                settle.setSettlePayMny(contractSettle.getSumPayMny());
                settleLsit.add(settle);
            }
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            settleService.saveOrUpdateBatch(settleLsit);
            contractSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }


}
