package com.ejianc.business.promaterial.pricelib.service.impl;

import com.ejianc.business.promaterial.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.promaterial.pricelib.bean.PriceHistoryEntity;
import com.ejianc.business.promaterial.pricelib.mapper.PriceHistoryMapper;
import com.ejianc.business.promaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.promaterial.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.HistoryTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceHistoryVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 价格库-历史价明细
 * 
 * @author generator
 * 
 */
@Service("priceHistoryService")
public class PriceHistoryServiceImpl extends BaseServiceImpl<PriceHistoryMapper, PriceHistoryEntity> implements IPriceHistoryService{
    //TODO 待补值
    private static final String PRICE_CHECK_CODE = "";
    @Autowired
    private IParamConfigApi paramConfigApi;
//    @Autowired
//    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IPriceContractService priceContractService;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void initPriceHistory() {
        logger.info("---历史价格init开始---");
//        //1.先执行全删除操作
//        logger.info("---数据全删除操作开始---");
//        baseMapper.delPriceHistoryAll();
//        logger.info("---数据插入操作开始---");
//        //2.执行数据插入
//        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.材料价格库.getCode()));
//        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.材料价格库.getCode());
//        if(!commonResponse.isSuccess()){
//            throw new BusinessException(commonResponse.getMsg());
//        }
//        List<PriceDepotParamSetDTO> data = commonResponse.getData();
//        logger.info("返回参数--{}",JSONObject.toJSONString(data));
//        if(CollectionUtils.isEmpty(data)){//为空结束
//            return;
//        }
//        Date nowDate = new Date();
//        Map<String,PriceHistoryVO>  fatherPriceHistoryMap = new HashMap<>();//父级
//        Map<String,PriceHistoryVO> sonPriceHistoryMap = new HashMap<>();//子级
//        for (PriceDepotParamSetDTO paramSetDTO : data) {
//            if(null==paramSetDTO.getSource()){
//                continue;
//            }
//            String description = HistoryTypeEnum.getEnumByStateCode(paramSetDTO.getSource()).getDescription();
//            Integer code = HistoryTypeEnum.getEnumByStateCode(paramSetDTO.getSource()).getCode();
//            Date beforeDate = getMonthBefore(nowDate,paramSetDTO.getCycle());
//            logger.info("当前时间--{}-前-{}--个月时间--{}", DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",nowDate),paramSetDTO.getCycle().toString(),DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",beforeDate));
//            if(!paramSetDTO.getLeafFlag()){//获取父级明细
//                List<PriceLibVO> priceLibVOS = priceContractService.queryPriceLibList(beforeDate, nowDate, paramSetDTO.getCategoryId());
//                if(CollectionUtils.isEmpty(priceLibVOS)){
//                    continue;
//                }
//                List<PriceHistoryVO> priceHistoryVOS = BeanMapper.mapList(priceLibVOS, PriceHistoryVO.class);
//                Map<String,PriceHistoryVO>  priceHistoryVOMap= priceHistoryVOS.stream().map(item -> {
//                    item.setId(item.getMaterialId());
//                    item.setHistoryType(code);
//                    return item;
//                }).collect(Collectors.toMap(t->t.getId().toString(), Function.identity(), (key1, key2) -> key2));
//                fatherPriceHistoryMap.putAll(priceHistoryVOMap);
//                logger.info("父级类型：{},{},数据条数：{}",description,code,priceHistoryVOS.size());
//            }//获取子级结算明细 分类为空则跳过
//            else if(StringUtils.isNotEmpty(paramSetDTO.getCategoryId())){
//                List<PriceLibVO> priceLibVOS = priceContractService.queryPriceLibList(beforeDate, nowDate, paramSetDTO.getCategoryId());
//                if(CollectionUtils.isEmpty(priceLibVOS)){
//                    continue;
//                }
//                List<PriceHistoryVO> priceHistoryVOS = BeanMapper.mapList(priceLibVOS, PriceHistoryVO.class);
//                Map<String,PriceHistoryVO>  priceHistoryVOMap= priceHistoryVOS.stream().map(item -> {
//                    item.setId(item.getMaterialId());
//                    item.setHistoryType(code);
//                    return item;
//                }).collect(Collectors.toMap(t->t.getId().toString(), Function.identity(), (key1, key2) -> key2));
//                duplicates(sonPriceHistoryMap,priceHistoryVOMap);
//                logger.info("子级类型：{},{},数据条数：{},子级分类内码：{}",description,code,priceHistoryVOS.size(),paramSetDTO.getCategoryId());
//            }
//        }
//        duplicates(fatherPriceHistoryMap,sonPriceHistoryMap);
//        if(!fatherPriceHistoryMap.isEmpty()){
//            List<PriceHistoryEntity> priceHistoryEntities = BeanMapper.mapList(fatherPriceHistoryMap.values(), PriceHistoryEntity.class);
//            logger.info("保存数据大小{}条",priceHistoryEntities.size());
//            super.saveOrUpdateBatch(priceHistoryEntities);
//        }
        logger.info("---数据插入操作结束---");
    }
/*去除重复
* 后面覆盖前面
* */
    public void duplicates(Map<String,PriceHistoryVO> oldMap,Map<String,PriceHistoryVO> nowMap){
        if(!oldMap.isEmpty()){
            for (String s : nowMap.keySet()) {
                if(oldMap.containsKey(s)){
                    oldMap.remove(s);
                }
            }
        }
        oldMap.putAll(nowMap);
    }
    /**
     * 获取当前日期n个月前的时间
     * @param nowTime 当前时间
     *  @param num 月份周期
     * @return
     */
    public  Date getMonthBefore(Date nowTime,BigDecimal num){
        if(null==num){
            num = new BigDecimal(0);
        }
        int month = num.intValue();
        Date beforeDate = DateUtil.subMonths(nowTime, month);//获取前几个月时间
        return beforeDate;
    }



    @Override
    public MaterialPriceHistoryApiVO getMaterialPriceHistoryApiVO(Long materialId) {
        PriceHistoryEntity priceHistoryEntity = super.selectById(materialId);
        if(priceHistoryEntity==null){
            return new MaterialPriceHistoryApiVO();
        }
        MaterialPriceHistoryApiVO vo = BeanMapper.map(priceHistoryEntity, MaterialPriceHistoryApiVO.class);
        Map<Long, MaterialPriceHistoryApiVO> guidePriceMap = new HashMap<>();
        guidePriceMap.put(materialId,vo);
        this.queryPriceGuide(guidePriceMap);
        if(HistoryTypeEnum.合同历史价.getCode().equals(vo.getHistoryType())){
            vo.setHistoryPriceArea(vo.getContractPriceArea());
            vo.setHistoryTaxPriceArea(vo.getContractTaxPriceArea());
        }else if(HistoryTypeEnum.结算历史价.getCode().equals(vo.getHistoryType())){
            vo.setHistoryPriceArea(vo.getSettlePriceArea());
            vo.setHistoryTaxPriceArea(vo.getSettleTaxPriceArea());
        }else if(HistoryTypeEnum.验收历史价.getCode().equals(vo.getHistoryType())){
            vo.setHistoryPriceArea(vo.getCheckPriceArea());
            vo.setHistoryTaxPriceArea(vo.getCheckTaxPriceArea());
        }
        String guidePriceArea= guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea()==null?"":guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea();
        vo.setGuidePriceArea(guidePriceArea);
        vo.setGuideTaxPriceArea(guidePriceArea);//目前指导价含税无税一样
        return vo;
    }

    @Override
    public Map<Long, MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOMap(List<Long> materialIds) {
        Map<Long, MaterialPriceHistoryApiVO> map = new HashMap<>();
        if(CollectionUtils.isEmpty(materialIds)){
            return map;
        }
        List<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = this.getMaterialPriceHistoryApiVOS(materialIds);
        if(CollectionUtils.isEmpty(materialPriceHistoryApiVOS)){
            return map;
        }
        map = materialPriceHistoryApiVOS.stream().collect(Collectors.toMap(t -> t.getId(), Function.identity(), (key1, key2) -> key2));
        return map;
    }

    @Override
    public List<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOS(List<Long> materialIds) {
        if(CollectionUtils.isEmpty(materialIds)){
            return new ArrayList<>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, materialIds));
        List<PriceHistoryEntity> priceHistoryList = super.queryList(queryParam);
        if(CollectionUtils.isEmpty(priceHistoryList)){
            return new ArrayList<>();
        }
        List<MaterialPriceHistoryApiVO> historyApiVOS = BeanMapper.mapList(priceHistoryList, MaterialPriceHistoryApiVO.class);
        if(CollectionUtils.isNotEmpty(priceHistoryList)){
            Map<Long, MaterialPriceHistoryApiVO> guidePriceMap = historyApiVOS.stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity(), (key1, key2) -> key2));
            this.queryPriceGuide(guidePriceMap);
            for (MaterialPriceHistoryApiVO vo : historyApiVOS) {
                if(HistoryTypeEnum.合同历史价.getCode().equals(vo.getHistoryType())){
                    vo.setHistoryPriceArea(vo.getContractPriceArea());
                    vo.setHistoryTaxPriceArea(vo.getContractTaxPriceArea());
                }else if(HistoryTypeEnum.结算历史价.getCode().equals(vo.getHistoryType())){
                    vo.setHistoryPriceArea(vo.getSettlePriceArea());
                    vo.setHistoryTaxPriceArea(vo.getSettleTaxPriceArea());
                }else if(HistoryTypeEnum.验收历史价.getCode().equals(vo.getHistoryType())){
                    vo.setHistoryPriceArea(vo.getCheckPriceArea());
                    vo.setHistoryTaxPriceArea(vo.getCheckTaxPriceArea());
                }
                String guidePriceArea= guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea()==null?"":guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea();
                vo.setGuidePriceArea(guidePriceArea);
                vo.setGuideTaxPriceArea(guidePriceArea);//目前指导价含税无税一样
            }
        }
        return  historyApiVOS;
    }

    /**
     * 查询物资指导价
     *
     * @param libMap 价格库信息
     */
    private void queryPriceGuide(Map<Long, MaterialPriceHistoryApiVO> libMap) {
        if (libMap.isEmpty()) return;
        List<Long> materialIdList = new ArrayList<>(libMap.keySet());
        List<PriceGuideDetailEntity> list = priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) return;
        Map<Long, PriceGuideDetailEntity> guideMap = list.stream().collect(Collectors
                .toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, MaterialPriceHistoryApiVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            MaterialPriceHistoryApiVO vo = entry.getValue();
            if (guideMap.containsKey(materialId)) {
                PriceGuideDetailEntity guide = guideMap.get(materialId);
                BigDecimal min = guide.getMinMny() == null ? BigDecimal.ZERO : guide.getMinMny();
                BigDecimal max = guide.getMaxMny() == null ? BigDecimal.ZERO : guide.getMaxMny();
                min = min.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                max = max.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                vo.setGuidePriceArea(min + "-" + max);
            }
        }
    }

    @Override
    public Boolean historyPriceShow(Integer priceCheckType) {
        Boolean flag = true;
        return flag;
    }
}
