package com.ejianc.business.promaterial.settlement.service.impl;

import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

//import com.ejianc.business.promaterial.out.bean.OutStoreEntity;

@Service("settlement") 
public class SettlementBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private ISettlementService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private SessionManager sessionManager;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		SettlementEntity entity = service.selectById(billId);
		if("2".equals(entity.getSourceType())){
			//说明该单据由供方发起的，需要设置下采购端经办人
			entity.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
			entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
			entity.setChangState("pass");
		}
		service.saveOrUpdate(entity);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		SettlementEntity entity = service.selectById(billId);
		if("2".equals(entity.getSourceType())){
			//说明该单据由供方发起的，需要设置下采购端经办人
			entity.setEmployeeId(null);
			entity.setEmployeeName(null);
			entity.setChangState("checking");
		}
		service.saveOrUpdate(entity);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SettlementEntity entity = service.selectById(billId);
		if(1==state){
			//无审批流提交
			if("2".equals(entity.getSourceType())){
				//说明该单据由供方发起的，需要设置下采购端经办人
				entity.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
				entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
				entity.setChangState("pass");
			}
		}
		service.saveOrUpdate(entity);
		logger.info("审批通过业务开始！");
		//修改合同状态  结算类型，0-过程,1-最终
		if(entity.getContractId()!=null && entity.getSignatureType()==1){
			ContractEntity contractEntity = contractService.selectById(entity.getContractId());
			contractEntity.setPerformanceStatus(PerformanceStatusEnum.已封账.getCode());
			contractService.saveOrUpdate(contractEntity);
			logger.info("修改合同状态！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//结算单
		CommonResponse<String> res2 = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res2.isSuccess()+"----"+res2.getMsg());
		if(!res2.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		SettlementEntity entity = service.selectById(billId);
		if("2".equals(entity.getSourceType())){
			//说明该单据由供方发起的，需要设置下采购端经办人
			entity.setEmployeeId(null);
			entity.setEmployeeName(null);
			entity.setChangState("checking");
		}
		service.saveOrUpdate(entity);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		SettlementEntity entity = service.selectById(billId);
		//修改合同状态  结算类型，0-过程,1-最终
		if(entity.getContractId()!=null && entity.getSignatureType()==1){
			ContractEntity contractEntity = contractService.selectById(entity.getContractId());
			contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
			contractService.saveOrUpdate(contractEntity);
			logger.info("修改合同状态！");
		}
		return CommonResponse.success();
	}
}
