package com.ejianc.business.promaterial.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.promaterial.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.promaterial.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.resource.api.IResourceApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.*;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 收票登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("invoiceReceiveRegist")
public class InvoiceReceiveRegistController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IResourceApi resourceApi;
    @Autowired
    private IFaceAndIdCardService faceAndIdCardService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> saveOrUpdate(@RequestBody InvoiceReceiveRegistVO saveorUpdateVO) {
        InvoiceReceiveRegistEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceReceiveRegistEntity.class);
        service.insertOrUpdate(entity);
        InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryDetail(Long id) {
        InvoiceReceiveRegistEntity entity = service.selectById(id);
        InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("供方提交或者采购方驳回")
    @RequestMapping(value = "/submitGF", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> submitGF(@RequestBody InvoiceReceiveRegistVO saveOrUpdateVO) {
        LambdaUpdateWrapper<InvoiceReceiveRegistEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(InvoiceReceiveRegistEntity::getId,saveOrUpdateVO.getId());
        updateWrapper.set(InvoiceReceiveRegistEntity::getChangState, saveOrUpdateVO.getChangState());
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getReturnReason())){
            updateWrapper.set(InvoiceReceiveRegistEntity::getReturnReason, saveOrUpdateVO.getReturnReason());
        }
        service.update(updateWrapper);
        return  CommonResponse.success();
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveRegistVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceReceiveRegistVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询进项发票列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("sellerName");
        param.getFuzzyFields().add("buyerName");
        param.getFuzzyFields().add("processPersonName");
        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("processPersonId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("processPersonId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");

        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<String> supState = new ArrayList<>();
        supState.add("checking");//供方状态--审核中
        supState.add("pass");//供方状态--已生效

        param.getComplexParams().add(getPageQueryParam(supState));
        IPage<InvoiceReceiveRegistEntity> page = service.queryPage(param,false);
        IPage<InvoiceReceiveRegistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceiveRegistVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    public ComplexParam getPageQueryParam(List<String> supState) {
        //1 采购端数据 - - 租户主键是自己的 or  供方数据 - - 租户主键是自己的 并且 供应商状态 in （审核中、已生效）
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sourceType", new Parameter(QueryParam.EQ, 1));//数据来源-采购端
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("sourceType",new Parameter(QueryParam.EQ,2));//数据来源-供方
        c3.getParams().put("changState",new Parameter(QueryParam.IN,supState));//状态 in 审批中，已生效的数据
        c1.getComplexParams().add(c3);
        return c1;
    }

    /**
     * @Description queryList 查询进项发票列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGFList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryGFList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("sellerName");
        param.getFuzzyFields().add("buyerName");
        param.getFuzzyFields().add("processPersonName");
        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("processPersonId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("processPersonId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");

        }
        //1 供方数据 - - 供应商主键是自己的  or  采购端数据 - - 供应商主键是自己的 审批通过的数据
        /** 租户隔离 */
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();
        param.getParams().put("sellerId",new Parameter(QueryParam.EQ,supplierId));

        param.getComplexParams().add(getGFPageQueryParam());

        IPage<InvoiceReceiveRegistEntity> page = service.queryPage(param,false);
        IPage<InvoiceReceiveRegistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceiveRegistVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    public ComplexParam getGFPageQueryParam() {
        //1 供方数据 - - 供应商主键是自己的  or  采购端数据 - - 供应商主键是自己的 审批通过的数据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sourceType", new Parameter(QueryParam.EQ, 1));//数据来源-采购端
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));//审批通过
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("sourceType",new Parameter(QueryParam.EQ,2));//数据来源-供方
        c1.getComplexParams().add(c3);
        return c1;
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "receivePool-import.xlsx", "收票登记发票导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<InvoiceReceivePoolVO> errorList = new ArrayList<>();
            List<InvoiceReceivePoolVO> successList = new ArrayList<>();
            CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String,String> defMap =getDefMap(defList.getData());
            if(result != null && result.size() > 0) {
                for(int i=0;i<result.size();i++) {
                    InvoiceReceivePoolVO s = new InvoiceReceivePoolVO();
                    List<String> row = result.get(i);
                    if(StringUtils.isEmpty(row.get(0)) || !("增值税专用发票".equals(row.get(0)) || "增值税普通发票".equals(row.get(0)) || "其它".equals(row.get(0)))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票类型选择不正确！");
                    }else {
                        String invoiceType= defMap.get(row.get(0));
                        s.setInvoiceType(Long.valueOf(invoiceType));
                    }
                    s.setInvoiceTypeName(row.get(0));
//                    if(StringUtils.isEmpty(row.get(1))){
//                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票代码不能为空！");
//                    }else {
                        s.setInvoiceCode(row.get(1));
                    //}
                    if(StringUtils.isEmpty(row.get(2))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票号码不能为空！");
                    }else {
                        s.setInvoiceNumber(row.get(2));
                    }
                    if(StringUtils.isEmpty(row.get(3))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：开票日期不能为空！");
                    }else {
                        try {
                            s.setInvoiceDate(DateFormatUtil.parseDate("yyyy-MM-dd",row.get(3)));
                        }catch (ParseException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：开票日期格式不正确！");
                            s.setInvoiceDate(null);
                        }
                    }
                    if(StringUtils.isEmpty(row.get(4))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票金额(不含税)不能为空！");
                    }else {
                        try {
                            s.setInvoiceMny(ComputeUtil.scale(new BigDecimal(row.get(4)), 2));
                        }catch (NumberFormatException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票金额(不含税)不是正确的数字格式！");
                            s.setInvoiceMny(null);
                        }
                    }
                    if(StringUtils.isNotEmpty(row.get(5))){
                        try {
                            s.setTaxMny(ComputeUtil.scale(new BigDecimal(row.get(5)), 2));
                        }catch (NumberFormatException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：税额不是正确的数字格式！");
                            s.setTaxMny(null);
                        }
                    }
                    if(StringUtils.isNotEmpty(row.get(6))){
                        s.setContent(row.get(6));
                    }
                    if(s.getInvoiceMny()!=null && s.getTaxMny()!=null){
                        s.setInvoiceTaxMny(s.getTaxMny().add(s.getInvoiceMny()));
                    }
                    if(StringUtils.isEmpty(s.getErrorMessage())){
                        successList.add(s);
                    }else {
                        errorList.add(s);
                    }

                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("sellerName");
        queryParam.getFuzzyFields().add("buyerName");
        queryParam.getFuzzyFields().add("processPersonName");
        if(queryParam.getParams().get("hasMyRegist") != null){
            if(queryParam.getParams().get("hasMyRegist").getValue().equals("1")){
                queryParam.getParams().put("processPersonId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }else if(queryParam.getParams().get("hasMyRegist").getValue().equals("0")){
                queryParam.getParams().put("processPersonId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }
            queryParam.getParams().remove("hasMyRegist");
        }
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,billStateList));
        IPage<InvoiceReceiveRegistEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceReceiveRegistVO> voList = new ArrayList<InvoiceReceiveRegistVO>();

        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceiveRegistVO r = BeanMapper.map(pool, InvoiceReceiveRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceive-export.xlsx", beans, response);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {

        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }
}
