package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.enums.DeliverCheckStateEnum;
import com.ejianc.business.promaterial.delivery.mapper.DeliveryMapper;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryDetailVO;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.enums.DeliverStateEnum;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材-发货单
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class DeliveryServiceImpl extends BaseServiceImpl<DeliveryMapper, DeliveryEntity> implements IDeliveryService{
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private ICheckService checkService;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;

    /**
     * type 0-关闭,1-新增和修改
     * @param id
     * @return
     */
    @Override
    @Transactional
    public DeliveryVO closeDelivery(Long id) {
        DeliveryEntity deliveryEntity = super.selectById(id);
        deliveryEntity.setOrderFlag(1);
        super.updateById(deliveryEntity);

        OrderEntity orderEntity = orderService.selectById(deliveryEntity.getOrderId());
        if (1 != orderEntity.getOrderFlag()){
            Map<Long, BigDecimal> checkMap = new HashMap<>();
            Map<Long, BigDecimal> deliverMap = new HashMap<>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryEntity.getDeliveryDetailList()) {
                checkMap.put(deliveryDetailEntity.getOrderDetailId(), null != deliveryDetailEntity.getCheckNum() ? deliveryDetailEntity.getCheckNum() : BigDecimal.ZERO);
                deliverMap.put(deliveryDetailEntity.getOrderDetailId(), null != deliveryDetailEntity.getTimeDeliverNum() ? deliveryDetailEntity.getTimeDeliverNum() : BigDecimal.ZERO);
            }
            Integer orderDeliverState = DeliverStateEnum.部分送货.getCode();
            int unFlag = 0;
            int fullFlag = 0;
            for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
                //送货数量 = 送货数量 - 本单送货数量 + 本单验收数量
                orderDetailEntity.setDeliverNum(ComputeUtil.safeAdd(ComputeUtil.safeSub(orderDetailEntity.getDeliverNum(), deliverMap.get(orderDetailEntity.getId())), checkMap.get(orderDetailEntity.getId())));
                orderDetailEntity.setUnDeliverNum(ComputeUtil.safeSub(orderDetailEntity.getOrderNum(), orderDetailEntity.getDeliverNum()));

                if (BigDecimal.ZERO.compareTo(orderDetailEntity.getDeliverNum()) == 0){
                    unFlag++;
                }
                if (orderDetailEntity.getOrderNum().compareTo(orderDetailEntity.getDeliverNum()) <= 0){
                    fullFlag++;
                }
            }
            if (unFlag > 0 && unFlag == orderEntity.getOrderDetailList().size()) {
                orderDeliverState = DeliverStateEnum.待送货.getCode();
            }
            if (fullFlag > 0 && fullFlag == orderEntity.getOrderDetailList().size()) {
                orderDeliverState = DeliverStateEnum.全部送货.getCode();
            }
            orderEntity.setDeliverState(orderDeliverState);
            orderService.saveOrUpdate(orderEntity, false);
        }
        return BeanMapper.map(deliveryEntity, DeliveryVO.class);
    }


    @Override
    public DeliveryVO queryInitDelivery(OrderVO orderVO) {
        OrderEntity orderEntity = orderService.selectById(orderVO.getId());
        List<Long> detailIdList = orderVO.getOrderDetailList().stream().map(OrderDetailVO::getId).collect(Collectors.toList());
        DeliveryVO vo = BeanMapper.map(orderEntity, DeliveryVO.class);
        vo.setOrderFlag(0);
        vo.setOrderId(orderEntity.getId());
        vo.setOrderBillCode(orderEntity.getBillCode());
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setCheckState(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        vo.setDeliverLinkTelephone(mobilePhone);
        List<DeliveryDetailVO> list = new ArrayList<>();
        for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
            if (detailIdList.contains(orderDetailEntity.getId())){
                DeliveryDetailVO detailVO = BeanMapper.map(orderDetailEntity,DeliveryDetailVO.class);
                detailVO.setOrderId(orderDetailEntity.getOrderId());
                detailVO.setOrderDetailId(orderDetailEntity.getId());
                detailVO.setCheckNum(BigDecimal.ZERO);
                // 订单发货数量默认未发货数量
                detailVO.setUnDeliverNum(orderDetailEntity.getUnDeliverNum());
                detailVO.setTimeDeliverNum(detailVO.getUnDeliverNum());
                detailVO.setId(IdWorker.getId());
                list.add(detailVO);
            }
        }
        vo.setDeliveryDetailList(list);
        return vo;
    }

    @Override
    public CheckVO queryDetailToCheck(Long id) {
        DeliveryEntity deliveryEntity = deliveryService.selectById(id);

        //处理组合验收数据返回
        CheckVO vo = BeanMapper.map(deliveryEntity, CheckVO.class);
        vo.setDeliveryId(deliveryEntity.getId());
        vo.setDeliveryBillCode(deliveryEntity.getBillCode());
        vo.setDeliveryType(1);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setSourceType("2");
        vo.setChangState("free");


        //处理子表数据返回
        List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        List<DeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getTimeDeliverNum().compareTo(null == s.getCheckNum() ? BigDecimal.ZERO : s.getCheckNum()) == 1 ).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)){
            ArrayList<CheckDetailVO> checkDetailVOS = new ArrayList<>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList){
                CheckDetailVO checkDetailVO = BeanMapper.map(deliveryDetailEntity, CheckDetailVO.class);
                checkDetailVO.setRowState("add");
                checkDetailVO.setBillSourceType(1);
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(checkDetailVO.getId());

                if (null != deliveryDetailEntity.getCheckNum()){
                    checkDetailVO.setCheckNum(ComputeUtil.safeSub(deliveryDetailEntity.getTimeDeliverNum(), deliveryDetailEntity.getCheckNum()));
                }else {
                    checkDetailVO.setCheckNum(deliveryDetailEntity.getTimeDeliverNum());
                }

                checkDetailVO.setDetailCheckPrice(deliveryDetailEntity.getPrice());
                checkDetailVO.setDetailCheckTaxPrice(deliveryDetailEntity.getDetailTaxPrice());


                checkDetailVOS.add(checkDetailVO);
            }
            vo.setCheckDetailList(checkDetailVOS);
        }
        return vo;
    }

    @Override
    public Map<Long, BigDecimal> sumDeliveredGroupByDetailId(Long orderId) {
        // 查询送货单
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter(QueryParam.EQ, orderId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<DeliveryEntity> deliveryList = super.queryList(queryParam);
        Map<Long, Integer> deliveryMap = deliveryList.stream().collect(Collectors.toMap(DeliveryEntity::getId, DeliveryEntity::getOrderFlag));
        logger.info("已送货的送货单信息：{}", JSONObject.toJSONString(deliveryList));
        Map<Long, BigDecimal> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(deliveryList)) {
            List<Long> deliveryIdList = new ArrayList<>();
            for (DeliveryEntity entity : deliveryList) {
                deliveryIdList.add(entity.getId());
            }
            // 查询子表信息
            // 送货单已送货的明细
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("deliveryId", new Parameter(QueryParam.IN, deliveryIdList));
            List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.queryList(detailParam);
            // 对送货单相同明细进行计算
            for (DeliveryDetailEntity detail : deliveryDetailList) {
                Long orderDetailId = detail.getOrderDetailId();
                if (map.containsKey(orderDetailId)) {
                    BigDecimal sum = ComputeUtil.safeAdd((deliveryMap.get(detail.getDeliveryId()) == 1 ? detail.getCheckNum() : detail.getTimeDeliverNum()), map.get(orderDetailId));
                    map.put(orderDetailId, sum);
                }
                else {
                    map.put(orderDetailId, deliveryMap.get(detail.getDeliveryId()) == 1 ? detail.getCheckNum() : detail.getTimeDeliverNum());
                }
            }
        }
        return map;
    }


}
