package com.ejianc.business.promaterial.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ConstantTypeEnum {

    // 合同付款支付类型
    PRE_PAY_TYPE(Long.valueOf("1"), "预付款"),
    PROGRESS_PAY_TYPE(Long.valueOf("2"), "过程款"),
    OTHER_PAY_TYPE(Long.valueOf("3"), "其他"),
    NULL(null, null),
    ;

    private final Long code;
    private final String name;
    private static Map<Integer, ConstantTypeEnum> enumMap = new HashMap();

    private ConstantTypeEnum(Long code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static ConstantTypeEnum getEnumByCode(Long code) {
        return (ConstantTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(ConstantTypeEnum.class).stream().collect(Collectors.toMap(ConstantTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
