package com.ejianc.business.promaterial.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 付款申请关联发票实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_invoice")
public class PayInvoiceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="payapply_id")
    private Long payapplyId; // 付款申请单主键
    @TableField(value="invoice_id")
    private Long invoiceId; // 来源发票主键
    @TableField(value="invoice_number")
    private String invoiceNumber; // 发票号码
    @TableField(value="invoice_code")
    private String invoiceCode; // 发票代码
    @TableField(value="invoice_mny")
    private BigDecimal invoiceMny; // 发票金额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value="invoice_tax_mny")
    private BigDecimal invoiceTaxMny; // 价税合计
    @TableField(value="used_invoice_tax_mny")
    private BigDecimal usedInvoiceTaxMny; // 本期发票金额
    @TableField(value="surplus_invoice_tax_mny")
    private BigDecimal surplusInvoiceTaxMny; // 剩余发票金额
    @TableField(value="invoice_date")
    private Date invoiceDate; // 开票日期
    @TableField(value="create_user_name")
    private String createUserName; // 创建者名称
    @TableField(value="use_flag")
    private Integer useFlag; // 是否占用：1 未占用， 2 已占用
    @TableField(value="invoice_type")
    private Long invoiceType; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    @TableField(value="invoice_type_name")
    private String invoiceTypeName; // 发票类型名称:1、增值税专用发票，2、增值税普通发票，3、其他；
    @TableField(value="receive_bill_id")
    private Long receiveBillId; // 收票申请主表id
    
    
    

    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }
    public BigDecimal getUsedInvoiceTaxMny() {
        return usedInvoiceTaxMny;
    }

    public void setUsedInvoiceTaxMny(BigDecimal usedInvoiceTaxMny) {
        this.usedInvoiceTaxMny = usedInvoiceTaxMny;
    }
    public BigDecimal getSurplusInvoiceTaxMny() {
        return surplusInvoiceTaxMny;
    }

    public void setSurplusInvoiceTaxMny(BigDecimal surplusInvoiceTaxMny) {
        this.surplusInvoiceTaxMny = surplusInvoiceTaxMny;
    }
    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }
    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public Long getReceiveBillId() {
        return receiveBillId;
    }

    public void setReceiveBillId(Long receiveBillId) {
        this.receiveBillId = receiveBillId;
    }
    
}
