package com.ejianc.business.promaterial.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.enums.ConstantTypeEnum;
import com.ejianc.business.promaterial.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.promaterial.finance.bean.PayContractSettleEntity;
import com.ejianc.business.promaterial.finance.bean.PayInvoiceEntity;
import com.ejianc.business.promaterial.finance.bean.PayRecordEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractSettleService;
import com.ejianc.business.promaterial.finance.service.IPayInvoiceService;
import com.ejianc.business.promaterial.finance.service.IPayRecordService;
import com.ejianc.business.promaterial.finance.vo.*;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.utils.MathUtil;
import com.ejianc.business.promaterial.utils.NumberToCN;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.finance.mapper.PayContractMapper;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 合同付款申请实体
 * 
 * @author generator
 * 
 */
@Service("payContractService")
public class PayContractServiceImpl extends BaseServiceImpl<PayContractMapper, PayContractEntity> implements IPayContractService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayInvoiceService invoiceService;

    @Autowired
    private IPayContractSettleService settleService;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public PayContractVO insertOrUpdate(PayContractVO vo) {
        PayContractEntity entity = BeanMapper.map(vo, PayContractEntity.class);

        LambdaQueryWrapper<PayContractEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getContractId, entity.getContractId());
        lambda.ne(entity.getId() != null && entity.getId() > 0, PayContractEntity::getId, entity.getId());
        lambda.orderByDesc(PayContractEntity::getApplyTime);
        List<PayContractEntity> entityList = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entityList)) {
            throw new BusinessException("该合同存在未生效支付申请单，不允许新增!");
        }


        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());

        if (StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);//存放发票确认标识


        // 保存主表
        super.saveOrUpdateNoES(entity);
        Long id = entity.getId();
        // 更新发票
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        // 更新结算
        List<PayContractSettleVO> settleVOList = this.updateSettleVOS(vo, id);
        
        // 返回VO
        if (entity.getId() != null) {
            QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
            wrapper.eq("payapply_id", entity.getId());
            invoiceVOList = invoiceService.list(wrapper);
        }
        PayContractEntity payContractEntity = super.getById(id);
        PayContractVO backVO = BeanMapper.map(payContractEntity, PayContractVO.class);
        backVO.setInvoiceVOList(BeanMapper.mapList(invoiceVOList, PayInvoiceVO.class));// 发票列表
        backVO.setSettleVOList(settleVOList);// 结算列表
        return backVO;
    }

    private List<PayContractSettleVO> updateSettleVOS(PayContractVO vo, Long id) {
        // 新增
        List<PayContractSettleVO> vos = vo.getSettleVOList();
        if (vos != null && !vos.isEmpty()) {
            List<PayContractSettleEntity> entityList = BeanMapper.mapList(vos, PayContractSettleEntity.class);
            settleService.saveOrUpdateBatch(entityList, entityList.size(), false);
            vos = BeanMapper.mapList(entityList, PayContractSettleVO.class);
        }
        // 删除
        QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
        wrapper.eq("payapply_id", id);
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(PayContractSettleVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), "id", ids);
        }
        settleService.remove(wrapper, false);
        return vos;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PayContractVO vo, Long id) {
        // 新增
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                invoiceVO.setPayapplyId(id);
            }
            List<PayInvoiceEntity> entityList = BeanMapper.mapList(voList, PayInvoiceEntity.class);
            invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PayInvoiceVO.class);
        }
        // 删除
        QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
        wrapper.eq("payapply_id", id);
        if (CollectionUtils.isNotEmpty(voList)) {
            List<Long> ids = voList.stream().map(PayInvoiceVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), "id", ids);
        }
        invoiceService.remove(wrapper, false);
        return voList;
    }

    @Override
    public PayContractVO queryDetail(Long id) {
        // 查询主表
        PayContractEntity entity = this.selectById(id);
        PayContractVO vo = BeanMapper.map(entity, PayContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        // 查询关联发票
        List<PayInvoiceEntity> invoiceEntityList = invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList(invoiceEntityList, PayInvoiceVO.class));
        // 查询关联结算
        List<PayContractSettleEntity> settleEntityList = settleService.queryList(queryParam, false);
        vo.setSettleVOList(BeanMapper.mapList(settleEntityList, PayContractSettleVO.class));
        return vo;
    }

    @Override
    public List<PayContractVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List<PayContractVO> resVos = (List<PayContractVO>) queryPageJson(param, false).get("records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); i++) {
                PayContractVO vo = resVos.get(i);
                vo.setFeeTypeName(ConstantTypeEnum.getEnumByCode(vo.getFeeType()).getName());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<PayContractEntity> entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(entityList)) {

            super.removeByIds(ids, false);

            invoiceService.updateInvoiceUsedMnyByDel(ids);

            // 删除发票
            invoiceService.remove(new QueryWrapper<PayInvoiceEntity>().in("payapply_id", ids), false);

            // 删除结算
            settleService.remove(new QueryWrapper<PayContractSettleEntity>().in("payapply_id", ids), false);

        }
        return "删除成功！";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        Page<PayContractVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayContractVO> list = baseMapper.queryPageList(pages, wrapper, flag);

        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            vo.setApplyHasPenaltyMny(ComputeUtil.safeAdd(vo.getApplyMny(), vo.getCurPenaltyMoney()));
        });

        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

    @Override
    public SumPayMnyVO getSumPayMny(Long contractId, Long orgId, Boolean applyMnyContainFree) {
        // 所有支出类结算单预付款抵扣功能中的预付款取数方式
        // 1：取该合同的预付款支付金额；
        // 2：取该合同的预付款申请金额(所有状态的付款申请单)；
        // 默认只取生效态预付款isPrePayPassed

        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        QueryWrapper queryWrapper = new QueryWrapper<PayContractEntity>();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SUM( IF ( pay_status = 2 AND bill_state IN ( 1, 3 ) and org_id = '"+orgId+"', pay_mny, 0 ) ) AS sumPayMny, ");
        selectSql.append(" SUM( IF ( fee_type = 1 , apply_mny, 0 ) ) AS sumPrePayMny,");
        //申请金额是否包含自由态
        if (applyMnyContainFree != null && applyMnyContainFree) {
            //计算规则中申请金额需要按照不含扣款金额的申请金额计算
            selectSql.append(" SUM( IF(org_id = '"+orgId+"',IFNULL( apply_mny, 0 ),0) + IFNULL( cur_penalty_money, 0 ) ) AS sumApplyMny ");
        } else {
            selectSql.append(" SUM( IF ( bill_state IN ( 1, 3 ) and org_id = '"+orgId+"' , IFNULL( apply_mny, 0 ) + IFNULL( cur_penalty_money, 0 ), 0 ) ) AS sumApplyMny ");
        }
        queryWrapper.select(selectSql.toString());
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        queryWrapper.eq("contract_id", contractId);
        Map<String, Object> map = this.getMap(queryWrapper);
        SumPayMnyVO vo = new SumPayMnyVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        if (MapUtils.isEmpty(map)) {
            vo.setSumApplyMny(BigDecimal.ZERO);
            vo.setSumPrePayMny(BigDecimal.ZERO);
            vo.setSumPayMny(BigDecimal.ZERO);
        } else {
            vo.setSumApplyMny(ComputeUtil.toBigDecimal(map.get("sumApplyMny")));
            vo.setSumPrePayMny(ComputeUtil.toBigDecimal(map.get("sumPrePayMny")));
            vo.setSumPayMny(ComputeUtil.toBigDecimal(map.get("sumPayMny")));
        }
        BigDecimal sumPayLaborMny = BigDecimal.ZERO;
        LambdaQueryWrapper<PayRecordEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PayRecordEntity::getContractId, contractId);
        wrapper.eq(PayRecordEntity::getOrgId, orgId);
        List<PayRecordEntity> list = payRecordService.list(wrapper);
        vo.setSumPayLaborMny(sumPayLaborMny);
        return vo;
    }

    @Override
    public JSONObject queryPendingPageJson(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
//        param.getParams().put("payStatus",new Parameter(QueryParam.EQ, 1));//未支付
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));//未删除
        //param.getOrderMap().put("approveTime", QueryParam.DESC);

        Page<PayApplyPubVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List feeTypeIds=new ArrayList();
        if (null!=param.getParams().get("feeTypeId")){
            String feeTypeId=param.getParams().get("feeTypeId").getValue().toString();
            feeTypeIds = Arrays.asList(feeTypeId.split(","));
            param.getParams().remove("feeTypeId");
            if (null== param.getParams().get("feeType")
                    || param.getParams().get("feeType").getValue().toString().contains("费用报销")) {
                //费用类型只影响费用报销数据因此只搜索费用报销
                param.getParams().put("feeType", new Parameter(QueryParam.IN, "费用报销"));
            }else {
                //存放非法参数值 防止选择其他申请类型类型  依旧查出数据
                param.getParams().put("feeType", new Parameter(QueryParam.IN, "1"));
            }
        }
        QueryWrapper<PayApplyPubVO> wrapper = changeToQueryWrapper(param);
        // 未支付或者支付金额小于申请金额为待处理,并且未关闭的
        wrapper.and(x -> x.last("(pay_status = 1 or (IFNULL(pay_mny,0) + IFNULL(this_deduct_mny,0)) < apply_mny) AND IFNULL(close_flag,0) = 0"));
        List<PayApplyPubVO> list = baseMapper.queryPendingList(pages, wrapper,feeTypeIds);
        /** 找出要查询的扩展单据id*/

        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(ComputeUtil.safeSub(vo.getApplyMny(), vo.getPayMny(), vo.getThisDeductMny()));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }


    @Override
    public JSONObject queryAllList(QueryParam param, String type) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));//未删除

        Page<PayApplyPubVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List feeTypeIds=new ArrayList();
        if (null!=param.getParams().get("feeTypeId")){
            String feeTypeId=param.getParams().get("feeTypeId").getValue().toString();
            feeTypeIds = Arrays.asList(feeTypeId.split(","));
            param.getParams().remove("feeTypeId");
            if (null== param.getParams().get("feeType")
                    || param.getParams().get("feeType").getValue().toString().contains("费用报销")) {
                //费用类型只影响费用报销数据因此只搜索费用报销
                param.getParams().put("feeType", new Parameter(QueryParam.IN, "费用报销"));
            }else {
                //存放非法参数值 防止选择其他申请类型类型  依旧查出数据
                param.getParams().put("feeType", new Parameter(QueryParam.IN, "1"));
            }
        }
        QueryWrapper<PayApplyPubVO> wrapper = changeToQueryWrapper(param);
        List<PayApplyPubVO> list;
        if ("detail".equals(type)){
            list = baseMapper.queryALLDetailList(pages, wrapper, feeTypeIds);
        }else {
            list = baseMapper.queryPendingList(pages, wrapper, feeTypeIds);
        }

        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(ComputeUtil.safeSub(vo.getApplyMny(), vo.getPayMny(), vo.getThisDeductMny()));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

    @Override
    public List<PayApplyPubVO> queryExportPendingList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List<PayApplyPubVO> records = (List<PayApplyPubVO>) queryPendingPageJson(param, false).get("records");
        return records;
    }

    @Override
    public String batchConfirm(List<PayApplyPubVO> vos) {
        for (PayApplyPubVO vo : vos) {
            PayRecordVO record = new PayRecordVO();
                PayContractVO data = this.queryDetail(vo.getId());
                record.setBillCode(data.getBillCode());// 单据编号
                record.setPayapplyId(data.getId());// 申请单主键
                record.setContractId(data.getContractId());
                record.setContractName(data.getContractName());
                record.setProjectId(data.getProjectId());// 项目
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());// 组织
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());// 申请人
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());// 申请时间
                record.setApplyMny(data.getApplyMny());// 申请金额
                BigDecimal surplusPayMny = MathUtil.safeSub(data.getApplyMny(), data.getPayMny());// 剩余可支付金额
                record.setThisPayMny(surplusPayMny);// 本期支付金额默认等于剩余可支付金额
                record.setReceiveUnitId(data.getReceiveUnitId());// 收款单位
                record.setReceiveUnitName(data.getReceiveUnitName());
                record.setApplyType("合同付款");// 付款类型
                record.setFeeType(data.getFeeType());
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountId(vo.getAccountId());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());

                payRecordService.insertOrUpdate(record, true);
        }
        return "批量支付成功！";
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // 单据权限控制支持--仅制单人查看
        if (StringUtils.isNotEmpty(param.getBillTypeId()) && this.viewSelf(param.getBillTypeId()) && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            param.getParams().put("createUserCode", new Parameter("eq", InvocationInfoProxy.getUsercode()));
        }

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");

        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayContractVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayContractVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public TotalColumnVO getPendingTotalColumnInfo(QueryParam param, boolean isEs, String type) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
//        param.getParams().put("payStatus",new Parameter(QueryParam.EQ, 1));//未支付
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));//未删除
        param.getOrderMap().put("approveTime", QueryParam.DESC);

        List feeTypeIds=new ArrayList();
        if (null!=param.getParams().get("feeTypeId")){
            String feeTypeId=param.getParams().get("feeTypeId").getValue().toString();
            feeTypeIds = Arrays.asList(feeTypeId.split(","));
            param.getParams().remove("feeTypeId");
            if (null== param.getParams().get("feeType")
                    || param.getParams().get("feeType").getValue().toString().contains("费用报销")) {
                //费用类型只影响费用报销数据因此只搜索费用报销
                param.getParams().put("feeType", new Parameter(QueryParam.IN, "费用报销"));
            }else {
                //存放非法参数值 防止选择其他申请类型类型  依旧查出数据
                param.getParams().put("feeType", new Parameter(QueryParam.IN, "1"));
            }
        }
        QueryWrapper<PayApplyPubVO> wrapper = changeToQueryWrapper(param);
        if ("pending".equals(type)) {
            // 未支付或者支付金额小于申请金额为待处理
            wrapper.and(x -> x.last("pay_status = 1 or pay_mny < apply_mny"));
        }
        List<PayApplyPubVO> list = baseMapper.queryPendingList(null, wrapper,feeTypeIds);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayApplyPubVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayApplyPubVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public void closePayment(Long id) {
        Assert.notNull(id, "付款申请id不能为空");
        PayContractEntity entity = super.selectById(id);
        if (entity == null) {
            throw new BusinessException("付款申请不存在");
        }

        // 【本期申请金额】修改为【已支付金额】
        entity.setApplyMnyBeforeClose(entity.getApplyMny());
        entity.setApplyMny(entity.getPayMny());
        entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));

        // 表体【本期申请金额】修改为【本期支付金额】回写结算单
        LambdaQueryWrapper<PayContractSettleEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PayContractSettleEntity::getPayapplyId, id);
        List<PayContractSettleEntity> list = settleService.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(settle -> {
                // 保留关闭前的本期申请金额
                settle.setBodyApplyMnyBeforeClose(settle.getBodyApplyMny());
                settle.setBodyApplyMny(settle.getSumPayMny());
            });
            settleService.updateBatchById(list);
        }

        // 付款关闭确认后 【关闭状态】=已关闭；【关闭人】=当前登录人；【关闭时间】=当前时间；
        entity.setCloseFlag(Boolean.TRUE);
        entity.setCloseState("已关闭");
        entity.setCloseTime(new Date());
        entity.setCloseUser(sessionManager.getUserContext().getUserName());

        super.updateById(entity);

        // 回写结算单累计申请金额、剩余可申请金额
        writeBackSumApplyMny(id, entity, false);
    }

    /**
     * 回写结算单累计申请金额、剩余可申请金额
     * @param billId
     * @param entity
     * @param flag
     */
    @Override
    public boolean writeBackSumApplyMny(Long billId, PayContractEntity entity, boolean flag) {
        List<PayContractSettleEntity> settleEntityList = settleService.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", billId));
        // 结算单对应本期申请金额
        Map<Long, BigDecimal> settleApplyMnyMap  = new HashMap<>();
        for(PayContractSettleEntity settleEntity : settleEntityList){
            // 本期申请金额   true为回写，false为逆回写
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub(settleEntity.getBodyApplyMny(), settleEntity.getBodyApplyMnyBeforeClose());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);

            SettlementEntity settlementEntity = settlementService.selectById(settleEntity.getSettleId());
            if(settlementEntity == null){
                throw new BusinessException("没有找到相应物资采购结算单！");
            }
            BigDecimal currentSettlementAmountTax = settlementEntity.getSettlementTaxMny();
            BigDecimal alreadyApplyAmount = settlementEntity.getCurrentApplyAmount();
            if(alreadyApplyAmount == null){
                alreadyApplyAmount = new BigDecimal("0.00");
            }
            alreadyApplyAmount = alreadyApplyAmount.add(applyMny).setScale(2,BigDecimal.ROUND_HALF_UP);
            settlementEntity.setCurrentApplyAmount(alreadyApplyAmount);
            if(currentSettlementAmountTax == null){
                currentSettlementAmountTax = new BigDecimal("0.00");
            }
            /**
             * 剩余可以申请金额 = 本期结算金额（含税）-累计已申请金额
             */
            BigDecimal remainCanApplyAmount = currentSettlementAmountTax.subtract(alreadyApplyAmount).setScale(2,BigDecimal.ROUND_HALF_UP);
            settlementEntity.setRemainCanApplyAmount(remainCanApplyAmount);
            settlementService.saveOrUpdate(settlementEntity,false);

        }
        return true;
    }



    @Override
    public Map<Long, BigDecimal> getApplyMnyHasFree(List<Long> settleIds, Long id) {
        List<PayContractSettleVO> settleVOList = baseMapper.getApplyMnyHasFree(settleIds, id);
        Map<Long, BigDecimal> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(settleVOList)) {
            map = settleVOList.stream().collect(Collectors.toMap(PayContractSettleVO::getSettleId, PayContractSettleVO::getSumApplyMny));
        }
        return map;
    }
}
