package com.ejianc.business.promaterial.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.finance.vo.PayInvoiceVO;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.promaterial.taxnew.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.promaterial.utils.BigDecimalUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.finance.mapper.PayInvoiceMapper;
import com.ejianc.business.promaterial.finance.bean.PayInvoiceEntity;
import com.ejianc.business.promaterial.finance.service.IPayInvoiceService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 付款申请关联发票实体
 * 
 * @author generator
 * 
 */
@Service("payInvoiceService")
public class PayInvoiceServiceImpl extends BaseServiceImpl<PayInvoiceMapper, PayInvoiceEntity> implements IPayInvoiceService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;

    @Override
    public void updateInvoiceUsedMnyBySave(List<PayInvoiceVO> voList, Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("payapplyId", new Parameter(QueryParam.EQ, id));
        // 查询关联发票
        List<PayInvoiceEntity> oldInvoiceList = id != null ? this.queryList(param, false) : null;
        Map<Long, BigDecimal> invoiceUpdateMap = new HashMap<>();
        // 新增
        if (CollectionUtils.isNotEmpty(voList)) {
            Map<Long, BigDecimal> oldInvoiceMap = CollectionUtils.isNotEmpty(oldInvoiceList) ? oldInvoiceList.stream().collect(Collectors.toMap(PayInvoiceEntity::getInvoiceId, PayInvoiceEntity::getUsedInvoiceTaxMny)) : new HashMap<>();
            voList.forEach(t -> {
                Long invoiceId = t.getInvoiceId();
                BigDecimal nowUesdInvoiceTaxMny = invoiceUpdateMap.get(invoiceId);
                if ("del".equals(t.getRowState()) && t.getId() != null) {
                    nowUesdInvoiceTaxMny = ComputeUtil.safeAdd(nowUesdInvoiceTaxMny, BigDecimalUtil.convertToMinusNumber(oldInvoiceMap.get(invoiceId)));
                } else {
                    nowUesdInvoiceTaxMny = ComputeUtil.safeAdd(nowUesdInvoiceTaxMny, BigDecimalUtil.safeSub(t.getUsedInvoiceTaxMny(), oldInvoiceMap.get(invoiceId)));
                }
                invoiceUpdateMap.put(invoiceId, nowUesdInvoiceTaxMny);
                oldInvoiceMap.remove(invoiceId);

            });
            if (oldInvoiceMap != null && oldInvoiceMap.size() > 0) {
                for (Map.Entry<Long, BigDecimal> t : oldInvoiceMap.entrySet()) {
                    invoiceUpdateMap.put(t.getKey(), BigDecimalUtil.convertToMinusNumber(t.getValue()));
                }
            }
        } else {
            if (CollectionUtils.isNotEmpty(oldInvoiceList)) {
                oldInvoiceList.forEach(t -> invoiceUpdateMap.put(t.getInvoiceId(), BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny())));
            }
        }
        if (!invoiceUpdateMap.isEmpty()) {
            ArrayList<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS = new ArrayList<>();
            for (Map.Entry<Long, BigDecimal> t : invoiceUpdateMap.entrySet()) {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getKey());
                v.setNowUesdInvoiceTaxMny(t.getValue());
                invoiceReceiveFlagVOS.add(v);
            }

            if (CollectionUtils.isNotEmpty(invoiceReceiveFlagVOS)) {
                List<InvoiceReceivePoolEntity> list = BeanMapper.mapList(invoiceReceiveFlagVOS, InvoiceReceivePoolEntity.class);
                List<Long> ids = list.stream().map(InvoiceReceivePoolEntity::getId).collect
                        (Collectors.toList());

                LambdaQueryWrapper<InvoiceReceivePoolEntity> lambda = Wrappers.<InvoiceReceivePoolEntity>lambdaQuery();
                lambda.in(InvoiceReceivePoolEntity::getId, ids);
                List<InvoiceReceivePoolEntity> entities = invoiceReceivePoolService.list(lambda);

                if (CollectionUtils.isNotEmpty(entities)) {
                    Map<Long, InvoiceReceivePoolEntity> maps = entities.stream().collect(Collectors.toMap(InvoiceReceivePoolEntity::getId, Function.identity(), (key1, key2) -> key2));

                    // 校验当钱可用金额是否足以被使用，有可能会有并发和时间差操作
                    for (InvoiceReceiveFlagVO i : invoiceReceiveFlagVOS) {
                        Long invoiceReceiveId = i.getId();
                        InvoiceReceivePoolEntity e = maps.get(invoiceReceiveId);
                        if (e != null) {
                            BigDecimal use = ComputeUtil.safeAdd(e.getUsedInvoiceTaxMny(), i.getNowUesdInvoiceTaxMny());
                            //发票金额 小于已占用+ 当前占用
                            if (ComputeUtil.isLessThan(e.getInvoiceTaxMny(), use)) {
                                throw new BusinessException("操作失败：发票【号码：" + e.getInvoiceNumber() + "】的剩余金额为：" + ComputeUtil.scaleTwo(ComputeUtil.safeSub(e.getInvoiceTaxMny(), e.getUsedInvoiceTaxMny())) + "，请刷新后重新选择！");
                            }
                            i.setNowUesdInvoiceTaxMny(use);
                            i.setFlag(ComputeUtil.equals(e.getInvoiceTaxMny(), use) ? 1 : 0);
                        }
                    }
                }
                // 更新发票金额和占用状态
                for (InvoiceReceiveFlagVO i : invoiceReceiveFlagVOS) {
                    LambdaUpdateWrapper<InvoiceReceivePoolEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(InvoiceReceivePoolEntity::getId, i.getId());
                    updateWrapper.set(InvoiceReceivePoolEntity::getFlag, i.getFlag());//(1:是，0：否)
                    updateWrapper.set(InvoiceReceivePoolEntity::getUsedInvoiceTaxMny, i.getNowUesdInvoiceTaxMny());
                    invoiceReceivePoolService.update(updateWrapper);
                }
            }
        }
    }

    @Override
    public void updateInvoiceUsedMnyByDel(List<Long> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("payapplyId", new Parameter(QueryParam.IN, ids));
        // 查询关联发票
        List<PayInvoiceEntity> invoiceEntityList = this.queryList(param, false);
        if (CollectionUtils.isNotEmpty(invoiceEntityList)) {
            //收票改为占用方式
            List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS = new ArrayList<>();
            invoiceEntityList.forEach(t -> {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                invoiceReceiveFlagVOS.add(v);
            });
            if (CollectionUtils.isNotEmpty(invoiceReceiveFlagVOS)) {
                List<InvoiceReceivePoolEntity> list = BeanMapper.mapList(invoiceReceiveFlagVOS, InvoiceReceivePoolEntity.class);
                List<Long> receivePoolIds = list.stream().map(InvoiceReceivePoolEntity::getId).collect
                        (Collectors.toList());

                LambdaQueryWrapper<InvoiceReceivePoolEntity> lambda = Wrappers.<InvoiceReceivePoolEntity>lambdaQuery();
                lambda.in(InvoiceReceivePoolEntity::getId, receivePoolIds);
                List<InvoiceReceivePoolEntity> entities = invoiceReceivePoolService.list(lambda);

                if (CollectionUtils.isNotEmpty(entities)) {
                    Map<Long, InvoiceReceivePoolEntity> maps = entities.stream().collect(Collectors.toMap(InvoiceReceivePoolEntity::getId, Function.identity(), (key1, key2) -> key2));

                    // 校验当钱可用金额是否足以被使用，有可能会有并发和时间差操作
                    for (InvoiceReceiveFlagVO i : invoiceReceiveFlagVOS) {
                        Long invoiceReceiveId = i.getId();
                        InvoiceReceivePoolEntity e = maps.get(invoiceReceiveId);
                        if (e != null) {
                            BigDecimal use = ComputeUtil.safeAdd(e.getUsedInvoiceTaxMny(), i.getNowUesdInvoiceTaxMny());
                            //发票金额 小于已占用+ 当前占用
                            if (ComputeUtil.isLessThan(e.getInvoiceTaxMny(), use)) {
                                throw new BusinessException("操作失败：发票【号码：" + e.getInvoiceNumber() + "】的剩余金额为：" + ComputeUtil.scaleTwo(ComputeUtil.safeSub(e.getInvoiceTaxMny(), e.getUsedInvoiceTaxMny())) + "，请刷新后重新选择！");
                            }
                            i.setNowUesdInvoiceTaxMny(use);
                            i.setFlag(ComputeUtil.equals(e.getInvoiceTaxMny(), use) ? 1 : 0);
                        }
                    }
                }
                // 更新发票金额和占用状态
                for (InvoiceReceiveFlagVO i : invoiceReceiveFlagVOS) {
                    LambdaUpdateWrapper<InvoiceReceivePoolEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(InvoiceReceivePoolEntity::getId, i.getId());
                    updateWrapper.set(InvoiceReceivePoolEntity::getFlag, i.getFlag());//(1:是，0：否)
                    updateWrapper.set(InvoiceReceivePoolEntity::getUsedInvoiceTaxMny, i.getNowUesdInvoiceTaxMny());
                    invoiceReceivePoolService.update(updateWrapper);
                }
            }
        }
    }
}
