package com.ejianc.business.promaterial.order.service.impl;

import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.order.mapper.OrderMapper;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;

/**
 * 材料订单主表
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<String> updateDeliver(Long orderId,Integer deliverState) {
        logger.info("订单id:-{},修改发货状态开始!",orderId);
        OrderEntity byId = super.getById(orderId);
        byId.setDeliverState(deliverState);
        super.saveOrUpdate(byId);
        logger.info("订单id:-{},修改发货状态为:-{}成功!",orderId,deliverState);
        return  CommonResponse.success("订单id:"+orderId+"修改发货状态为："+deliverState+"成功!");
    }

}
