package com.ejianc.business.promaterial.reconciliation.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationCollectService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationDetailVO;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.business.promaterial.returnGoods.bean.ReturnGoodsEntity;
import com.ejianc.business.promaterial.returnGoods.service.IReturnGoodsService;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

//import com.ejianc.business.promaterial.out.bean.OutStoreEntity;


/**
 * 对账单主表
 *
 * @author generator
 */
@Controller
@RequestMapping("reconciliation")
@Api(value = "对账单主表", tags = {"对账单主表"})
public class ReconciliationController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DZ_CODE";//此处需要根据实际修改

    @Autowired
    private IReconciliationService service;
    @Autowired
    private IReconciliationDetailService reconciliationDetailService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private ISettlementService settlementService;

    @Autowired
    private IReturnGoodsService returnGoodsService;

    @Autowired
    private IInvoiceReceiveRegistService invoiceReceiveRegistService;

    @Autowired
    private IPayContractService payContractService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReconciliationVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody ReconciliationVO saveOrUpdateVO) {
        ReconciliationEntity entity = BeanMapper.map(saveOrUpdateVO, ReconciliationEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //合同校验
        service.checkContract(entity);
        List<ReconciliationEntity> list;
        if (null == saveOrUpdateVO.getId() || saveOrUpdateVO.getId() == 0) {
            list = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", saveOrUpdateVO.getContractId()).in("bill_state", 0, 2, 4, 5).eq("dr", 0));
        }
        else {
            list = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", saveOrUpdateVO.getContractId()).in("bill_state", 0, 2, 4, 5).eq("dr", 0).ne("id", saveOrUpdateVO.getId()));
        }
        if (list.size() > 0) {
            throw new BusinessException(" 一个合同下只能有一张未生效的对账单");
        }

        //修改 需要删除验收单的引用
        Set<Long> CheckDelSet = new HashSet<>();
        Set<Long> CheckAddSet = new HashSet<>();

        Set<Long> returnDelSet = new HashSet<>();
        Set<Long> returnAddSet = new HashSet<>();
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            for (ReconciliationDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                if ("del".equals(detailVO.getRowState())) {
                    if(0==detailVO.getSourceType()){
                        CheckDelSet.add(detailVO.getSourceId());//要删除的 验收单id
                    }else{
                        // 要删除的 退货单id
                        returnDelSet.add(detailVO.getSourceId());
                    }
                }else{
                    //需要新增的
                    if(0==detailVO.getSourceType()){
                        CheckAddSet.add(detailVO.getSourceId());
                    }else {
                        // 要新增的 退货单id
                        returnAddSet.add(detailVO.getSourceId());
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(CheckDelSet)){
            LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(CheckEntity::getId,CheckDelSet);
            updateWrapper.set(CheckEntity::getAccountFlag, 0);
            checkService.update(updateWrapper);
        }
        if(CollectionUtils.isNotEmpty(CheckAddSet)){
            LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(CheckEntity::getId,CheckAddSet);
            updateWrapper.set(CheckEntity::getAccountFlag, 1);
            checkService.update(updateWrapper);
        }

        if(CollectionUtils.isNotEmpty(returnDelSet)){
            LambdaUpdateWrapper<ReturnGoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ReturnGoodsEntity::getId,returnDelSet);
            updateWrapper.set(ReturnGoodsEntity::getAccountFlag, 0);
            returnGoodsService.update(updateWrapper);
        }

        if(CollectionUtils.isNotEmpty(returnAddSet)){
            LambdaUpdateWrapper<ReturnGoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ReturnGoodsEntity::getId,returnAddSet);
            updateWrapper.set(ReturnGoodsEntity::getAccountFlag, 1);
            returnGoodsService.update(updateWrapper);
        }
        //删除对账
//        service.updateAccount(0, BeanMapper.map(saveOrUpdateVO, ReconciliationEntity.class), BeanMapper.mapList(detailList, ReconciliationDetailEntity.class));
//        Map<String, Object> hashMap = new HashMap<>();
//        hashMap.put("reconciliation_id", entity.getId());
//        collectService.removeByMap(hashMap);
        entity.setMaterialName(entity.getDetailList().stream().map(ReconciliationDetailEntity::getMaterialName).collect(Collectors.joining(",")));
        service.saveOrUpdate(entity, false);
        //更新对账信息
//        service.updateAccount(1, entity, entity.getDetailList());
        ReconciliationVO vo = BeanMapper.map(entity, ReconciliationVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryDetail(@RequestParam Long id) {
        ReconciliationEntity entity = service.selectById(id);
        ReconciliationVO vo = BeanMapper.map(entity, ReconciliationVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("供方提交或者采购方驳回")
    @RequestMapping(value = "/submitGF", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> submitGF(@RequestBody ReconciliationVO saveOrUpdateVO) {
        LambdaUpdateWrapper<ReconciliationEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ReconciliationEntity::getId,saveOrUpdateVO.getId());
        updateWrapper.set(ReconciliationEntity::getChangState, saveOrUpdateVO.getChangState());
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getReturnReason())){
            updateWrapper.set(ReconciliationEntity::getReturnReason, saveOrUpdateVO.getReturnReason());
        }
        service.update(updateWrapper);
        return  CommonResponse.success();
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReconciliationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReconciliationVO vo : vos) {
                ReconciliationEntity entity = service.selectById(vo.getId());
                //修改 需要删除验收单的引用
                Set<Long> CheckDelSet = new HashSet<>();
                Set<Long> returnDelSet = new HashSet<>();
                if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
                    for (ReconciliationDetailEntity detailVO : entity.getDetailList()) {
                        if(0==detailVO.getSourceType()){
                            CheckDelSet.add(detailVO.getSourceId());//要删除的 验收单id
                        }else{
                            // 要删除的 退货单id
                            returnDelSet.add(detailVO.getSourceId());
                        }
                    }
                }
                if(CollectionUtils.isNotEmpty(CheckDelSet)){
                    LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.in(CheckEntity::getId,CheckDelSet);
                    updateWrapper.set(CheckEntity::getAccountFlag, 0);
                    checkService.update(updateWrapper);
                }

                if(CollectionUtils.isNotEmpty(returnDelSet)){
                    LambdaUpdateWrapper<ReturnGoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.in(ReturnGoodsEntity::getId,returnDelSet);
                    updateWrapper.set(ReturnGoodsEntity::getAccountFlag, 0);
                    returnGoodsService.update(updateWrapper);
                }
            }
        }
        service.removeByIds(vos.stream().map(ReconciliationVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
//        String msg = service.updateBillSupSignSyncInfo(request);
//        if (StringUtils.isNotBlank(msg)) {
//            return CommonResponse.error(msg);
//        }
        return CommonResponse.success("签字状态回写成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        //1 采购端数据 - - 租户主键是自己的 or  供方数据 - - 租户主键是自己的 并且 供应商状态 in （审核中、已生效）
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<String> supState = new ArrayList<>();
        supState.add("checking");//供方状态--审核中
        supState.add("pass");//供方状态--已生效

        param.getComplexParams().add(getPageQueryParam(supState));

        IPage<ReconciliationEntity> page = service.queryPage(param, false);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReconciliationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    public ComplexParam getPageQueryParam(List<String> supState) {
        //1 采购端数据 - - 租户主键是自己的 or  供方数据 - - 租户主键是自己的 并且 供应商状态 in （审核中、已生效）
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sourceType", new Parameter(QueryParam.EQ, 1));//数据来源-采购端
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("sourceType",new Parameter(QueryParam.EQ,2));//数据来源-供方
        c3.getParams().put("changState",new Parameter(QueryParam.IN,supState));//状态 in 审批中，已生效的数据
        c1.getComplexParams().add(c3);
        return c1;
    }

    @ApiOperation("供方查询列表")
    @RequestMapping(value = "/queryGFList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryGFList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        //1 供方数据 - - 供应商主键是自己的  or  采购端数据 - - 供应商主键是自己的 审批通过的数据
        /** 租户隔离 */
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();
        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));

        param.getComplexParams().add(getGFPageQueryParam());

        IPage<ReconciliationEntity> page = service.queryPage(param,false);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReconciliationVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    public ComplexParam getGFPageQueryParam() {
        //1 供方数据 - - 供应商主键是自己的  or  采购端数据 - - 供应商主键是自己的 审批通过的数据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sourceType", new Parameter(QueryParam.EQ, 1));//数据来源-采购端
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));//审批通过
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("sourceType",new Parameter(QueryParam.EQ,2));//数据来源-供方
        c1.getComplexParams().add(c3);
        return c1;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
//        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //1 采购端数据 - - 租户主键是自己的 or  供方数据 - - 租户主键是自己的 并且 供应商状态 in （审核中、已生效）
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<String> supState = new ArrayList<>();
        supState.add("checking");//供方状态--审核中
        supState.add("pass");//供方状态--已生效
        param.getComplexParams().add(getPageQueryParam(supState));
        List<ReconciliationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ReconciliationVO> vos = BeanMapper.mapList(list, ReconciliationVO.class);
//        vos.forEach(t -> t.setSignStatusName(t.getSignStatus() == 0 ? "未签字" : "已签字"));
        vos.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Reconciliation-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refReconciliationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> refReconciliationData(@RequestParam Integer
                                                                                 pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState",new Parameter(QueryParam.IN,billStateList));
        if (StringUtils.isNotEmpty(condition)&&JSONObject.parseObject(condition).containsKey("gfSupplierId")) {
            //说明是供方参照合同  只根据供应商主键查询
            /** 租户隔离 */
            CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
            if (!commonResponse.isSuccess()) {
                logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
                throw new BusinessException("获取供应商信息失败！");
            }
            Long supplierId = commonResponse.getData().getId();
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        }else{
            //说明是采购端
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        }
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("contract_id", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
            if (_con.containsKey("settleFlag")) {
                param.getParams().put("settle_flag", new Parameter(QueryParam.EQ, _con.get("settleFlag")));
            }
        }
        IPage<ReconciliationEntity> page = service.queryPage(param,false);
//        IPage<ReconciliationEntity> page = service.queryPage(param, false);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        //根据主表结果查询子表信息
        Map<Long,List<ReconciliationDetailEntity>> map = new HashMap<>();
        List<ReconciliationVO> resList = new ArrayList<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(page.getRecords())){
            resList = BeanMapper.mapList(page.getRecords(), ReconciliationVO.class);
            List<Long> ids = page.getRecords().stream().map(ReconciliationEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<ReconciliationDetailEntity> lambda = Wrappers.<ReconciliationDetailEntity>lambdaQuery();
            lambda.in(ReconciliationDetailEntity::getReconciliationId, ids);
            List<ReconciliationDetailEntity> listRes = reconciliationDetailService.list(lambda);
            map = listRes .stream().collect(Collectors.groupingBy(ReconciliationDetailEntity::getReconciliationId));
            for(ReconciliationVO e:resList){
                if(org.apache.commons.collections.CollectionUtils.isNotEmpty(map.get(e.getId()))){
                    e.setDetailList(BeanMapper.mapList(map.get(e.getId()), ReconciliationDetailVO.class));
                }
            }
        }
        pageData.setRecords(resList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }
    @ApiOperation("查询合同累计对账数量")
    @RequestMapping(value = "/queryReconciliationNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryReconciliationNum(@RequestParam Long id) {
        ReconciliationVO reconciliationVO = new ReconciliationVO();
        Integer size = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", id).in("bill_state",Arrays.asList(1,3)).eq("dr",0)).size();
        reconciliationVO.setTotalReconciliationNum(size);

        BigDecimal currentTaxMny = BigDecimal.ZERO; // 结算金额
        BigDecimal currentMny = BigDecimal.ZERO; // 结算金额(无税)

        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(SettlementEntity::getCreateTime);
        wrapper.in(SettlementEntity::getBillState, 1,3);//防止修改时获取本单据的数据
        wrapper.eq(SettlementEntity::getContractId, id);
        List<SettlementEntity> list = settlementService.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny  = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliationVO.setSumSettlementMny(currentMny);
            reconciliationVO.setSumSettlementTaxMny(currentTaxMny);
        }

        //发票金额
        LambdaQueryWrapper<InvoiceReceiveRegistEntity> lambda = Wrappers.<InvoiceReceiveRegistEntity>lambdaQuery();
        lambda.eq(InvoiceReceiveRegistEntity::getContractId, id);
        lambda.in(InvoiceReceiveRegistEntity::getBillState, 1,3);
        List<InvoiceReceiveRegistEntity> invoiceList = invoiceReceiveRegistService.list(lambda);
        BigDecimal contractInvoiceTaxMny = BigDecimal.ZERO;
        BigDecimal contractInvoiceMny = BigDecimal.ZERO;
        BigDecimal contractPayMny = BigDecimal.ZERO;
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(invoiceList)){
            contractInvoiceTaxMny = invoiceList.stream().filter(e -> null != e.getCurrentReceiveMnyTax()).map(InvoiceReceiveRegistEntity::getCurrentReceiveMnyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            contractInvoiceMny = invoiceList.stream().filter(e -> null != e.getCurrentReceiveMny()).map(InvoiceReceiveRegistEntity::getCurrentReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        //支付金额
        LambdaQueryWrapper<PayContractEntity> paylambda = Wrappers.<PayContractEntity>lambdaQuery();
        paylambda.eq(PayContractEntity::getContractId, id);
        paylambda.in(PayContractEntity::getBillState, 1,3);
        List<PayContractEntity> payList = payContractService.list(paylambda);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(payList)){
            contractPayMny = payList.stream().filter(e -> null != e.getPayMny()).map(PayContractEntity::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliationVO.setContractInvoiceMny(contractInvoiceMny);
        reconciliationVO.setContractInvoiceTaxMny(contractInvoiceTaxMny);
        reconciliationVO.setContractPayMny(contractPayMny);
        return CommonResponse.success("查询详情数据成功！", reconciliationVO);
    }
}
