package com.ejianc.business.promaterial.returnGoods.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.returnGoods.bean.ReturnGoodsEntity;
import com.ejianc.business.promaterial.returnGoods.service.IReturnGoodsService;
import com.ejianc.business.promaterial.returnGoods.vo.ReturnGoodsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 退货单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("returnGoods")
public class ReturnGoodsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "STORE_RETURN_GOODS_CODE";//此处需要根据实际修改

    @Autowired
    private IReturnGoodsService service;

    @Autowired
    private ISupplierApi supplierApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReturnGoodsVO> saveOrUpdate(@RequestBody ReturnGoodsVO saveOrUpdateVO) {
    	ReturnGoodsEntity entity = BeanMapper.map(saveOrUpdateVO, ReturnGoodsEntity.class);

        //校验合同是否存在未生效单据
//        QueryWrapper<ReturnGoodsEntity> query = new QueryWrapper<>();
//        query.eq("contract_id", saveOrUpdateVO.getContractId());
//        query.notIn("bill_state", BillStateEnum.COMMITED_STATE,BillStateEnum.PASSED_STATE);
//        if(null!=entity.getId()){
//            query.ne("id", entity.getId());
//        }

        LambdaQueryWrapper<ReturnGoodsEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ReturnGoodsEntity::getContractId, saveOrUpdateVO.getContractId());
        wrapper.notIn(ReturnGoodsEntity::getBillState, 1, 3);//未生效条件
        if(null!=entity.getId()){
            wrapper.ne(ReturnGoodsEntity::getId, entity.getId());
        }
        List<ReturnGoodsEntity> list = service.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("保存失败，该合同下存在未生效单据，请勿重复添加！");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ReturnGoodsVO vo = BeanMapper.map(entity, ReturnGoodsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReturnGoodsVO> queryDetail(Long id) {
    	ReturnGoodsEntity entity = service.selectById(id);
    	ReturnGoodsVO vo = BeanMapper.map(entity, ReturnGoodsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReturnGoodsVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ReturnGoodsVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ReturnGoodsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReturnGoodsVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialNames");
        /** 租户隔离 */
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ReturnGoodsEntity> page = service.queryPage(param,false);
        IPage<ReturnGoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReturnGoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryGFList 供方查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGFList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReturnGoodsVO>> queryGFList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialNames");
        /** 租户隔离 */
        // 2，先根据供方租户主键查询到自己在采购方对应的供应商主键
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();

        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState",new Parameter(QueryParam.IN,billStateList));

        IPage<ReturnGoodsEntity> page = service.queryPage(param,false);
        IPage<ReturnGoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReturnGoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialNames");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReturnGoodsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ReturnGoods-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refReturnGoodsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReturnGoodsVO>> refReturnGoodsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ReturnGoodsEntity> page = service.queryPage(param,false);
        IPage<ReturnGoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReturnGoodsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
