package com.ejianc.business.promaterial.settlement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementCollectEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementFeeEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 结算单主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_settlement")
public class SettlementEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="settlement_date")
    private Date settlementDate; // 结算日期
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="sign_status")
    private Integer signStatus; // 签字状态，0-未签字,1-已签字
    @TableField(value="signature_type")
    private Integer signatureType; // 结算类型，0-过程,1-最终
    @TableField(value="settlement_mny")
    private BigDecimal settlementMny; // 结算金额(无税)
    @TableField(value="settlement_tax_mny")
    private BigDecimal settlementTaxMny; // 结算金额
    @TableField(value="settlement_tax")
    private BigDecimal settlementTax; // 结算税额
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 材料金额(无税)
    @TableField(value="material_tax_mny")
    private BigDecimal materialTaxMny; // 材料金额
    @TableField(value="material_tax")
    private BigDecimal materialTax; // 材料税额
    @TableField(value="fee_mny")
    private BigDecimal feeMny; // 其他金额(无税)
    @TableField(value="fee_tax_mny")
    private BigDecimal feeTaxMny; // 其他金额
    @TableField(value="fee_tax")
    private BigDecimal feeTax; // 其他税额
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税）
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="contract_invoice_tax_mny")
    private BigDecimal contractInvoiceTaxMny; // 合同收票金额
    @TableField(value="contract_invoice_mny")
    private BigDecimal contractInvoiceMny; // 合同收票金额（无税）
    @TableField(value="contract_pay_mny")
    private BigDecimal contractPayMny; // 合同已付金额
    @TableField(value="current_settlement_tax_mny")
    private BigDecimal currentSettlementTaxMny; // 含本期结算金额
    @TableField(value="current_settlement_mny")
    private BigDecimal currentSettlementMny; // 含本期结算金额
    @TableField(value="contract_type")
    private Integer contractType; // 合同类型（1-材料合同, 2-安装合同）


    @TableField(value="supplier_employee_id")
    private Long supplierEmployeeId; // 供方经办人ID
    /**
     * 供方经办人名称
     */
    @TableField(value = "supplier_employee_name")
    private String supplierEmployeeName;

    /**
     * 数据来源1-采购方 2-供方
     */
    @TableField(value="source_type")
    private String sourceType;

    @TableField(value="chang_state")
    private String changState; // 供应商自己状态：未生效free、审核中checking、已生效pass，审核驳回returned
    @TableField(value="return_reason")
    private String returnReason; // 驳回原因
    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String systemId;
    @TableField(value = "settlement_num")
    private Integer settlementNum;//生效结算次数
    /**
     * 累计已申请金额(资金返写，累计值)
     */
    @TableField(value = "current_apply_amount")
    private BigDecimal currentApplyAmount;

    /**
     * 剩余可以申请金额 = 本期结算金额（含税）-累计已申请金额-本期抵扣金额
     * 初始化时候，此值=本期结算金额（含税）-本期抵扣金额
     */
    @TableField(value = "remain_can_apply_amount")
    private BigDecimal remainCanApplyAmount;

    @TableField(value="customer_id")
    private Long customerId; // 甲方Id
    @TableField(value="customer_name")
    private String customerName; // 甲方名称

    @TableField(exist=false)
    @SubEntity(serviceName="settlementDetailService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettlementDetailEntity> settlementDetailList = new ArrayList<>(); // 结算单明细表
    @TableField(exist=false)
    @SubEntity(serviceName="settlementCollectService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettlementCollectEntity> settlementCollectList = new ArrayList<>(); // 结算单汇总表
    @TableField(exist=false)
    @SubEntity(serviceName="settlementFeeService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettlementFeeEntity> settlementFeeList = new ArrayList<>(); // 结算单其他费用表

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public BigDecimal getCurrentApplyAmount() {
        return currentApplyAmount;
    }

    public void setCurrentApplyAmount(BigDecimal currentApplyAmount) {
        this.currentApplyAmount = currentApplyAmount;
    }

    public BigDecimal getRemainCanApplyAmount() {
        return remainCanApplyAmount;
    }

    public void setRemainCanApplyAmount(BigDecimal remainCanApplyAmount) {
        this.remainCanApplyAmount = remainCanApplyAmount;
    }

    public String getChangState() {
        return changState;
    }

    public void setChangState(String changState) {
        this.changState = changState;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getSettlementNum() {
        return settlementNum;
    }

    public void setSettlementNum(Integer settlementNum) {
        this.settlementNum = settlementNum;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getContractInvoiceMny() {
        return contractInvoiceMny;
    }

    public void setContractInvoiceMny(BigDecimal contractInvoiceMny) {
        this.contractInvoiceMny = contractInvoiceMny;
    }

    public BigDecimal getCurrentSettlementMny() {
        return currentSettlementMny;
    }

    public void setCurrentSettlementMny(BigDecimal currentSettlementMny) {
        this.currentSettlementMny = currentSettlementMny;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getSignatureType() {
        return signatureType;
    }

    public void setSignatureType(Integer signatureType) {
        this.signatureType = signatureType;
    }
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }

    public BigDecimal getFeeMny() {
        return feeMny;
    }

    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }

    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }

    public BigDecimal getFeeTax() {
        return feeTax;
    }

    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractInvoiceTaxMny() {
        return contractInvoiceTaxMny;
    }

    public void setContractInvoiceTaxMny(BigDecimal contractInvoiceTaxMny) {
        this.contractInvoiceTaxMny = contractInvoiceTaxMny;
    }

    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }
    public BigDecimal getCurrentSettlementTaxMny() {
        return currentSettlementTaxMny;
    }

    public void setCurrentSettlementTaxMny(BigDecimal currentSettlementTaxMny) {
        this.currentSettlementTaxMny = currentSettlementTaxMny;
    }

    public List<SettlementDetailEntity> getSettlementDetailList() {
        return settlementDetailList;
    }

    public void setSettlementDetailList(List<SettlementDetailEntity> settlementDetailList) {
        this.settlementDetailList = settlementDetailList;
    }
    public List<SettlementCollectEntity> getSettlementCollectList() {
        return settlementCollectList;
    }

    public void setSettlementCollectList(List<SettlementCollectEntity> settlementCollectList) {
        this.settlementCollectList = settlementCollectList;
    }
    public List<SettlementFeeEntity> getSettlementFeeList() {
        return settlementFeeList;
    }

    public void setSettlementFeeList(List<SettlementFeeEntity> settlementFeeList) {
        this.settlementFeeList = settlementFeeList;
    }
}
