package com.ejianc.business.promaterial.settlement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.returnGoods.bean.ReturnGoodsEntity;
import com.ejianc.business.promaterial.returnGoods.service.IReturnGoodsService;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.mapper.SettlementMapper;
import com.ejianc.business.promaterial.settlement.service.ISettlementCollectService;
import com.ejianc.business.promaterial.settlement.service.ISettlementDetailService;
import com.ejianc.business.promaterial.settlement.service.ISettlementFeeService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.ContractSettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算单主表
 *
 * @author generator
 *
 */
@Service("settlementService")
public class SettlementServiceImpl extends BaseServiceImpl<SettlementMapper, SettlementEntity> implements ISettlementService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayContractService payContractService;


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE_C = "JS_CODE";//此处需要根据实际修改
    @Autowired
    private IContractService contractService;//合同
    @Autowired
    private ICheckService checkService;

    @Autowired
    private IReconciliationService reconciliationService;
    @Autowired
    private IReturnGoodsService returnGoodsService;

    @Autowired
    private IInvoiceReceiveRegistService invoiceReceiveRegistService;


    /*根据合同id查询*/
    @Override
    public SettlementRecordVO querySettleRecord(Long contractId) {
        SettlementRecordVO vo = new SettlementRecordVO();
        ContractEntity contractEntity = contractService.selectById(contractId);
        vo.setContractId(contractId);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getContractId, contractId);
        wrapper.eq(SettlementEntity::getDr, 0);
        wrapper.in(SettlementEntity::getBillState,1,3);
        wrapper.orderByAsc(SettlementEntity::getCreateTime);
        List<SettlementEntity> list = super.list(wrapper);
        List<SettlementVO> vos = BeanMapper.mapList(list, SettlementVO.class);
        if(CollectionUtils.isNotEmpty(vos)){
            BigDecimal totalSettlementTaxMny = vos.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementVO::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalSettlementTaxMny(totalSettlementTaxMny);
        }else{
            vo.setTotalSettlementTaxMny(BigDecimal.ZERO);
        }

        if(vo.getContractTaxMny()==null || BigDecimal.ZERO.compareTo(vo.getContractTaxMny()) == 0) {
            vo.setSettleRatio(BigDecimal.ZERO);
        } else {
            vo.setSettleRatio(vo.getTotalSettlementTaxMny().divide(vo.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        vo.setSettlementList(vos);
        //查询是否有最终结算单
        LambdaQueryWrapper<SettlementEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(SettlementEntity::getContractId, contractId);
        wrapper2.eq(SettlementEntity::getDr, 0);
        wrapper2.eq(SettlementEntity::getSignatureType, 1);//最终
        List<SettlementEntity> list2 = super.list(wrapper2);
        vo.setFlag(!CollectionUtils.isNotEmpty(list2));
        //查询是否有未生效的过程结算单
        LambdaQueryWrapper<SettlementEntity> wrapper3 = new LambdaQueryWrapper<>();
        wrapper3.eq(SettlementEntity::getContractId, contractId);
        wrapper3.eq(SettlementEntity::getDr, 0);
        wrapper3.notIn(SettlementEntity::getBillState, 1,3);
        wrapper3.eq(SettlementEntity::getSignatureType, 0);//过程
        List<SettlementEntity> list3 = super.list(wrapper3);
        vo.setFlagTwo(!CollectionUtils.isNotEmpty(list3));
        return vo;
    }

    @Override
    public CommonResponse<SettlementVO> saveOrUpdate(SettlementVO saveOrUpdateVO) {
//        // 校验结算明细
//        if(CollectionUtils.isEmpty(saveOrUpdateVO.getSettlementDetailList())){
//            throw new BusinessException("检测到当前结算单的材料明细为空，无法保存！");
//        }
        SettlementEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            if (null!=entity.getContractId() && this.queryExist(entity.getContractId())){
                throw new BusinessException("该合同下有未生效的结算单！");
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE_C,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修改 需要删除验收单的引用
        Set<Long> CheckDelSet = new HashSet<>();
        Set<Long> CheckAddSet = new HashSet<>();

        Set<Long> dzDelSet = new HashSet<>();
        Set<Long> dzAddSet = new HashSet<>();

        Set<Long> returnDelSet = new HashSet<>();
        Set<Long> returnAddSet = new HashSet<>();
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getSettlementDetailList())) {
            for (SettlementDetailVO detailVO : saveOrUpdateVO.getSettlementDetailList()) {
                if ("del".equals(detailVO.getRowState())) {
                    if(0==detailVO.getSourceType()){
                        dzDelSet.add(detailVO.getReconciliationId());//要删除的 对账id
                    }else if(1==detailVO.getSourceType()){
                        CheckDelSet.add(detailVO.getSourceId());//要删除的 验收单id
                    }else if(2==detailVO.getSourceType()){
                        // 要删除的 退货单id
                        returnDelSet.add(detailVO.getSourceId());
                    }
                }else{
                    //需要新增的
                    if(0==detailVO.getSourceType()){
                        dzAddSet.add(detailVO.getReconciliationId());
                    }else if(1==detailVO.getSourceType()){
                        CheckAddSet.add(detailVO.getSourceId());
                    }else if(2==detailVO.getSourceType()){
                        // 要新增的 退货单id
                        returnAddSet.add(detailVO.getSourceId());
                    }
                }
            }
        }
        //初始化签章，签字状态
        entity.setSignStatus(0);
        super.saveOrUpdate(entity, false);
        if(CollectionUtils.isNotEmpty(CheckDelSet)){
            LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(CheckEntity::getId,CheckDelSet);
            updateWrapper.set(CheckEntity::getSettleFlag, 0);
            checkService.update(updateWrapper);
        }
        if(CollectionUtils.isNotEmpty(CheckAddSet)){
            LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(CheckEntity::getId,CheckAddSet);
            updateWrapper.set(CheckEntity::getSettleFlag, 1);
            checkService.update(updateWrapper);
        }

        if(CollectionUtils.isNotEmpty(dzDelSet)){
            LambdaUpdateWrapper<ReconciliationEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ReconciliationEntity::getId,dzDelSet);
            updateWrapper.set(ReconciliationEntity::getSettleFlag, 0);
            reconciliationService.update(updateWrapper);
        }
        if(CollectionUtils.isNotEmpty(dzAddSet)){
            LambdaUpdateWrapper<ReconciliationEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ReconciliationEntity::getId,dzAddSet);
            updateWrapper.set(ReconciliationEntity::getSettleFlag, 1);
            reconciliationService.update(updateWrapper);
        }

        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(returnDelSet)){
            LambdaUpdateWrapper<ReturnGoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ReturnGoodsEntity::getId,returnDelSet);
            updateWrapper.set(ReturnGoodsEntity::getSettleFlag, 0);
            returnGoodsService.update(updateWrapper);
        }

        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(returnAddSet)){
            LambdaUpdateWrapper<ReturnGoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ReturnGoodsEntity::getId,returnAddSet);
            updateWrapper.set(ReturnGoodsEntity::getSettleFlag, 1);
            returnGoodsService.update(updateWrapper);
        }
        SettlementVO vo = BeanMapper.map(entity, SettlementVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /*是否有为生效的结算单*/
    public boolean queryExist(Long contractId){
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getContractId, contractId);
        wrapper.notIn(SettlementEntity::getBillState, 1, 3);//未生效条件
        List<SettlementEntity> list = super.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {//有数据表示有未生效的结算单
            return true;
        }
        return false;
    }

    /*获取最近一次含本期结算金额和结算日期 ，结算次数*/
    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        Map<String, Object> map = new HashMap<>();
        BigDecimal currentTaxMny = BigDecimal.ZERO; // 结算金额
        BigDecimal currentMny = BigDecimal.ZERO; // 结算金额(无税)
        String sTDate  = null;
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(SettlementEntity::getCreateTime);
        wrapper.in(SettlementEntity::getBillState, 1,3);//防止修改时获取本单据的数据
        wrapper.eq(SettlementEntity::getDr, 0);
        wrapper.eq(SettlementEntity::getContractId, contractId);
        List<SettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            SettlementEntity settlementEntity = list.get(0);
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny  = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            sTDate = DateFormatUtil.formatDate("yyyy-MM-dd", settlementEntity.getSettlementDate());
        }
        //发票金额
        LambdaQueryWrapper<InvoiceReceiveRegistEntity> lambda = Wrappers.<InvoiceReceiveRegistEntity>lambdaQuery();
        lambda.eq(InvoiceReceiveRegistEntity::getContractId, contractId);
        lambda.in(InvoiceReceiveRegistEntity::getBillState, 1,3);
        List<InvoiceReceiveRegistEntity> invoiceList = invoiceReceiveRegistService.list(lambda);
        BigDecimal contractInvoiceTaxMny = BigDecimal.ZERO;
        BigDecimal contractInvoiceMny = BigDecimal.ZERO;
        BigDecimal contractPayMny = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(invoiceList)){
            contractInvoiceTaxMny = invoiceList.stream().filter(e -> null != e.getCurrentReceiveMnyTax()).map(InvoiceReceiveRegistEntity::getCurrentReceiveMnyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            contractInvoiceMny = invoiceList.stream().filter(e -> null != e.getCurrentReceiveMny()).map(InvoiceReceiveRegistEntity::getCurrentReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        //支付金额
        LambdaQueryWrapper<PayContractEntity> paylambda = Wrappers.<PayContractEntity>lambdaQuery();
        paylambda.eq(PayContractEntity::getContractId, contractId);
        paylambda.in(PayContractEntity::getBillState, 1,3);
        List<PayContractEntity> payList = payContractService.list(paylambda);
        if(CollectionUtils.isNotEmpty(payList)){
            contractPayMny = payList.stream().filter(e -> null != e.getPayMny()).map(PayContractEntity::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        map.put("contractInvoiceTaxMny",contractInvoiceTaxMny);
        map.put("contractInvoiceMny",contractInvoiceMny);
        map.put("contractPayMny",contractPayMny);
        map.put("currentTaxMny",currentTaxMny);
        map.put("currentMny",currentMny);
        map.put("sTDate",sTDate);
        if(CollectionUtils.isNotEmpty(list)){
            map.put("settlementNum",list.size());
        }else{
            map.put("settlementNum",0);
        }
        return CommonResponse.success("获取金额和时间、结算次数成功,！",map);
    }


    /*删除*/
    @Override
    public CommonResponse<String> delete(List<SettlementVO> vos) {
       if(CollectionUtils.isNotEmpty(vos)){
           for (SettlementVO vo : vos) {
               SettlementEntity entity = super.selectById(vo.getId());
               //修改 需要删除验收单的引用
               Set<Long> CheckDelSet = new HashSet<>();
               Set<Long> dzDelSet = new HashSet<>();
               Set<Long> returnDelSet = new HashSet<>();
               if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
                   for (SettlementDetailEntity detailVO : entity.getSettlementDetailList()) {
                       if(0==detailVO.getSourceType()){
                           dzDelSet.add(detailVO.getReconciliationId());//要删除的 对账id
                       }else if(1==detailVO.getSourceType()){
                           CheckDelSet.add(detailVO.getSourceId());//要删除的 验收单id
                       }else if(2==detailVO.getSourceType()){
                           // 要删除的 退货单id
                           returnDelSet.add(detailVO.getSourceId());
                       }
                   }
               }
               if(CollectionUtils.isNotEmpty(CheckDelSet)){
                   LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
                   updateWrapper.in(CheckEntity::getId,CheckDelSet);
                   updateWrapper.set(CheckEntity::getSettleFlag, 0);
                   checkService.update(updateWrapper);
               }
               if(CollectionUtils.isNotEmpty(dzDelSet)){
                   LambdaUpdateWrapper<ReconciliationEntity> updateWrapper = new LambdaUpdateWrapper<>();
                   updateWrapper.in(ReconciliationEntity::getId,dzDelSet);
                   updateWrapper.set(ReconciliationEntity::getSettleFlag, 0);
                   reconciliationService.update(updateWrapper);
               }
               if(CollectionUtils.isNotEmpty(returnDelSet)){
                   LambdaUpdateWrapper<ReturnGoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
                   updateWrapper.in(ReturnGoodsEntity::getId,returnDelSet);
                   updateWrapper.set(ReturnGoodsEntity::getSettleFlag, 0);
                   returnGoodsService.update(updateWrapper);
               }
           }
       }
        super.removeByIds(vos.stream().map(SettlementVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 根据合同id查询当前合同下结算列表
     *
     * @param contractId 合同id
     * @return 查询结果
     */
    @Override
    public ContractSettlementRecordVO queryDetailRecord(Long contractId) {
        ContractSettlementRecordVO settleRecordVO = new ContractSettlementRecordVO();

        ContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());

        QueryWrapper<SettlementEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE
                .getBillStateCode());
        listQuery.orderByDesc("settlement_date");
        List<SettlementEntity> list = super.list(listQuery);
        List<SettlementVO> rentSettlementVOS = BeanMapper.mapList(list, SettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);

        //累计结算金额
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            contractSettleMny = list.stream().map(SettlementEntity::getSettlementTaxMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);

        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        }
        else {
            settleRecordVO.setSettleRate((settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100)))
                    .divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    /**
     * 根据合同id查询对应的结算列表
     *
     * @param settlementVO 合同id、结算类型
     * @return 查询结果
     */
    @Override
    public List<SettlementVO> querySettlementByContractId(SettlementVO settlementVO) {
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        List<SettlementVO> rtnList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            rtnList = BeanMapper.mapList(list, SettlementVO.class);
            for (SettlementVO vo : rtnList) {
                vo.setSettlementDateStr(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getSettlementDate()));
                vo.setBillCodeLink(vo.getBillCode());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        return rtnList;
    }

    @Override
    public IPage<SettlementVO> queryForList(QueryParam queryParam, boolean isEs) {
        // 结算跳转付款申请制单标识
        boolean payApplyFlagHasFree = queryParam.getParams().containsKey("payApplyFlagHasFree");
        queryParam.getParams().remove("payApplyFlagHasFree");
        IPage<SettlementVO> voPage = null;
        IPage<SettlementEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            List<SettlementVO> purchaseSettlementVOS = BeanMapper.mapList(entityPage.getRecords(), SettlementVO.class);
            if (payApplyFlagHasFree && CollectionUtils.isNotEmpty(purchaseSettlementVOS)) {
                List<Long> settleIds = purchaseSettlementVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
                Map<Long, BigDecimal> settleApplyData = payContractService.getApplyMnyHasFree(settleIds, null);
                for (SettlementVO purchaseSettlementRefVo : purchaseSettlementVOS) {
                    BigDecimal sumApplyMnyHasFree = settleApplyData.get(purchaseSettlementRefVo.getId());
                    purchaseSettlementRefVo.setCurrentApplyAmount(sumApplyMnyHasFree);
                    BigDecimal surplusApplyMny = com.ejianc.framework.core.util.ComputeUtil.safeSub(purchaseSettlementRefVo.getSettlementTaxMny(), sumApplyMnyHasFree);
                    purchaseSettlementRefVo.setRemainCanApplyAmount(surplusApplyMny);
                }
            }
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(purchaseSettlementVOS);
        }
        return voPage;
    }

    /**
     * 根据合同id查询结算单列表
     *
     * @param settlementVO 合同id、结算单类型
     * @return 查询结果
     */
    private List<SettlementEntity> queryListByContractId(SettlementVO settlementVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, settlementVO.getContractId()));
        queryParam.getOrderMap().put("settlementDate", QueryParam.DESC);
        return super.queryList(queryParam, false);
    }

}
