package com.ejianc.business.promaterial.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.promaterial.taxnew.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.promaterial.utils.ConvertUpMoney;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 收票登记
 *
 * @author generator
 *
 */
@Service("invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity> implements IInvoiceReceiveRegistService {

    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "tax-receive-pool-001";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "tax-receive-code-001";

    //收票登记 发票代码
    private static final String configCodeDm = "TAX_FPDM";
    //收票登记 发票号码
    private static final String configCodeHm = "TAX_FPHM";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 增加或修改对象
     *
     * @param entity 实体对象
     */
    @Override
    public boolean insertOrUpdate(InvoiceReceiveRegistEntity entity) {
        Long invoiceQuantity = 0L ; // 发票数量
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(ListUtil.isNotEmpty(entity.getInvoiceReceiveList())){
            CommonResponse<List<DefdocDetailVO>> defList = defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String, String> defMap = getDefMap(defList.getData());

            checkPool(entity.getInvoiceReceiveList());

            invoiceQuantity = entity.getInvoiceReceiveList().stream().filter(e -> !"del".equals(e.getRowState())).count();
            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceiveList()) {
                if ("add".equals(poolEntity.getRowState())) {
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (billCode.isSuccess()) {
                        poolEntity.setBillCode(billCode.getData());
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    BigDecimal taxMny = poolEntity.getTaxMny();
                    String memo = poolEntity.getMemo();
                    List<Long> attachIds = poolEntity.getAttachIds();
                    BeanUtils.copyProperties(entity, poolEntity, "invoiceType", "invoiceTypeName");
                    poolEntity.setAttachIds(attachIds);
                    poolEntity.setMemo(memo);
                    poolEntity.setTaxMny(taxMny);
                    poolEntity.setId(null);
                    poolEntity.setBillState(0);
                }
                poolEntity.setInvoiceTypeName(defMap.get(poolEntity.getInvoiceType()+""));
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setContractId(entity.getContractId());
                poolEntity.setContractName(entity.getContractName());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
                poolEntity.setCustomerId(entity.getBuyerId());
                poolEntity.setCustomerName(entity.getBuyerName());
                poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setRegist(false);
                poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
                poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
                poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
                poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
                poolEntity.setAuthState(0);
                poolEntity.setDeductionState(0);
                poolEntity.setFlag(0);
                poolEntity.setTaxCostFlag(0);
                if(entity.getPurchaseType()!= null){
                    poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
                }
                if(entity.getDependOnProject()!= null){
                    poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
                }
                if(poolEntity.getContractId()!= null ){
                    poolEntity.setType(1);
                }else{
                    poolEntity.setType(2);
                }
                poolEntity.setOrgId(entity.getOrgId());
                poolEntity.setOrgName(entity.getOrgName());
                poolEntity.setProjectId(entity.getProjectId());
                poolEntity.setProjectName(entity.getProjectName());
                poolEntity.setContractCode(entity.getContractCode());
                // 平台优化后，子表创建人编码不自动添加了，这里手动添加下
                poolEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                poolEntity.setSupplierEmployeeId(entity.getSupplierEmployeeId());
                poolEntity.setSupplierEmployeeName(entity.getSupplierEmployeeName());
                poolEntity.setSourceType(entity.getSourceType());
                poolEntity.setChangState(entity.getChangState());
            }
        }

        entity.setInvoiceQuantity(invoiceQuantity.intValue());


        return super.saveOrUpdateNoES(entity);
    }

    /**
     * 验证发票提交中的发票是否存在重复
     * @param poolList
     */
    public void checkPool(List<InvoiceReceivePoolEntity> poolList) {
        List<String> invoiceNumberList = new ArrayList<>();
        for (InvoiceReceivePoolEntity vo : poolList) {
            if (!"del".equals(vo.getRowState())) {
                String invoiceNumber = vo.getInvoiceNumber();
                if (StringUtils.isNotEmpty(invoiceNumber)) {
                    if (invoiceNumberList.contains(invoiceNumber)) {
                        throw new BusinessException("发票号码【" + invoiceNumber + "】录入重复！");
                    }
                    invoiceNumberList.add(invoiceNumber);

                    LambdaQueryWrapper<InvoiceReceivePoolEntity> invoiceNumberQueryWrapper = new LambdaQueryWrapper<>();
                    invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getInvoiceNumber, invoiceNumber);
                    invoiceNumberQueryWrapper.ne(vo.getReceiveBillId() != null, InvoiceReceivePoolEntity::getReceiveBillId, vo.getReceiveBillId());
                    int count = invoiceReceivePoolService.count(invoiceNumberQueryWrapper);
                    if (count > 0) {
                        throw new BusinessException("发票号码【" + vo.getInvoiceNumber() + "】已存在！");
                    }
                }
            }

        }
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public Map<String, String> getDefMapName(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    /**
     *  生成一条子表数据
     * @param entity
     * @return
     */
    public List<InvoiceReceivePoolEntity> generateInvoiceReceivePool(InvoiceReceiveRegistEntity entity){
        InvoiceReceivePoolEntity poolEntity = new InvoiceReceivePoolEntity();
        //originType为0 是默认生成
        poolEntity.setOriginType(0);
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            poolEntity.setBillCode(billCode.getData());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        poolEntity.setId(null);
        poolEntity.setReceiveBillCode(entity.getCode());
        poolEntity.setReceiveBillId(entity.getId());
        //无合同
        poolEntity.setType(2);
        poolEntity.setBillState(0);
        //其他
        CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String,String> defMap =getDefMapName(defList.getData());
        String invoiceType = defMap.get("其他");
        if(StringUtils.isNotEmpty(invoiceType)){
            poolEntity.setInvoiceType(Long.valueOf(invoiceType));
            poolEntity.setInvoiceTypeName("其他");
        }else{
            throw new BusinessException("网络异常， 发票类型获取失败");
        }
        poolEntity.setInvoiceCode(getBillCode(configCodeDm));
        poolEntity.setInvoiceNumber(getBillCode(configCodeHm));
        poolEntity.setInvoiceDate(new Date());
        poolEntity.setInvoiceMny(ComputeUtil.nullToZero(entity.getCurrentReceiveMny()));
        poolEntity.setTaxMny(ComputeUtil.nullToZero(entity.getTaxMny()));
        poolEntity.setInvoiceTaxMny(ComputeUtil.nullToZero(ComputeUtil.safeAdd(poolEntity.getInvoiceMny(),poolEntity.getTaxMny())));
        //金额转中文大写
        //整数
        if(new BigDecimal(poolEntity.getInvoiceTaxMny().intValue()).compareTo(poolEntity.getInvoiceTaxMny())==0){
            poolEntity.setInvoiceTaxMnys(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString())+"整");
        }else{
            poolEntity.setInvoiceTaxMnys(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()));
        }

        poolEntity.setContractId(entity.getContractId());
        poolEntity.setContractCode(entity.getContractCode());
        poolEntity.setContractName(entity.getContractName());
        poolEntity.setSupplierId(entity.getSellerId());
        poolEntity.setSupplierName(entity.getSellerName());
        poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
        poolEntity.setCustomerId(entity.getBuyerId());
        poolEntity.setCustomerName(entity.getBuyerName());
        poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
        poolEntity.setEmployeeId(entity.getProcessPersonId());
        poolEntity.setEmployeeName(entity.getProcessPersonName());
        poolEntity.setRegist(false);
        poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
        poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
        poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
        poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
        poolEntity.setAuthState(0);
        poolEntity.setDeductionState(0);
        poolEntity.setFlag(0);
        if(entity.getPurchaseType()!= null){
            poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
        }
        if(entity.getDependOnProject()!= null){
            poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
        }
        if(poolEntity.getContractId()!= null ){
            poolEntity.setType(1);
        }else{
            poolEntity.setType(2);
        }
        poolEntity.setOrgId(entity.getOrgId());
        poolEntity.setOrgName(entity.getOrgName());
        poolEntity.setProjectId(entity.getProjectId());
        poolEntity.setProjectName(entity.getProjectName());

        poolEntity.setSupplierEmployeeId(entity.getSupplierEmployeeId());
        poolEntity.setSupplierEmployeeName(entity.getSupplierEmployeeName());
        poolEntity.setSourceType(entity.getSourceType());
        poolEntity.setChangState(entity.getChangState());

        List<InvoiceReceivePoolEntity> list = new ArrayList<>();
        list.add(poolEntity);
        return list;
    }

    /**
     * 获取billCode
     * @return
     */
    public String getBillCode(String code){
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            return billCode.getData();
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }
}
