/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if ("2".equals(entity.getSourceType())) {
            entity.setChangState("pass");
            this.checkService.saveOrUpdate((Object)entity, false);
        }
        Map<Long, BigDecimal> checkDetailMap = entity.getCheckDetailList().stream().filter(e -> null != e.getOrderDetailId()).collect(Collectors.toMap(e -> e.getOrderDetailId(), e -> e.getCheckNum()));
        Integer checkStatus = 0;
        if (null != entity.getDeliveryType() && entity.getDeliveryType() == 1) {
            DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()));
            LambdaQueryWrapper lambdaCheckDetail = Wrappers.lambdaQuery();
            lambdaCheckDetail.eq(CheckDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
            List checkDetailEntityList = this.checkDetailService.list((Wrapper)lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty((Collection)checkDetailEntityList)) {
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper lambdaDeliveryDetail = Wrappers.lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
                List deliveryDetailEntityList = this.deliveryDetailService.list((Wrapper)lambdaDeliveryDetail);
                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null != deliveryDetailEntity.getCheckNum()) continue;
                    deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                }
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getTimeDeliverNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getTimeDeliverNum()) == -1);
                if (allCheck.booleanValue()) {
                    checkStatus = 2;
                    deliveryEntity.setOrderFlag(1);
                }
                if (anyCheck.booleanValue()) {
                    checkStatus = 1;
                }
                deliveryEntity.setCheckState(checkStatus);
                this.deliveryService.updateById((Object)deliveryEntity);
                this.deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
        }
        if (null != entity.getOrderId() && !"3".equals(entity.getSourceType())) {
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(entity.getOrderId()));
            for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
                if (!checkDetailMap.containsKey(orderDetailEntity.getId())) continue;
                orderDetailEntity.setCheckNum(ComputeUtil.safeAdd((BigDecimal)(null != orderDetailEntity.getCheckNum() ? orderDetailEntity.getCheckNum() : BigDecimal.ZERO), (BigDecimal)checkDetailMap.get(orderDetailEntity.getId())));
            }
            this.orderService.saveOrUpdate((Object)orderEntity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()));
        if (null != deliveryEntity && deliveryEntity.getOrderFlag() == 1) {
            return CommonResponse.error((String)"\u9001\u8d27\u5355\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if ("2".equals(entity.getSourceType())) {
            entity.setChangState("checking");
            this.checkService.saveOrUpdate((Object)entity, false);
        }
        Map<Long, BigDecimal> checkDetailMap = entity.getCheckDetailList().stream().filter(e -> null != e.getOrderDetailId()).collect(Collectors.toMap(e -> e.getOrderDetailId(), e -> e.getCheckNum()));
        Integer checkStatus = 0;
        List<CheckDetailEntity> checkDetailList = entity.getCheckDetailList();
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()));
        if (deliveryEntity != null) {
            List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
            Map checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity()));
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                if (!checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) continue;
                CheckDetailEntity checkDetailEntity = (CheckDetailEntity)((Object)checkDetailEntityMap.get(deliveryDetailEntity.getId()));
                deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
            }
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getTimeDeliverNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getTimeDeliverNum()) == -1);
            if (allCheck.booleanValue()) {
                checkStatus = 2;
            }
            if (anyCheck.booleanValue()) {
                checkStatus = 1;
            }
            deliveryEntity.setCheckState(checkStatus);
            this.deliveryService.updateById((Object)deliveryEntity);
            this.deliveryDetailService.updateBatchById(deliveryDetailList);
        }
        if (null != entity.getOrderId() && !"3".equals(entity.getSourceType())) {
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(entity.getOrderId()));
            for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
                if (!checkDetailMap.containsKey(orderDetailEntity.getId())) continue;
                orderDetailEntity.setCheckNum(ComputeUtil.safeSub((BigDecimal)(null != orderDetailEntity.getCheckNum() ? orderDetailEntity.getCheckNum() : BigDecimal.ZERO), (BigDecimal)checkDetailMap.get(orderDetailEntity.getId())));
            }
            this.orderService.saveOrUpdate((Object)orderEntity, false);
        }
        return CommonResponse.success();
    }
}

