/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.enums.DeliverCheckStateEnum;
import com.ejianc.business.promaterial.delivery.mapper.DeliveryMapper;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryDetailVO;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.enums.DeliverStateEnum;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private ICheckService checkService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    @Transactional
    public DeliveryVO closeDelivery(Long id) {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)super.selectById((Serializable)id));
        deliveryEntity.setOrderFlag(1);
        super.updateById((Object)deliveryEntity);
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(deliveryEntity.getOrderId()));
        if (1 != orderEntity.getOrderFlag()) {
            HashMap<Long, BigDecimal> checkMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> deliverMap = new HashMap<Long, BigDecimal>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryEntity.getDeliveryDetailList()) {
                checkMap.put(deliveryDetailEntity.getOrderDetailId(), null != deliveryDetailEntity.getCheckNum() ? deliveryDetailEntity.getCheckNum() : BigDecimal.ZERO);
                deliverMap.put(deliveryDetailEntity.getOrderDetailId(), null != deliveryDetailEntity.getTimeDeliverNum() ? deliveryDetailEntity.getTimeDeliverNum() : BigDecimal.ZERO);
            }
            Integer orderDeliverState = DeliverStateEnum.\u90e8\u5206\u9001\u8d27.getCode();
            int unFlag = 0;
            int fullFlag = 0;
            for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
                orderDetailEntity.setDeliverNum(ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeSub((BigDecimal)orderDetailEntity.getDeliverNum(), (BigDecimal)((BigDecimal)deliverMap.get(orderDetailEntity.getId()))), (BigDecimal)((BigDecimal)checkMap.get(orderDetailEntity.getId()))));
                orderDetailEntity.setUnDeliverNum(ComputeUtil.safeSub((BigDecimal)orderDetailEntity.getOrderNum(), (BigDecimal)orderDetailEntity.getDeliverNum()));
                if (BigDecimal.ZERO.compareTo(orderDetailEntity.getDeliverNum()) == 0) {
                    ++unFlag;
                }
                if (orderDetailEntity.getOrderNum().compareTo(orderDetailEntity.getDeliverNum()) > 0) continue;
                ++fullFlag;
            }
            if (unFlag > 0 && unFlag == orderEntity.getOrderDetailList().size()) {
                orderDeliverState = DeliverStateEnum.\u5f85\u9001\u8d27.getCode();
            }
            if (fullFlag > 0 && fullFlag == orderEntity.getOrderDetailList().size()) {
                orderDeliverState = DeliverStateEnum.\u5168\u90e8\u9001\u8d27.getCode();
            }
            orderEntity.setDeliverState(orderDeliverState);
            this.orderService.saveOrUpdate((Object)orderEntity, false);
        }
        return (DeliveryVO)BeanMapper.map((Object)((Object)deliveryEntity), DeliveryVO.class);
    }

    @Override
    public DeliveryVO queryInitDelivery(OrderVO orderVO) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(orderVO.getId()));
        List detailIdList = orderVO.getOrderDetailList().stream().map(BaseVO::getId).collect(Collectors.toList());
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)orderEntity), DeliveryVO.class);
        vo.setOrderFlag(Integer.valueOf(0));
        vo.setOrderId(orderEntity.getId());
        vo.setOrderBillCode(orderEntity.getBillCode());
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setCheckState(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        vo.setDeliverLinkTelephone(mobilePhone);
        ArrayList<DeliveryDetailVO> list = new ArrayList<DeliveryDetailVO>();
        for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
            if (!detailIdList.contains(orderDetailEntity.getId())) continue;
            DeliveryDetailVO detailVO = (DeliveryDetailVO)BeanMapper.map((Object)((Object)orderDetailEntity), DeliveryDetailVO.class);
            detailVO.setOrderId(orderDetailEntity.getOrderId());
            detailVO.setOrderDetailId(orderDetailEntity.getId());
            detailVO.setCheckNum(BigDecimal.ZERO);
            detailVO.setUnDeliverNum(orderDetailEntity.getUnDeliverNum());
            detailVO.setTimeDeliverNum(detailVO.getUnDeliverNum());
            detailVO.setId(Long.valueOf(IdWorker.getId()));
            list.add(detailVO);
        }
        vo.setDeliveryDetailList(list);
        return vo;
    }

    @Override
    public CheckVO queryDetailToCheck(Long id) {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)deliveryEntity), CheckVO.class);
        vo.setDeliveryId(deliveryEntity.getId());
        vo.setDeliveryBillCode(deliveryEntity.getBillCode());
        vo.setDeliveryType(Integer.valueOf(1));
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setSourceType("2");
        vo.setChangState("free");
        List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        List deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getTimeDeliverNum().compareTo(null == s.getCheckNum() ? BigDecimal.ZERO : s.getCheckNum()) == 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)) {
            ArrayList<CheckDetailVO> checkDetailVOS = new ArrayList<CheckDetailVO>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                CheckDetailVO checkDetailVO = (CheckDetailVO)BeanMapper.map((Object)((Object)deliveryDetailEntity), CheckDetailVO.class);
                checkDetailVO.setRowState("add");
                checkDetailVO.setBillSourceType(Integer.valueOf(1));
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(checkDetailVO.getId());
                if (null != deliveryDetailEntity.getCheckNum()) {
                    checkDetailVO.setCheckNum(ComputeUtil.safeSub((BigDecimal)deliveryDetailEntity.getTimeDeliverNum(), (BigDecimal)deliveryDetailEntity.getCheckNum()));
                } else {
                    checkDetailVO.setCheckNum(deliveryDetailEntity.getTimeDeliverNum());
                }
                checkDetailVO.setDetailCheckPrice(deliveryDetailEntity.getPrice());
                checkDetailVO.setDetailCheckTaxPrice(deliveryDetailEntity.getDetailTaxPrice());
                checkDetailVOS.add(checkDetailVO);
            }
            vo.setCheckDetailList(checkDetailVOS);
        }
        return vo;
    }

    @Override
    public Map<Long, BigDecimal> sumDeliveredGroupByDetailId(Long orderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter("eq", (Object)orderId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List deliveryList = super.queryList(queryParam);
        Map<Long, Integer> deliveryMap = deliveryList.stream().collect(Collectors.toMap(BaseEntity::getId, DeliveryEntity::getOrderFlag));
        this.logger.info("\u5df2\u9001\u8d27\u7684\u9001\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)deliveryList));
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)deliveryList)) {
            ArrayList<Long> deliveryIdList = new ArrayList<Long>();
            for (DeliveryEntity entity : deliveryList) {
                deliveryIdList.add(entity.getId());
            }
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("deliveryId", new Parameter("in", deliveryIdList));
            List deliveryDetailList = this.deliveryDetailService.queryList(detailParam);
            for (DeliveryDetailEntity detail : deliveryDetailList) {
                Long orderDetailId = detail.getOrderDetailId();
                if (map.containsKey(orderDetailId)) {
                    BigDecimal sum = ComputeUtil.safeAdd((BigDecimal)(deliveryMap.get(detail.getDeliveryId()) == 1 ? detail.getCheckNum() : detail.getTimeDeliverNum()), (BigDecimal)((BigDecimal)map.get(orderDetailId)));
                    map.put(orderDetailId, sum);
                    continue;
                }
                map.put(orderDetailId, deliveryMap.get(detail.getDeliveryId()) == 1 ? detail.getCheckNum() : detail.getTimeDeliverNum());
            }
        }
        return map;
    }
}

