/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractPaymentResultVO;
import com.ejianc.business.promaterial.contract.vo.ContractTaxVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"contract"})
@Api(value="\u4e3b\u5408\u540c\u5b9e\u4f53", tags={"\u4e3b\u5408\u540c\u5b9e\u4f53"})
public class ContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractService service;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IInvoiceReceiveRegistService invoiceReceiveRegistService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return this.service.saveOrUpdate(saveorUpdateVO, authority, false);
    }

    @ApiOperation(value="\u6846\u67b6\u534f\u8bae\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdateFrame"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateFrame(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        return this.service.saveOrUpdateFrame(saveorUpdateVO);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement, HttpServletRequest req) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        String authority = req.getHeader("authority");
        ContractVO vo = this.service.saveOrUpdateSupplement(supplement, authority, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @ApiOperation(value="\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\u53d1\u7968\uff0c\u5df2\u4ed8\u91d1\u989d")
    @RequestMapping(value={"/queryDetailById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractTaxVO> queryDetailById(@RequestParam Long id) {
        ContractTaxVO resVo = new ContractTaxVO();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(InvoiceReceiveRegistEntity::getContractId, (Object)id);
        List list = this.invoiceReceiveRegistService.list((Wrapper)lambda);
        BigDecimal contractInvoiceTaxMny = BigDecimal.ZERO;
        BigDecimal contractInvoiceMny = BigDecimal.ZERO;
        BigDecimal contractPayMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractInvoiceTaxMny = list.stream().filter(e -> null != e.getCurrentReceiveMnyTax()).map(InvoiceReceiveRegistEntity::getCurrentReceiveMnyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            contractInvoiceMny = list.stream().filter(e -> null != e.getCurrentReceiveMny()).map(InvoiceReceiveRegistEntity::getCurrentReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        resVo.setContractInvoiceMny(contractInvoiceMny);
        resVo.setContractInvoiceTaxMny(contractInvoiceTaxMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u624b\u673a\u53f7")
    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        this.service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        param.getParams().put("frame_flag", new Parameter("eq", (Object)0));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.queryContractList(param));
    }

    @RequestMapping(value={"/pageFrameList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageFrameList(@RequestBody QueryParam param) {
        param.getParams().put("frame_flag", new Parameter("eq", (Object)1));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.queryContractList(param));
    }

    @RequestMapping(value={"/pageGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageGFList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        CommonResponse commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.putAll(param.getOrderMap());
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/changeState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ContractVO contractVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)contractVO.getId());
        updateWrapper.set(ContractEntity::getPerformanceStatus, (Object)contractVO.getPerformanceStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    private JSONObject queryContractList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.putAll(param.getOrderMap());
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return page;
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("frame_flag", new Parameter("eq", (Object)0));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("proMaterialContract-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelFrameExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelFrameExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("frame_flag", new Parameter("eq", (Object)1));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("frameContract-export.xlsx", beans, response);
    }

    private Map<String, Object> commonExcelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, ContractVO.class);
            voList.forEach(c -> {
                if (StringUtils.isBlank((String)c.getPerformanceStatus())) {
                    c.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                } else {
                    c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                }
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        return beans;
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ContractDetail-import.xlsx", (String)"\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ContractDetailVO> successList = new ArrayList<ContractDetailVO>();
        ArrayList<ContractDetailVO> errorList = new ArrayList<ContractDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList materialCodeList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                materialCodeList.add(datas.get(0));
            }
            CommonResponse materialRes = this.materialApi.queryMaterialListByCodes(materialCodeList);
            if (!materialRes.isSuccess()) {
                return CommonResponse.error((String)materialRes.getMsg());
            }
            map = ((List)materialRes.getData()).stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ContractDetailVO detailVO = new ContractDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String materialTypeCode = (String)datas.get(0);
                try {
                    if (ObjectUtils.isEmpty((Object)map.get(materialTypeCode))) {
                        throw new Exception("\u7cfb\u7edf\u6863\u6848\u4e2d\u672a\u80fd\u5339\u914d\u5230\u6b64\u7f16\u7801\uff01");
                    }
                    detailVO.setMaterialTypeCode(materialTypeCode);
                    detailVO.setMaterialTypeId(((MaterialCategoryVO)map.get(materialTypeCode)).getId());
                    detailVO.setMaterialTypeName(((MaterialCategoryVO)map.get(materialTypeCode)).getName());
                }
                catch (Exception e) {
                    detailVO.setErrorCode(materialTypeCode);
                    detailVO.setErrorMsg("\u7cfb\u7edf\u6863\u6848\u4e2d\u672a\u80fd\u5339\u914d\u5230\u6b64\u7f16\u7801\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setMaterialName((String)datas.get(1));
                detailVO.setSpec((String)datas.get(2));
                detailVO.setSpecif((String)datas.get(3));
                detailVO.setUnitName((String)datas.get(4));
                detailVO.setBrand((String)datas.get(5));
                try {
                    detailVO.setNum(BigDecimal.valueOf(Double.parseDouble((String)datas.get(6))));
                }
                catch (Exception e) {
                    detailVO.setErrorCode(materialTypeCode);
                    detailVO.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    detailVO.setDetailTaxPrice(BigDecimal.valueOf(Double.parseDouble((String)datas.get(7))));
                }
                catch (Exception e) {
                    detailVO.setErrorCode(materialTypeCode);
                    detailVO.setErrorMsg("\u7efc\u5408\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    detailVO.setDetailTaxRate(BigDecimal.valueOf(Double.parseDouble((String)datas.get(8))));
                }
                catch (Exception e) {
                    detailVO.setErrorCode(materialTypeCode);
                    detailVO.setErrorMsg("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (ObjectUtils.isNotEmpty(datas.get(9))) {
                    detailVO.setMaterialTaxPrice(BigDecimal.valueOf(Double.parseDouble((String)datas.get(9))));
                }
                if (ObjectUtils.isNotEmpty(datas.get(10))) {
                    detailVO.setAzTaxPrice(BigDecimal.valueOf(Double.parseDouble((String)datas.get(10))));
                }
                if (ObjectUtils.isNotEmpty(datas.get(11))) {
                    detailVO.setOtherTaxPrice(BigDecimal.valueOf(Double.parseDouble((String)datas.get(11))));
                }
                detailVO.setPlace((String)datas.get(12));
                detailVO.setMemo((String)datas.get(13));
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        IPage<ContractEntity> page = this.queryContractListByRef(param, condition);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private IPage<ContractEntity> queryContractListByRef(QueryParam param, String condition) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("performanceStatus", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        param.getParams().put("frame_flag", new Parameter("eq", (Object)0));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && JSONObject.parseObject((String)condition).containsKey((Object)"gfSupplierId")) {
            CommonResponse commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
            if (!commonResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        } else {
            param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"frameFlag")) {
                param.getParams().put("frame_flag", new Parameter("eq", (Object)1));
            }
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)Long.valueOf(String.valueOf(_con.get((Object)"projectId")))));
            }
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        return this.service.queryPage(param, false);
    }

    @RequestMapping(value={"/queryPaymentApplyList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractPaymentResultVO> query(Long id) {
        ContractPaymentResultVO vo = this.service.queryPaymentApplyList(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

