/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.promaterial.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.bean.PayContractSettleEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.finance.service.IPayContractSettleService;
import com.ejianc.business.promaterial.finance.service.IPayRecordService;
import com.ejianc.business.promaterial.utils.NumberToCN;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payContract")
public class PayContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayContractService service;
    @Autowired
    private IPayContractSettleService settleService;
    @Autowired
    private IPayRecordService recordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = (PayContractEntity)((Object)this.service.selectById(billId));
        this.service.writeBackSumApplyMny(billId, entity, true);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(PayContractEntity::getApproveTime, (Object)new Date());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = (PayContractEntity)((Object)this.service.selectById(billId));
        if (!this.validateApproveTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5728\u672c\u7ec4\u7ec7\u4e0b\u975e\u6700\u65b0\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5728\u672c\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = (PayContractEntity)((Object)this.service.selectById(billId));
        this.service.writeBackSumApplyMny(billId, entity, false);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(PayContractSettleEntity::getPayapplyId, (Object)billId);
        wrapper.set(PayContractSettleEntity::getSumPayMny, (Object)BigDecimal.ZERO);
        if (Optional.ofNullable(entity.getCloseFlag()).orElse(false).booleanValue()) {
            wrapper.setSql("body_apply_mny = body_apply_mny_before_close");
            entity.setApplyMny(entity.getApplyMnyBeforeClose());
            entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));
            entity.setApplyMnyBeforeClose(null);
            entity.setCloseFlag(Boolean.FALSE);
            entity.setCloseState(null);
            entity.setCloseTime(null);
            entity.setCloseUser(null);
        }
        this.settleService.update((Wrapper)wrapper);
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);
        entity.setApproveTime(null);
        entity.setConfirmTime(null);
        this.service.saveOrUpdate((Object)entity);
        this.recordService.remove((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private boolean validateEffective(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateApproveTime(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.gt((Object)"apply_time", (Object)entity.getApplyTime());
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }
}

