/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.enums.ConstantTypeEnum;
import com.ejianc.business.promaterial.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.bean.PayContractSettleEntity;
import com.ejianc.business.promaterial.finance.bean.PayInvoiceEntity;
import com.ejianc.business.promaterial.finance.bean.PayRecordEntity;
import com.ejianc.business.promaterial.finance.mapper.PayContractMapper;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.finance.service.IPayContractSettleService;
import com.ejianc.business.promaterial.finance.service.IPayInvoiceService;
import com.ejianc.business.promaterial.finance.service.IPayRecordService;
import com.ejianc.business.promaterial.finance.vo.PayApplyPubVO;
import com.ejianc.business.promaterial.finance.vo.PayContractSettleVO;
import com.ejianc.business.promaterial.finance.vo.PayContractVO;
import com.ejianc.business.promaterial.finance.vo.PayInvoiceVO;
import com.ejianc.business.promaterial.finance.vo.PayRecordVO;
import com.ejianc.business.promaterial.finance.vo.SumPayMnyVO;
import com.ejianc.business.promaterial.finance.vo.TotalColumnVO;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.utils.MathUtil;
import com.ejianc.business.promaterial.utils.NumberToCN;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="payContractService")
public class PayContractServiceImpl
extends BaseServiceImpl<PayContractMapper, PayContractEntity>
implements IPayContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IPayContractSettleService settleService;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public PayContractVO insertOrUpdate(PayContractVO vo) {
        PayContractEntity entity = (PayContractEntity)((Object)BeanMapper.map((Object)vo, PayContractEntity.class));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getContractId, (Object)entity.getContractId());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        lambda.orderByDesc(PayContractEntity::getApplyTime);
        List entityList = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u652f\u4ed8\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        List voList = vo.getInvoiceVOList();
        this.invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);
        super.saveOrUpdateNoES((Object)entity);
        Long id = entity.getId();
        List invoiceVOList = this.updateInvoiceVOS(vo, id);
        List<PayContractSettleVO> settleVOList = this.updateSettleVOS(vo, id);
        if (entity.getId() != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)entity.getId());
            invoiceVOList = this.invoiceService.list((Wrapper)wrapper);
        }
        PayContractEntity payContractEntity = (PayContractEntity)((Object)super.getById((Serializable)id));
        PayContractVO backVO = (PayContractVO)BeanMapper.map((Object)((Object)payContractEntity), PayContractVO.class);
        backVO.setInvoiceVOList(BeanMapper.mapList(invoiceVOList, PayInvoiceVO.class));
        backVO.setSettleVOList(settleVOList);
        return backVO;
    }

    private List<PayContractSettleVO> updateSettleVOS(PayContractVO vo, Long id) {
        List vos = vo.getSettleVOList();
        if (vos != null && !vos.isEmpty()) {
            for (PayContractSettleVO settleVO : vos) {
                settleVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)vos, PayContractSettleEntity.class);
            this.settleService.saveOrUpdateBatch(entityList, entityList.size(), false);
            vos = BeanMapper.mapList((Iterable)entityList, PayContractSettleVO.class);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        this.settleService.remove((Wrapper)wrapper, false);
        return vos;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PayContractVO vo, Long id) {
        List voList = vo.getInvoiceVOList();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                invoiceVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayInvoiceVO.class);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        this.invoiceService.remove((Wrapper)wrapper, false);
        return voList;
    }

    @Override
    public PayContractVO queryDetail(Long id) {
        PayContractEntity entity = (PayContractEntity)((Object)this.selectById(id));
        PayContractVO vo = (PayContractVO)BeanMapper.map((Object)((Object)entity), PayContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, PayInvoiceVO.class));
        List settleEntityList = this.settleService.queryList(queryParam, false);
        vo.setSettleVOList(BeanMapper.mapList((Iterable)settleEntityList, PayContractSettleVO.class));
        return vo;
    }

    @Override
    public List<PayContractVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PayContractVO vo = (PayContractVO)resVos.get(i);
                vo.setFeeTypeName(ConstantTypeEnum.getEnumByCode(vo.getFeeType()).getName());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.removeByIds(ids, false);
            this.invoiceService.updateInvoiceUsedMnyByDel(ids);
            this.invoiceService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            this.settleService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(pages, wrapper, flag);
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            vo.setApplyHasPenaltyMny(ComputeUtil.safeAdd((BigDecimal)vo.getApplyMny(), (BigDecimal)vo.getCurPenaltyMoney()));
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public SumPayMnyVO getSumPayMny(Long contractId, Long orgId, Boolean applyMnyContainFree) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        QueryWrapper queryWrapper = new QueryWrapper();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SUM( IF ( pay_status = 2 AND bill_state IN ( 1, 3 ) and org_id = '" + orgId + "', pay_mny, 0 ) ) AS sumPayMny, ");
        selectSql.append(" SUM( IF ( fee_type = 1 , apply_mny, 0 ) ) AS sumPrePayMny,");
        if (applyMnyContainFree != null && applyMnyContainFree.booleanValue()) {
            selectSql.append(" SUM( IF(org_id = '" + orgId + "',IFNULL( apply_mny, 0 ),0) + IFNULL( cur_penalty_money, 0 ) ) AS sumApplyMny ");
        } else {
            selectSql.append(" SUM( IF ( bill_state IN ( 1, 3 ) and org_id = '" + orgId + "' , IFNULL( apply_mny, 0 ) + IFNULL( cur_penalty_money, 0 ), 0 ) ) AS sumApplyMny ");
        }
        queryWrapper.select(new String[]{selectSql.toString()});
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        Map map = this.getMap((Wrapper)queryWrapper);
        SumPayMnyVO vo = new SumPayMnyVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        if (MapUtils.isEmpty((Map)map)) {
            vo.setSumApplyMny(BigDecimal.ZERO);
            vo.setSumPrePayMny(BigDecimal.ZERO);
            vo.setSumPayMny(BigDecimal.ZERO);
        } else {
            vo.setSumApplyMny(ComputeUtil.toBigDecimal(map.get("sumApplyMny")));
            vo.setSumPrePayMny(ComputeUtil.toBigDecimal(map.get("sumPrePayMny")));
            vo.setSumPayMny(ComputeUtil.toBigDecimal(map.get("sumPayMny")));
        }
        BigDecimal sumPayLaborMny = BigDecimal.ZERO;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PayRecordEntity::getContractId, (Object)contractId);
        wrapper.eq(PayRecordEntity::getOrgId, (Object)orgId);
        List list = this.payRecordService.list((Wrapper)wrapper);
        vo.setSumPayLaborMny(sumPayLaborMny);
        return vo;
    }

    @Override
    public JSONObject queryPendingPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> feeTypeIds = new ArrayList();
        if (null != param.getParams().get("feeTypeId")) {
            String feeTypeId = ((Parameter)param.getParams().get("feeTypeId")).getValue().toString();
            feeTypeIds = Arrays.asList(feeTypeId.split(","));
            param.getParams().remove("feeTypeId");
            if (null == param.getParams().get("feeType") || ((Parameter)param.getParams().get("feeType")).getValue().toString().contains("\u8d39\u7528\u62a5\u9500")) {
                param.getParams().put("feeType", new Parameter("in", (Object)"\u8d39\u7528\u62a5\u9500"));
            } else {
                param.getParams().put("feeType", new Parameter("in", (Object)"1"));
            }
        }
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.and(x -> (QueryWrapper)x.last("(pay_status = 1 or (IFNULL(pay_mny,0) + IFNULL(this_deduct_mny,0)) < apply_mny) AND IFNULL(close_flag,0) = 0"));
        List<PayApplyPubVO> list = ((PayContractMapper)this.baseMapper).queryPendingList(pages, wrapper, feeTypeIds);
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(ComputeUtil.safeSub((BigDecimal)vo.getApplyMny(), (BigDecimal[])new BigDecimal[]{vo.getPayMny(), vo.getThisDeductMny()}));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public JSONObject queryAllList(QueryParam param, String type) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> feeTypeIds = new ArrayList();
        if (null != param.getParams().get("feeTypeId")) {
            String feeTypeId = ((Parameter)param.getParams().get("feeTypeId")).getValue().toString();
            feeTypeIds = Arrays.asList(feeTypeId.split(","));
            param.getParams().remove("feeTypeId");
            if (null == param.getParams().get("feeType") || ((Parameter)param.getParams().get("feeType")).getValue().toString().contains("\u8d39\u7528\u62a5\u9500")) {
                param.getParams().put("feeType", new Parameter("in", (Object)"\u8d39\u7528\u62a5\u9500"));
            } else {
                param.getParams().put("feeType", new Parameter("in", (Object)"1"));
            }
        }
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayApplyPubVO> list = "detail".equals(type) ? ((PayContractMapper)this.baseMapper).queryALLDetailList(pages, wrapper, feeTypeIds) : ((PayContractMapper)this.baseMapper).queryPendingList(pages, wrapper, feeTypeIds);
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(ComputeUtil.safeSub((BigDecimal)vo.getApplyMny(), (BigDecimal[])new BigDecimal[]{vo.getPayMny(), vo.getThisDeductMny()}));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public List<PayApplyPubVO> queryExportPendingList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List records = (List)this.queryPendingPageJson(param, false).get((Object)"records");
        return records;
    }

    @Override
    public String batchConfirm(List<PayApplyPubVO> vos) {
        for (PayApplyPubVO vo : vos) {
            PayRecordVO record = new PayRecordVO();
            PayContractVO data = this.queryDetail(vo.getId());
            record.setBillCode(data.getBillCode());
            record.setPayapplyId(data.getId());
            record.setContractId(data.getContractId());
            record.setContractName(data.getContractName());
            record.setProjectId(data.getProjectId());
            record.setProjectName(data.getProjectName());
            record.setOrgId(data.getOrgId());
            record.setOrgName(data.getOrgName());
            record.setApplyUserId(data.getApplyUserId());
            record.setApplyUserName(data.getApplyUserName());
            record.setApplyTime(data.getApplyTime());
            record.setApplyMny(data.getApplyMny());
            BigDecimal surplusPayMny = MathUtil.safeSub(data.getApplyMny(), data.getPayMny());
            record.setThisPayMny(surplusPayMny);
            record.setReceiveUnitId(data.getReceiveUnitId());
            record.setReceiveUnitName(data.getReceiveUnitName());
            record.setApplyType("\u5408\u540c\u4ed8\u6b3e");
            record.setFeeType(data.getFeeType());
            record.setEmployeeId(vo.getEmployeeId());
            record.setEmployeeName(vo.getEmployeeName());
            record.setConfirmTime(vo.getConfirmTime());
            record.setAccountId(vo.getAccountId());
            record.setAccountName(vo.getAccountName());
            record.setAccountNum(vo.getAccountNum());
            record.setAccountBank(vo.getAccountBank());
            record.setPayWay(vo.getPayWay());
            record.setPayWayName(vo.getPayWayName());
            record.setMemo(vo.getMemo());
            this.payRecordService.insertOrUpdate(record, true);
        }
        return "\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01";
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((String)param.getBillTypeId()) && this.viewSelf(param.getBillTypeId()).booleanValue() && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getPendingTotalColumnInfo(QueryParam param, boolean isEs, String type) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("approveTime", "desc");
        List<Object> feeTypeIds = new ArrayList();
        if (null != param.getParams().get("feeTypeId")) {
            String feeTypeId = ((Parameter)param.getParams().get("feeTypeId")).getValue().toString();
            feeTypeIds = Arrays.asList(feeTypeId.split(","));
            param.getParams().remove("feeTypeId");
            if (null == param.getParams().get("feeType") || ((Parameter)param.getParams().get("feeType")).getValue().toString().contains("\u8d39\u7528\u62a5\u9500")) {
                param.getParams().put("feeType", new Parameter("in", (Object)"\u8d39\u7528\u62a5\u9500"));
            } else {
                param.getParams().put("feeType", new Parameter("in", (Object)"1"));
            }
        }
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        if ("pending".equals(type)) {
            wrapper.and(x -> (QueryWrapper)x.last("pay_status = 1 or pay_mny < apply_mny"));
        }
        List<PayApplyPubVO> list = ((PayContractMapper)this.baseMapper).queryPendingList(null, wrapper, feeTypeIds);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayApplyPubVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayApplyPubVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public void closePayment(Long id) {
        Assert.notNull((Object)id, (String)"\u4ed8\u6b3e\u7533\u8bf7id\u4e0d\u80fd\u4e3a\u7a7a");
        PayContractEntity entity = (PayContractEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u4ed8\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        entity.setApplyMnyBeforeClose(entity.getApplyMny());
        entity.setApplyMny(entity.getPayMny());
        entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PayContractSettleEntity::getPayapplyId, (Object)id);
        List list = this.settleService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(settle -> {
                settle.setBodyApplyMnyBeforeClose(settle.getBodyApplyMny());
                settle.setBodyApplyMny(settle.getSumPayMny());
            });
            this.settleService.updateBatchById(list);
        }
        entity.setCloseFlag(Boolean.TRUE);
        entity.setCloseState("\u5df2\u5173\u95ed");
        entity.setCloseTime(new Date());
        entity.setCloseUser(this.sessionManager.getUserContext().getUserName());
        super.updateById((Object)entity);
        this.writeBackSumApplyMny(id, entity, false);
    }

    @Override
    public boolean writeBackSumApplyMny(Long billId, PayContractEntity entity, boolean flag) {
        List settleEntityList = this.settleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        HashMap<Long, BigDecimal> settleApplyMnyMap = new HashMap<Long, BigDecimal>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub(settleEntity.getBodyApplyMny(), settleEntity.getBodyApplyMnyBeforeClose());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
            SettlementEntity settlementEntity = (SettlementEntity)((Object)this.settlementService.selectById(settleEntity.getSettleId()));
            if (settlementEntity == null) {
                throw new BusinessException("\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355\uff01");
            }
            BigDecimal currentSettlementAmountTax = settlementEntity.getSettlementTaxMny();
            BigDecimal alreadyApplyAmount = settlementEntity.getCurrentApplyAmount();
            if (alreadyApplyAmount == null) {
                alreadyApplyAmount = new BigDecimal("0.00");
            }
            alreadyApplyAmount = alreadyApplyAmount.add(applyMny).setScale(2, 4);
            settlementEntity.setCurrentApplyAmount(alreadyApplyAmount);
            if (currentSettlementAmountTax == null) {
                currentSettlementAmountTax = new BigDecimal("0.00");
            }
            BigDecimal remainCanApplyAmount = currentSettlementAmountTax.subtract(alreadyApplyAmount).setScale(2, 4);
            settlementEntity.setRemainCanApplyAmount(remainCanApplyAmount);
            this.settlementService.saveOrUpdate((Object)settlementEntity, false);
        }
        return true;
    }

    @Override
    public Map<Long, BigDecimal> getApplyMnyHasFree(List<Long> settleIds, Long id) {
        List<PayContractSettleVO> settleVOList = ((PayContractMapper)this.baseMapper).getApplyMnyHasFree(settleIds, id);
        Map<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty(settleVOList)) {
            map = settleVOList.stream().collect(Collectors.toMap(PayContractSettleVO::getSettleId, PayContractSettleVO::getSumApplyMny));
        }
        return map;
    }
}

