/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.finance.vo.PayApplyPubVO;
import com.ejianc.business.promaterial.finance.vo.PayContractSettleVO;
import com.ejianc.business.promaterial.finance.vo.PayContractVO;
import com.ejianc.business.promaterial.finance.vo.SumPayMnyVO;
import com.ejianc.business.promaterial.finance.vo.TotalColumnVO;
import com.ejianc.business.promaterial.utils.BigDecimalUtil;
import com.ejianc.business.promaterial.utils.NumberToCN;
import com.ejianc.business.promaterial.utils.ParamSearchUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payContract"})
public class PayContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayContractService contractService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryAllList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        JSONObject page = this.contractService.queryAllList(param, "main");
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelAllList(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        List records = new ArrayList();
        JSONObject jsonObject = this.contractService.queryAllList(queryParam, "main");
        if (jsonObject != null && jsonObject.get((Object)"records") != null) {
            records = (List)jsonObject.get((Object)"records");
        }
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("all-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelAllDetailList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelAllDetailList(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        List records = new ArrayList();
        JSONObject jsonObject = this.contractService.queryAllList(queryParam, "detail");
        if (jsonObject != null && jsonObject.get((Object)"records") != null) {
            records = (List)jsonObject.get((Object)"records");
        }
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("all-detail-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/handleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> handleData() {
        long start = System.currentTimeMillis();
        QueryParam param = new QueryParam();
        List payContractEntities = this.contractService.queryList(param);
        for (PayContractEntity payContractEntity : payContractEntities) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)payContractEntity.getContractId()));
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)payContractEntity.getOrgId()));
            queryParam.getParams().put("applyTime", new Parameter("lt", (Object)payContractEntity.getApplyTime()));
            List entities = this.contractService.queryList(queryParam);
            BigDecimal sumApplyMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                for (PayContractEntity pce : entities) {
                    sumApplyMny = BigDecimalUtil.safeAdd(sumApplyMny, pce.getApplyMny());
                }
                payContractEntity.setSumApplyMny(sumApplyMny);
            }
            payContractEntity.setApplyMnyCn(NumberToCN.number2CN(payContractEntity.getApplyMny()));
            BigDecimal sumApplyMnyWithThis = BigDecimalUtil.safeAdd(sumApplyMny, payContractEntity.getApplyMny());
            BigDecimal _endthisPayScaleByContract = BigDecimalUtil.safeDiv(sumApplyMnyWithThis, payContractEntity.getContractMny());
            BigDecimal endthisPayScaleByContract = BigDecimalUtil.safeMultiply(_endthisPayScaleByContract, BigDecimalUtil.ONE_HUNDRED);
            payContractEntity.setEndthisPayScaleByContract(endthisPayScaleByContract);
        }
        this.contractService.saveOrUpdateBatch(payContractEntities);
        long end = System.currentTimeMillis();
        String msg = "\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (end - start) + "ms\uff0c\u5904\u7406\u6570\u636e\uff1a" + payContractEntities.size() + "\u6761\u3002";
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayContractVO> saveOrUpdate(@RequestBody PayContractVO payContractVO) {
        List<Long> settleIds;
        List settleVOS = payContractVO.getSettleVOList();
        if (CollectionUtils.isNotEmpty((Collection)settleVOS) && CollectionUtils.isNotEmpty(settleIds = settleVOS.stream().filter(t -> !"del".equals(t.getRowState())).map(e -> e.getSettleId()).collect(Collectors.toList()))) {
            Map<Long, BigDecimal> settleApplyData = this.contractService.getApplyMnyHasFree(settleIds, payContractVO.getId());
            for (PayContractSettleVO settleVO : settleVOS) {
                BigDecimal settleTaxMny = settleVO.getSettleMny();
                BigDecimal sumApplyMny = settleApplyData.get(settleVO.getSettleId());
                BigDecimal sumApplyMnyHasThis = ComputeUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)settleVO.getBodyApplyMny());
                if (!ComputeUtil.isGreaterThan((BigDecimal)ComputeUtil.scaleTwo((BigDecimal)sumApplyMnyHasThis), (BigDecimal)ComputeUtil.scaleTwo((BigDecimal)settleTaxMny))) continue;
                throw new BusinessException("\u7ed3\u7b97\u5355\u3010\u5355\u636e\u7f16\u53f7\uff1a" + settleVO.getSettleCode() + "\u3011\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d(\u542b\u672c\u671f)\uff1a" + ComputeUtil.scaleTwo((BigDecimal)sumApplyMnyHasThis) + " \u5927\u4e8e\u7ed3\u7b97\u91d1\u989d\uff1a" + ComputeUtil.scaleTwo((BigDecimal)settleTaxMny) + " \uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01");
            }
        }
        PayContractVO backVO = this.contractService.insertOrUpdate(payContractVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayContractVO> updateInfo(@RequestBody PayContractVO vo) {
        PayContractEntity entity = (PayContractEntity)((Object)BeanMapper.map((Object)vo, PayContractEntity.class));
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(PayContractEntity::getInvoiceFlag, (Object)entity.getInvoiceFlag());
            this.contractService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> queryDetail(Long id) {
        PayContractVO backVO = this.contractService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayContract", (Object)this.contractService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        ParamSearchUtil.handleQueryParam(param);
        ArrayList<String> supState = new ArrayList<String>();
        supState.add("checking");
        supState.add("pass");
        param.getComplexParams().add(this.getPageQueryParam(supState));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        JSONObject page = this.contractService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryGFList(@RequestBody QueryParam param) {
        CommonResponse commonResponse;
        param.getOrderMap().put("createTime", "desc");
        ParamSearchUtil.handleQueryParam(param);
        CommonResponse response = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)response.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("tenant_id", new Parameter("in", (Object)systemIdList));
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getComplexParams().add(this.getGFPageQueryParam());
        JSONObject page = this.contractService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private ComplexParam getPageQueryParam(List<String> supState) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("in", Arrays.asList(1, 3)));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c3.getParams().put("changState", new Parameter("in", supState));
        c1.getComplexParams().add(c3);
        return c1;
    }

    public ComplexParam getGFPageQueryParam() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("in", Arrays.asList(1, 3)));
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        JSONObject page = this.contractService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayContractVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.contractService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        queryParam.getOrderMap().put("createTime", "desc");
        ArrayList<String> supState = new ArrayList<String>();
        supState.add("checking");
        supState.add("pass");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getComplexParams().add(this.getPageQueryParam(supState));
        List<PayContractVO> supplierVos = this.contractService.queryExportList(queryParam);
        HashMap<String, List<PayContractVO>> beans = new HashMap<String, List<PayContractVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("contract-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelApproveExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelApproveExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("approveTime", "desc");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List<PayContractVO> payContractVOList = this.contractService.queryPageJsonExport(queryParam, false);
        HashMap<String, List<PayContractVO>> beans = new HashMap<String, List<PayContractVO>>();
        beans.put("records", payContractVOList);
        ExcelExport.getInstance().export("all-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/deleteGF"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteGF(@RequestBody List<PayContractVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        PayContractVO payContractVO = vos.get(0);
        PayContractEntity payContractEntity = (PayContractEntity)((Object)this.contractService.selectById(payContractVO.getId()));
        if ("1".equals(payContractEntity.getSourceType())) {
            throw new BusinessException("\u91c7\u8d2d\u65b9\u652f\u4ed8\u7533\u8bf7\u5355\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        if (!"free".equals(payContractEntity.getChangState()) && !"returned".equals(payContractEntity.getChangState())) {
            throw new BusinessException("\u53ea\u80fd\u5220\u9664\u672a\u751f\u6548\u7684\u9a8c\u6536\u5355!");
        }
        this.contractService.deleteGF(Arrays.asList(vos.get(0).getId()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/submitGF"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> submitGF(@RequestBody PayContractVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        updateWrapper.set(PayContractEntity::getChangState, (Object)saveOrUpdateVO.getChangState());
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getReturnReason())) {
            updateWrapper.set(PayContractEntity::getReturnReason, (Object)saveOrUpdateVO.getReturnReason());
        }
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/excelGFExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelGFExport(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse commonResponse;
        CommonResponse cooperResponse = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!cooperResponse.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)cooperResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)cooperResponse.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("tenant_id", new Parameter("in", (Object)systemIdList));
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getComplexParams().add(this.getGFPageQueryParam());
        ParamSearchUtil.handleQueryParam(param);
        List<PayContractVO> supplierVos = this.contractService.queryExportList(param);
        HashMap<String, List<PayContractVO>> beans = new HashMap<String, List<PayContractVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("contract-payapply-gf-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryReceiveInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> queryReceiveInfo(Long receiveUnitId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("receiveUnitId", new Parameter("eq", (Object)receiveUnitId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.contractService.queryList(queryParam, false);
        PayContractVO backVO = !entityList.isEmpty() ? (PayContractVO)BeanMapper.map(entityList.get(0), PayContractVO.class) : new PayContractVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"getSumPayMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SumPayMnyVO> getSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="orgId", required=true) Long orgId, @RequestParam(value="applyMnyContainFree", required=false) Boolean applyMnyContainFree) {
        SumPayMnyVO vo = this.contractService.getSumPayMny(contractId, orgId, applyMnyContainFree);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryPendingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryPendingList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        JSONObject page = this.contractService.queryPendingPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelExportPending"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportPending(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        List<PayApplyPubVO> records = this.contractService.queryExportPendingList(queryParam);
        HashMap<String, List<PayApplyPubVO>> beans = new HashMap<String, List<PayApplyPubVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("pending-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/batchConfirm"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> batchConfirm(@RequestBody List<PayApplyPubVO> vos) {
        String msg = this.contractService.batchConfirm(vos);
        return CommonResponse.success((String)"\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01");
    }

    @RequestMapping(value={"getTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getTotalColumnInfoGF"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfoGF(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getTotalColumnInfo(param, true));
    }

    @RequestMapping(value={"getApproveTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getApproveTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getPendingTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getPendingTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getPendingTotalColumnInfo(param, false, "pending"));
    }

    @RequestMapping(value={"getALLTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getALLTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getPendingTotalColumnInfo(param, false, "all"));
    }

    @RequestMapping(value={"/closePayment"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Void> closePayment(@RequestParam(value="id") Long id) {
        this.contractService.closePayment(id);
        return CommonResponse.success((String)"\u4ed8\u6b3e\u5173\u95ed\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateReceiveInvoiceFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> updateReceiveInvoiceFlag(@RequestParam Long id) {
        if (id != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(PayContractEntity::getReceiveInvoiceFlag, (Object)2);
            this.contractService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }
}

