/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.finance.bean.PayContractEntity;
import com.ejianc.business.promaterial.finance.bean.PayContractSettleEntity;
import com.ejianc.business.promaterial.finance.bean.PayRecordEntity;
import com.ejianc.business.promaterial.finance.bean.PayRecordSettleEntity;
import com.ejianc.business.promaterial.finance.mapper.PayRecordMapper;
import com.ejianc.business.promaterial.finance.service.IPayContractService;
import com.ejianc.business.promaterial.finance.service.IPayContractSettleService;
import com.ejianc.business.promaterial.finance.service.IPayRecordService;
import com.ejianc.business.promaterial.finance.service.IPayRecordSettleService;
import com.ejianc.business.promaterial.finance.vo.PayRecordVO;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.utils.MathUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payRecordService")
public class PayRecordServiceImpl
extends BaseServiceImpl<PayRecordMapper, PayRecordEntity>
implements IPayRecordService {
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPayContractSettleService contractSettleService;
    @Autowired
    private IPayRecordSettleService settleService;
    @Autowired
    private ISettlementService settlementService;

    @Override
    public PayRecordVO insertOrUpdate(PayRecordVO vo, boolean isBatchPay) {
        PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
        BigDecimal msgPayMny = BigDecimal.ZERO;
        PayContractEntity contract = (PayContractEntity)((Object)this.contractService.selectById(entity.getPayapplyId()));
        entity.setBillCode(contract.getBillCode());
        entity.setContractId(contract.getContractId());
        entity.setContractName(contract.getContractName());
        entity.setProjectId(contract.getProjectId());
        entity.setProjectName(contract.getProjectName());
        entity.setOrgId(contract.getOrgId());
        entity.setOrgName(contract.getOrgName());
        entity.setApplyUserId(contract.getApplyUserId());
        entity.setApplyUserName(contract.getApplyUserName());
        entity.setApplyTime(contract.getApplyTime());
        entity.setApplyMny(contract.getApplyMny());
        entity.setReceiveUnitId(contract.getReceiveUnitId());
        entity.setReceiveUnitName(contract.getReceiveUnitName());
        entity.setFeeType(contract.getFeeType());
        entity.setExplanation(contract.getPayReason());
        super.saveOrUpdate((Object)entity);
        contract.setPayStatus(2);
        contract.setConfirmTime(entity.getConfirmTime());
        contract.setEmployeeId(entity.getEmployeeId());
        contract.setEmployeeName(entity.getEmployeeName());
        contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));
        msgPayMny = contract.getPayMny();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)entity.getPayapplyId()));
        queryParam.getOrderMap().put("createTime", "desc");
        QueryWrapper wrapper = PayRecordServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.last("limit 1");
        PayRecordEntity payRecordEntity = (PayRecordEntity)((Object)super.getOne((Wrapper)wrapper));
        if (payRecordEntity != null) {
            contract.setPayAccountName(payRecordEntity.getAccountName());
            contract.setPayAccountNum(payRecordEntity.getAccountNum());
            contract.setPayAccountBank(payRecordEntity.getAccountBank());
        }
        this.contractService.saveOrUpdate((Object)contract);
        List<PayRecordSettleEntity> settleList = this.calculateSettlePayMny(entity);
        PayRecordVO payRecordVO = (PayRecordVO)BeanMapper.map((Object)((Object)entity), PayRecordVO.class);
        payRecordVO.setMsgPayMny(msgPayMny);
        payRecordVO.setMsgBillCode(entity.getBillCode());
        payRecordVO.setMsgId(entity.getId());
        String[] receivers = String.valueOf(payRecordVO.getApplyUserId()).split(",");
        return payRecordVO;
    }

    private List<PayRecordSettleEntity> calculateSettlePayMny(PayRecordEntity entity) {
        BigDecimal pendPayMny = entity.getThisPayMny();
        List contractSettleList = this.contractSettleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)entity.getPayapplyId()));
        ArrayList<PayRecordSettleEntity> settleLsit = new ArrayList<PayRecordSettleEntity>();
        for (PayContractSettleEntity contractSettle : contractSettleList) {
            BigDecimal surplusPayMny = MathUtil.safeSub(contractSettle.getBodyApplyMny(), contractSettle.getSumPayMny());
            if (MathUtil.safeCompareTo(pendPayMny, BigDecimal.ZERO) <= 0 || MathUtil.safeCompareTo(surplusPayMny, BigDecimal.ZERO) <= 0) continue;
            PayRecordSettleEntity settle = new PayRecordSettleEntity();
            settle.setRecordId(entity.getId());
            settle.setPayapplyId(entity.getPayapplyId());
            settle.setSettleId(contractSettle.getSettleId());
            settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
            if (MathUtil.safeCompareTo(pendPayMny, surplusPayMny) > 0) {
                settle.setSettlePayMny(surplusPayMny);
            } else {
                settle.setSettlePayMny(pendPayMny);
            }
            pendPayMny = MathUtil.safeSub(pendPayMny, settle.getSettlePayMny());
            contractSettle.setSumPayMny(MathUtil.safeAdd(contractSettle.getSumPayMny(), settle.getSettlePayMny()));
            settleLsit.add(settle);
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            this.settleService.saveOrUpdateBatch(settleLsit);
            this.contractSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }

    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
        entity.setThisPayMny(entity.getThisPayMny().negate());
        PayContractEntity contract = (PayContractEntity)((Object)this.contractService.selectById(entity.getPayapplyId()));
        entity.setBillCode(contract.getBillCode());
        entity.setContractId(contract.getContractId());
        entity.setContractName(contract.getContractName());
        entity.setProjectId(contract.getProjectId());
        entity.setProjectName(contract.getProjectName());
        entity.setOrgId(contract.getOrgId());
        entity.setOrgName(contract.getOrgName());
        entity.setApplyUserId(contract.getApplyUserId());
        entity.setApplyUserName(contract.getApplyUserName());
        entity.setApplyTime(contract.getApplyTime());
        entity.setApplyMny(contract.getApplyMny());
        entity.setReceiveUnitId(contract.getReceiveUnitId());
        entity.setReceiveUnitName(contract.getReceiveUnitName());
        entity.setFeeType(contract.getFeeType());
        entity.setExplanation(contract.getPayReason());
        super.saveOrUpdate((Object)entity);
        contract.setPayStatus(2);
        contract.setConfirmTime(entity.getConfirmTime());
        contract.setEmployeeId(entity.getEmployeeId());
        contract.setEmployeeName(entity.getEmployeeName());
        contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));
        this.contractService.saveOrUpdate((Object)contract);
        List<PayRecordSettleEntity> settleList = this.calcSettlePayMnyAfterReturnPayment(entity);
        if (vo.getClosed().booleanValue()) {
            this.contractService.closePayment(vo.getPayapplyId());
        }
        PayRecordVO payRecordVO = (PayRecordVO)BeanMapper.map((Object)((Object)entity), PayRecordVO.class);
        return payRecordVO;
    }

    private List<PayRecordSettleEntity> calcSettlePayMnyAfterReturnPayment(PayRecordEntity entity) {
        ArrayList<PayRecordSettleEntity> settleLsit = new ArrayList<PayRecordSettleEntity>();
        BigDecimal pendPayMny = entity.getThisPayMny().negate();
        List contractSettleList = this.contractSettleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PayContractSettleEntity::getPayapplyId, (Object)entity.getPayapplyId())).orderByDesc(BaseEntity::getCreateTime));
        for (PayContractSettleEntity contractSettle : contractSettleList) {
            if (MathUtil.safeCompareTo(pendPayMny, BigDecimal.ZERO) <= 0) continue;
            PayRecordSettleEntity settle = new PayRecordSettleEntity();
            settle.setRecordId(entity.getId());
            settle.setPayapplyId(entity.getPayapplyId());
            settle.setSettleId(contractSettle.getSettleId());
            settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
            if (MathUtil.safeCompareTo(contractSettle.getSumPayMny(), pendPayMny) >= 0) {
                settle.setReturnPayMny(pendPayMny);
                contractSettle.setSumPayMny(MathUtil.safeSub(contractSettle.getSumPayMny(), pendPayMny));
                pendPayMny = BigDecimal.ZERO;
            } else {
                settle.setReturnPayMny(contractSettle.getSumPayMny());
                pendPayMny = MathUtil.safeSub(pendPayMny, contractSettle.getSumPayMny());
                contractSettle.setSumPayMny(BigDecimal.ZERO);
            }
            settle.setSettlePayMny(contractSettle.getSumPayMny());
            settleLsit.add(settle);
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            this.settleService.saveOrUpdateBatch(settleLsit);
            this.contractSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }
}

