/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.enums.CloseFlagEnum;
import com.ejianc.business.promaterial.delivery.enums.DeliverCheckStateEnum;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.bean.OrderProductDetailEntity;
import com.ejianc.business.promaterial.order.enums.DeliverStateEnum;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="delivery")
public class DeliveryBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryService service;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u63a8\u9001\u9001\u8d27\u5355\u65b9\u6cd5>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.service.selectById(billId));
        Long orderId = deliveryEntity.getOrderId();
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(orderId));
        if (CloseFlagEnum.CLOSE.getCode().equals(orderEntity.getOrderFlag())) {
            throw new BusinessException("\u8ba2\u5355\u5df2\u5173\u95ed\uff0c\u63d0\u4ea4\u5931\u8d25\uff01");
        }
        deliveryEntity.setCheckState(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        deliveryEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        this.service.saveOrUpdate((Object)deliveryEntity, false);
        Map<Long, BigDecimal> map = this.service.sumDeliveredGroupByDetailId(orderId);
        this.logger.info("\u5df2\u9001\u8d27\u6750\u6599\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(map));
        Integer orderDeliverState = DeliverStateEnum.\u90e8\u5206\u9001\u8d27.getCode();
        int fullFlag = 0;
        if (null != orderEntity.getDeliverModel() && orderEntity.getDeliverModel() == 1) {
            Map<Long, List<OrderProductDetailEntity>> orderDetailMap = orderEntity.getOrderProductDetailList().stream().collect(Collectors.groupingBy(OrderProductDetailEntity::getOrderDetailSourceId));
            for (OrderDetailEntity detailEntity : orderEntity.getOrderDetailList()) {
                Integer orderDetailDeliverState = DeliverStateEnum.\u90e8\u5206\u9001\u8d27.getCode();
                if (orderDetailMap.containsKey(detailEntity.getId())) {
                    List<OrderProductDetailEntity> orderProductDetailEntityList = orderDetailMap.get(detailEntity.getId());
                    for (OrderProductDetailEntity entity : orderProductDetailEntityList) {
                        if (BigDecimal.ZERO.compareTo(entity.getUnDeliverNum()) == 0) {
                            ++fullFlag;
                            continue;
                        }
                        BigDecimal delivery = map.get(entity.getId());
                        if (delivery == null) continue;
                        entity.setDeliverNum(delivery);
                        if (delivery.compareTo(entity.getOrderNum()) > -1) {
                            ++fullFlag;
                            entity.setUnDeliverNum(BigDecimal.ZERO);
                            continue;
                        }
                        entity.setUnDeliverNum(entity.getOrderNum().subtract(delivery));
                    }
                    if (fullFlag > 0 && fullFlag == orderEntity.getOrderDetailList().size()) {
                        orderDetailDeliverState = DeliverStateEnum.\u5168\u90e8\u9001\u8d27.getCode();
                        detailEntity.setDeliverNum(detailEntity.getOrderNum());
                        detailEntity.setUnDeliverNum(BigDecimal.ZERO);
                    }
                }
                detailEntity.setDetailDeliverState(orderDetailDeliverState);
            }
            Boolean allDelivery = orderEntity.getOrderDetailList().stream().allMatch(e -> e.getDeliverNum().compareTo(e.getOrderNum()) > -1);
            if (allDelivery.booleanValue()) {
                orderDeliverState = DeliverStateEnum.\u5168\u90e8\u9001\u8d27.getCode();
            }
            if (!orderDeliverState.equals(orderEntity.getDeliverState()) && !DeliverStateEnum.\u5168\u90e8\u9001\u8d27.getCode().equals(orderEntity.getDeliverState())) {
                orderEntity.setDeliverState(orderDeliverState);
            }
        } else {
            for (OrderDetailEntity entity : orderEntity.getOrderDetailList()) {
                if (BigDecimal.ZERO.compareTo(entity.getUnDeliverNum()) == 0) {
                    ++fullFlag;
                    continue;
                }
                BigDecimal delivery = map.get(entity.getId());
                if (delivery == null) continue;
                entity.setDeliverNum(delivery);
                if (delivery.compareTo(entity.getOrderNum()) > -1) {
                    ++fullFlag;
                    entity.setUnDeliverNum(BigDecimal.ZERO);
                    continue;
                }
                entity.setUnDeliverNum(entity.getOrderNum().subtract(delivery));
            }
            if (fullFlag > 0 && fullFlag == orderEntity.getOrderDetailList().size()) {
                orderDeliverState = DeliverStateEnum.\u5168\u90e8\u9001\u8d27.getCode();
            }
            if (!orderDeliverState.equals(orderEntity.getDeliverState()) && !DeliverStateEnum.\u5168\u90e8\u9001\u8d27.getCode().equals(orderEntity.getDeliverState())) {
                orderEntity.setDeliverState(orderDeliverState);
            }
        }
        this.orderService.saveOrUpdate((Object)orderEntity, false);
        this.logger.info("\u5269\u4f59\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)orderEntity)));
        this.logger.info("\u63a8\u9001\u9001\u8d27\u5355\u65b9\u6cd5\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d1\u8d27\u5355\u6682\u65f6\u4e0d\u652f\u6301\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

