/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.promaterial.plan.bean.PlanChangeEntity;
import com.ejianc.business.promaterial.plan.bean.PlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.PlanEntity;
import com.ejianc.business.promaterial.plan.bean.PlanHistoryEntity;
import com.ejianc.business.promaterial.plan.enums.ChangeStatusEnum;
import com.ejianc.business.promaterial.plan.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.plan.service.IPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IPlanHistoryService;
import com.ejianc.business.promaterial.plan.service.IPlanService;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planChange")
public class PlanChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanService planService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IPlanChangeService planChangeService;
    @Autowired
    private IPlanHistoryService planHistoryService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PlanChangeEntity changeEntity = (PlanChangeEntity)((Object)this.planChangeService.selectById(billId));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(PlanChangeEntity::getUsedTime, (Object)new Date());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getId());
        this.planChangeService.update((Wrapper)updateWrapper);
        PlanVO planVO = this.planService.queryDetail(changeEntity.getTotalId(), false);
        HashMap contIdVersionMap = new HashMap();
        PlanHistoryEntity recordEntity = (PlanHistoryEntity)((Object)BeanMapper.map((Object)planVO, PlanHistoryEntity.class));
        recordEntity.setTotalId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setTotalBid(vo.getId());
                vo.setId(null);
                vo.setCreateTime(new Date());
            });
        }
        this.planHistoryService.saveOrUpdate((Object)recordEntity, false);
        PlanEntity planEntity = (PlanEntity)((Object)BeanMapper.map((Object)planVO, PlanEntity.class));
        planEntity.setChangeCode(changeEntity.getBillCode());
        planEntity.setChangeReason(changeEntity.getChangeReason());
        planEntity.setChangeDescription(changeEntity.getChangeDescription());
        planEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        this.planService.updateById((Object)planEntity);
        PlanEntity planChangeEntity = (PlanEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), PlanEntity.class));
        List<PlanDetailEntity> detailList = planChangeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(detailEntity -> {
                detailEntity.setTid(detailEntity.getId().toString());
                detailEntity.setTpid(detailEntity.getParentId() != null && detailEntity.getParentId() > 0L ? detailEntity.getParentId().toString() : "");
                Long totalBid = detailEntity.getTotalChangeBid();
                detailEntity.setTotalChangeBid(detailEntity.getId());
                detailEntity.setTotalId(changeEntity.getTotalId());
                detailEntity.setId(totalBid);
                detailEntity.setChangeType(null == detailEntity.getChangeType() ? ChangeTypeEnum.\u672a\u53d8\u66f4.getCode() : detailEntity.getChangeType());
                detailEntity.setVersion((Integer)contIdVersionMap.get(totalBid));
            });
            this.planDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
            ArrayList structCodes = new ArrayList();
            HashMap idMap = new HashMap();
            detailList.forEach(cdEntity -> {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                if (!cdEntity.getChangeType().equals(ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode())) {
                    structCodes.add(cdEntity.getStructCode());
                }
            });
            detailList.forEach(cdEntity -> {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
            });
            this.planDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        this.moveAttachment(billId, planEntity.getId(), billTypeCode);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8ba1\u5212\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private void moveAttachment(Long changId, Long totalId, String billTypeCode) {
        List attachIds;
        CommonResponse stringCommonResponse;
        this.logger.info("billTypeCode" + billTypeCode);
        CommonResponse response = this.attachmentApi.queryListBySourceId(changId, "BT202505000006", null, null);
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData())) && !(stringCommonResponse = this.attachmentApi.updateAttachRef(totalId, attachIds = ((List)response.getData()).stream().map(AttachmentVO::getId).collect(Collectors.toList()))).isSuccess()) {
            this.logger.info("\u79fb\u52a8\u9644\u4ef6\u5931\u8d25" + stringCommonResponse.getMsg());
        }
    }
}

