/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.plan.bean.PlanHistoryDetailEntity;
import com.ejianc.business.promaterial.plan.bean.PlanHistoryEntity;
import com.ejianc.business.promaterial.plan.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.plan.mapper.PlanHistoryMapper;
import com.ejianc.business.promaterial.plan.service.IPlanHistoryDetailService;
import com.ejianc.business.promaterial.plan.service.IPlanHistoryService;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.business.promaterial.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planHistoryService")
public class PlanHistoryServiceImpl
extends BaseServiceImpl<PlanHistoryMapper, PlanHistoryEntity>
implements IPlanHistoryService {
    @Autowired
    private IPlanHistoryDetailService planHistoryDetailService;

    @Override
    public PlanVO queryDetail(Long id, boolean detailHasChildren) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PlanHistoryEntity::getChangeId, (Object)id);
        PlanHistoryEntity historyEntity = (PlanHistoryEntity)((Object)super.getOne((Wrapper)lambda));
        PlanVO totalPlanVO = (PlanVO)BeanMapper.map((Object)((Object)historyEntity), PlanVO.class);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PlanHistoryDetailEntity::getHistoryId, (Object)historyEntity.getId());
        wrapper.ne(PlanHistoryDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode());
        wrapper.in(PlanHistoryDetailEntity::getNodeLevel, new Object[]{1, 2});
        List detailEntityList = this.planHistoryDetailService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (PlanHistoryDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getTotalBid().toString());
                cdEntity.setId(cdEntity.getTotalBid());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, PlanDetailVO.class);
            resultMapList.sort((o1, o2) -> {
                String[] sufArrs;
                String[] preArrs = o1.getDetailIndex().split("\\.");
                int len = preArrs.length > (sufArrs = o2.getDetailIndex().split("\\.")).length ? preArrs.length : sufArrs.length;
                for (int i = 0; i < len; ++i) {
                    int preNum = 0;
                    int sufNum = 0;
                    if (i < preArrs.length) {
                        preNum = Integer.parseInt(preArrs[i]);
                    }
                    if (i < sufArrs.length) {
                        sufNum = Integer.parseInt(sufArrs[i]);
                    }
                    if (preNum > sufNum) {
                        return 1;
                    }
                    if (preNum >= sufNum) continue;
                    return -1;
                }
                return 0;
            });
            if (detailHasChildren) {
                totalPlanVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                totalPlanVO.setDetailList(resultMapList);
            }
        }
        return totalPlanVO;
    }

    @Override
    public PlanVO queryDetailHistory(Long id) {
        PlanHistoryEntity historyEntity = (PlanHistoryEntity)((Object)super.selectById((Serializable)id));
        PlanVO totalPlanVO = (PlanVO)BeanMapper.map((Object)((Object)historyEntity), PlanVO.class);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PlanHistoryDetailEntity::getHistoryId, (Object)historyEntity.getId());
        wrapper.ne(PlanHistoryDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode());
        wrapper.in(PlanHistoryDetailEntity::getNodeLevel, new Object[]{1, 2});
        List detailEntityList = this.planHistoryDetailService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (PlanHistoryDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getTotalBid().toString());
                cdEntity.setId(cdEntity.getTotalBid());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, PlanDetailVO.class);
            resultMapList.sort((o1, o2) -> {
                String[] sufArrs;
                String[] preArrs = o1.getDetailIndex().split("\\.");
                int len = preArrs.length > (sufArrs = o2.getDetailIndex().split("\\.")).length ? preArrs.length : sufArrs.length;
                for (int i = 0; i < len; ++i) {
                    int preNum = 0;
                    int sufNum = 0;
                    if (i < preArrs.length) {
                        preNum = Integer.parseInt(preArrs[i]);
                    }
                    if (i < sufArrs.length) {
                        sufNum = Integer.parseInt(sufArrs[i]);
                    }
                    if (preNum > sufNum) {
                        return 1;
                    }
                    if (preNum >= sufNum) continue;
                    return -1;
                }
                return 0;
            });
            totalPlanVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
        }
        return totalPlanVO;
    }
}

