/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.plan.bean.PlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.PlanEntity;
import com.ejianc.business.promaterial.plan.enums.ChangeStatusEnum;
import com.ejianc.business.promaterial.plan.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.plan.mapper.PlanMapper;
import com.ejianc.business.promaterial.plan.service.IPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IPlanService;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.business.promaterial.utils.DateUtil2;
import com.ejianc.business.promaterial.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planService")
public class PlanServiceImpl
extends BaseServiceImpl<PlanMapper, PlanEntity>
implements IPlanService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IPlanChangeService planChangeService;
    private static final String BILL_CODE = "PLAN";

    @Override
    public PlanVO insertOrUpdate(PlanVO planVO) {
        List detailList;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PlanEntity::getProjectId, (Object)planVO.getProjectId());
        queryWrapper.ne(null != planVO.getId(), BaseEntity::getId, (Object)planVO.getId());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u8ba1\u5212");
        }
        if (StringUtils.isEmpty((CharSequence)planVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                planVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(detailList = planVO.getDetailList()))) {
            for (PlanDetailVO detailVO : detailList) {
                if (!StringUtils.equals((CharSequence)"add", (CharSequence)detailVO.getRowState())) continue;
                detailVO.setId(null);
            }
        }
        PlanEntity planEntity = (PlanEntity)((Object)BeanMapper.map((Object)planVO, PlanEntity.class));
        planEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        super.saveOrUpdate((Object)planEntity, false);
        List<PlanDetailEntity> planDetailEntities = planEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(planDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (PlanDetailEntity cdEntity : planDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (PlanDetailEntity cdEntity : planDetailEntities) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                cdEntity.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
                cdEntity.setCode(cdEntity.getName());
            }
            List resultMapList = BeanMapper.mapList(planDetailEntities, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            List<Map<String, Object>> ListCodeDate = this.creatCode(treeData, null, null);
            ArrayList<PlanDetailEntity> entities = new ArrayList<PlanDetailEntity>();
            this.treeToList(ListCodeDate, entities);
            this.planDetailService.saveOrUpdateBatch(entities, entities.size(), false);
        }
        return this.queryDetail(planEntity.getId(), true);
    }

    private void treeToList(List<Map<String, Object>> list, List<PlanDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((PlanDetailEntity)((Object)BeanMapper.map(ypd, PlanDetailEntity.class)));
        }
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String structCode, String innerCode) {
        for (Map<String, Object> ypd : list) {
            if (StringUtils.isNotEmpty((CharSequence)structCode)) {
                ypd.put("structCode", structCode + "&&" + ypd.get("code"));
            } else {
                ypd.put("structCode", ypd.get("code"));
            }
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), null, ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String structCode, String innerCode, String detailIndex) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (StringUtils.isNotEmpty((CharSequence)detailIndex) && null == ypd.get("detailIndex")) {
                ypd.put("detailIndex", detailIndex + "." + (i + 1));
            }
            if (StringUtils.isNotEmpty((CharSequence)structCode)) {
                ypd.put("structCode", structCode + "&&" + ypd.get("code"));
            } else {
                ypd.put("structCode", ypd.get("code"));
            }
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), null, ypd.get("innerCode").toString(), ypd.get("detailIndex").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    @Override
    public PlanVO queryDetail(Long id, boolean detailHasChildren) {
        PlanEntity planEntity = (PlanEntity)((Object)super.selectById((Serializable)id));
        PlanVO planVO = (PlanVO)BeanMapper.map((Object)((Object)planEntity), PlanVO.class);
        List<PlanDetailEntity> detailEntityListDb = planEntity.getDetailList();
        ArrayList<PlanDetailEntity> detailEntityList = new ArrayList<PlanDetailEntity>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode() != entity.getChangeType()) {
                    detailEntityList.add((PlanDetailEntity)((Object)entity));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (PlanDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<PlanDetailVO> resultMapList = this.entryListToVoWithSort(detailEntityList);
            if (detailHasChildren) {
                planVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            } else {
                planVO.setDetailList(resultMapList);
            }
        }
        planVO.setChangeList(this.planChangeService.queryDetailRecord(id));
        return planVO;
    }

    @Override
    public List<PlanDetailVO> predictDateSearch(Long id, String start, String end) {
        PlanEntity planEntity = (PlanEntity)((Object)super.selectById((Serializable)id));
        List<PlanDetailEntity> detailEntityListDb = planEntity.getDetailList();
        ArrayList<PlanDetailEntity> detailEntityList = new ArrayList<PlanDetailEntity>();
        if (StringUtils.isNotBlank((CharSequence)start) && StringUtils.isNotBlank((CharSequence)end)) {
            Date startDate = DateUtil2.formatDate(start);
            Date endDate = DateUtil2.formatDate(end);
            if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
                detailEntityListDb.forEach(entity -> {
                    if ((null == entity.getChangeType() || ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode() != entity.getChangeType()) && entity.getPredictDate() != null && entity.getPredictDate().getTime() >= startDate.getTime() && entity.getPredictDate().getTime() <= endDate.getTime()) {
                        detailEntityList.add((PlanDetailEntity)((Object)entity));
                    }
                });
            }
        } else if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode() != entity.getChangeType()) {
                    detailEntityList.add((PlanDetailEntity)((Object)entity));
                }
            });
        }
        List<Object> vos = new ArrayList<PlanDetailVO>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (PlanDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
                cdEntity.setShadowId(cdEntity.getTid());
            }
            List<PlanDetailVO> resultMapList = this.entryListToVoWithSort(detailEntityList);
            vos = TreeNodeBUtil.buildTree(resultMapList);
        }
        return vos;
    }

    @Override
    public CommonResponse<Long> queryIdByProject(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PlanEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in(PlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        PlanEntity planEntity = (PlanEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
        return null != planEntity ? CommonResponse.success((String)"\u67e5\u8be2\u8ba1\u5212\u6210\u529f\uff01", (Object)planEntity.getId()) : CommonResponse.error((String)"\u67e5\u8be2\u8ba1\u5212\u5931\u8d25");
    }

    @Override
    public List<PlanDetailVO> refPlanDetail(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PlanEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in(PlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        PlanEntity planEntity = (PlanEntity)((Object)this.getOne((Wrapper)queryWrapper));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PlanDetailEntity::getTotalId, (Object)planEntity.getId());
        wrapper.ne(PlanDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode());
        wrapper.in(PlanDetailEntity::getNodeLevel, new Object[]{1, 2});
        List entities = this.planDetailService.list((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            for (PlanDetailEntity cdEntity : entities) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        List<PlanDetailVO> detailVos = this.entryListToVoWithSort(entities);
        return TreeNodeBUtil.buildTree(detailVos);
    }

    private List<PlanDetailVO> entryListToVoWithSort(List<PlanDetailEntity> detailEntities) {
        List detailVOList = BeanMapper.mapList(detailEntities, PlanDetailVO.class);
        detailVOList.sort((o1, o2) -> {
            String[] sufArrs;
            String[] preArrs = o1.getDetailIndex().split("\\.");
            int len = preArrs.length > (sufArrs = o2.getDetailIndex().split("\\.")).length ? preArrs.length : sufArrs.length;
            for (int i = 0; i < len; ++i) {
                int preNum = 0;
                int sufNum = 0;
                if (i < preArrs.length) {
                    preNum = Integer.parseInt(preArrs[i]);
                }
                if (i < sufArrs.length) {
                    sufNum = Integer.parseInt(sufArrs[i]);
                }
                if (preNum > sufNum) {
                    return 1;
                }
                if (preNum >= sufNum) continue;
                return -1;
            }
            return 0;
        });
        return detailVOList;
    }
}

