/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.pricelib.bean.PriceGuideEntity;
import com.ejianc.business.promaterial.pricelib.mapper.PriceGuideMapper;
import com.ejianc.business.promaterial.pricelib.service.IPriceGuideService;
import com.ejianc.business.promaterial.pricelib.vo.PriceGuideDetailVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="priceGuideService")
public class PriceGuideServiceImpl
extends BaseServiceImpl<PriceGuideMapper, PriceGuideEntity>
implements IPriceGuideService {
    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PriceGuideDetailVO> successList = new ArrayList<PriceGuideDetailVO>();
        ArrayList<PriceGuideDetailVO> errorList = new ArrayList<PriceGuideDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            List datas;
            int i;
            ArrayList materialCodeList = new ArrayList();
            HashMap map = new HashMap();
            for (i = 1; i < result.size(); ++i) {
                datas = (List)result.get(i);
                materialCodeList.add(datas.get(0));
            }
            for (i = 1; i < result.size(); ++i) {
                datas = (List)result.get(i);
                PriceGuideDetailVO detailVO = new PriceGuideDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String materialCode = (String)datas.get(0);
                if (!map.containsKey(materialCode)) {
                    detailVO.setErrorMsg("\u6750\u6599\u7f16\u7801\u4e0d\u5339\u914d\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                Object materialVO = (MaterialVO)map.get(materialCode);
                detailVO.setMaterialTypeId(materialVO.getCategoryId());
                detailVO.setMaterialTypeName(materialVO.getCategoryName());
                detailVO.setMaterialId(materialVO.getId());
                detailVO.setMaterialName(materialVO.getName());
                detailVO.setSpec(materialVO.getSpec());
                detailVO.setUnitName(materialVO.getUnitName());
                try {
                    materialVO = (String)datas.get(1);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6700\u4f4e\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String e = (String)datas.get(2);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6700\u9ad8\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

