/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.promaterial.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.promaterial.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.business.promaterial.utils.MathUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"invoiceReceivePool"})
public class InvoiceReceivePoolController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "tax-receive-pool-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceReceivePoolService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvoiceReceiveRegistService registService;
    @Autowired
    private ISupplierApi supplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceReceivePoolVO> saveOrUpdate(@RequestBody InvoiceReceivePoolVO saveorUpdateVO) {
        InvoiceReceivePoolEntity entity = (InvoiceReceivePoolEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceReceivePoolEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdateNoES((Object)entity);
        InvoiceReceivePoolVO vo = (InvoiceReceivePoolVO)BeanMapper.map((Object)((Object)entity), InvoiceReceivePoolVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceivePoolVO> queryDetail(Long id) {
        InvoiceReceivePoolEntity entity = (InvoiceReceivePoolEntity)((Object)this.service.selectById(id));
        InvoiceReceivePoolVO vo = (InvoiceReceivePoolVO)BeanMapper.map((Object)((Object)entity), InvoiceReceivePoolVO.class);
        if (vo.getReceiveBillId() != null) {
            InvoiceReceiveRegistVO info = (InvoiceReceiveRegistVO)BeanMapper.map((Object)this.registService.selectById(vo.getReceiveBillId()), InvoiceReceiveRegistVO.class);
            vo.setReceiveRegistInfo(info);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceivePoolVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("invoiceCode");
        param.getFuzzyFields().add("invoiceNumber");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("receiveBillCode");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("contractCode");
        param.getParams().put("receiveBillId", new Parameter("ne", null));
        if (param.getParams().get("hasMyRegist") != null) {
            if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("1")) {
                param.getParams().put("employeeId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("0")) {
                param.getParams().put("employeeId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List invoiceReceivePoolVOS = BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceivePoolVO.class);
        pageData.setRecords(invoiceReceivePoolVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> queryGFList(@RequestBody QueryParam param) {
        CommonResponse commonResponse;
        param.getFuzzyFields().add("invoiceCode");
        param.getFuzzyFields().add("invoiceNumber");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("receiveBillCode");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("contractCode");
        param.getParams().put("receiveBillId", new Parameter("ne", null));
        if (param.getParams().get("hasMyRegist") != null) {
            if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("1")) {
                param.getParams().put("employeeId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("0")) {
                param.getParams().put("employeeId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List invoiceReceivePoolVOS = BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceivePoolVO.class);
        pageData.setRecords(invoiceReceivePoolVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refInvoiceReceivePoolData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> refInvoiceReceivePoolData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition) && JSONObject.parseObject((String)condition).containsKey((Object)"gfSupplierId")) {
            CommonResponse commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
            if (!commonResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        } else {
            param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("receiveBillId", new Parameter("ne", null));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.getLong("projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", (Object)_con.getLong("projectId")));
            }
            if (_con.getLong("invoiceType") != null) {
                param.getParams().put("invoiceType", new Parameter("eq", (Object)_con.getLong("invoiceType")));
            }
            if (_con.getBoolean("regist") != null) {
                param.getParams().put("regist", new Parameter("eq", (Object)_con.getBoolean("regist")));
            }
            if (_con.getLong("flag") != null) {
                param.getParams().put("flag", new Parameter("eq", (Object)_con.getLong("flag")));
            }
            if (_con.containsKey((Object)"deductionBillId")) {
                param.getParams().put("deductionBillId", new Parameter("eq", (Object)_con.getLong("deductionBillId")));
            }
        }
        IPage page = this.service.queryPage(param);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceivePoolVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/authBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> authBatch(@RequestBody JSONObject info) {
        if (info == null || info.getJSONArray("ids") == null || info.getString("periodOfTax") == null || info.getString("authDate") == null || info.getString("authState") == null || info.getString("authPerson") == null) {
            return CommonResponse.error((String)"\u975e\u6cd5\u53c2\u6570");
        }
        List<Long> ids = Arrays.stream(info.getJSONArray("ids").toArray()).map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
        String periodOfTax = info.getString("periodOfTax");
        String authDate = info.getString("authDate");
        Integer authState = info.getInteger("authState");
        String authPerson = info.getString("authPerson");
        this.service.authBatch(ids, periodOfTax + "-01", authDate, authState, authPerson);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/noAuthBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> noAuthBatch(@RequestBody List<Long> ids) {
        if (ListUtil.isEmpty(ids)) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.service.noAuthBatch(ids);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("receiveBillCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceivePoolVO r = (InvoiceReceivePoolVO)BeanMapper.map((Object)pool, InvoiceReceivePoolVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                if (r.getAuthState() != null) {
                    switch (r.getAuthState()) {
                        case 0: {
                            r.setAuthStateName("\u672a\u8ba4\u8bc1");
                            break;
                        }
                        case 1: {
                            r.setAuthStateName("\u8ba4\u8bc1\u6210\u529f");
                            break;
                        }
                        case 2: {
                            r.setAuthStateName("\u8ba4\u8bc1\u5931\u8d25");
                            break;
                        }
                    }
                }
                if (r.getDeductionState() != null) {
                    switch (r.getDeductionState()) {
                        case 0: {
                            r.setDeductionStateName("\u672a\u62b5\u6263");
                            break;
                        }
                        case 1: {
                            r.setDeductionStateName("\u5df2\u62b5\u6263");
                            break;
                        }
                    }
                }
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().exportWithTrans("invoiceReceivePool-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelAuthExport"})
    public void excelAuthExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("receiveBillCode");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceivePoolVO r = (InvoiceReceivePoolVO)BeanMapper.map((Object)pool, InvoiceReceivePoolVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceivePool-auth-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelNotAuthExport"})
    public void excelNotAuthExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("receiveBillCode");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceivePoolVO r = (InvoiceReceivePoolVO)BeanMapper.map((Object)pool, InvoiceReceivePoolVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                if (r.getAuthState() != null) {
                    switch (r.getAuthState()) {
                        case 0: {
                            r.setAuthStateName("\u672a\u8ba4\u8bc1");
                            break;
                        }
                        case 1: {
                            r.setAuthStateName("\u8ba4\u8bc1\u6210\u529f");
                            break;
                        }
                        case 2: {
                            r.setAuthStateName("\u8ba4\u8bc1\u5931\u8d25");
                            break;
                        }
                    }
                }
                if (r.getDeductionState() != null) {
                    switch (r.getDeductionState()) {
                        case 0: {
                            r.setDeductionStateName("\u672a\u62b5\u6263");
                            break;
                        }
                        case 1: {
                            r.setDeductionStateName("\u5df2\u62b5\u6263");
                            break;
                        }
                    }
                }
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceivePool-not-auth-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/querySumMnyTax"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> querySumMnyTax(Long contractId) {
        Map<String, BigDecimal> map = this.service.querySumMnyTax(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u53d1\u7968\u91d1\u989d\u6210\u529f\uff01", map);
    }

    @PostMapping(value={"excelReportExport"})
    public void excelReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("receiveBillCode");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("receiveBillId", new Parameter("ne", null));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceivePoolVO r = (InvoiceReceivePoolVO)BeanMapper.map((Object)pool, InvoiceReceivePoolVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                if (r.getAuthState() != null) {
                    switch (r.getAuthState()) {
                        case 0: {
                            r.setAuthStateName("\u672a\u8ba4\u8bc1");
                            break;
                        }
                        case 1: {
                            r.setAuthStateName("\u8ba4\u8bc1\u6210\u529f");
                            break;
                        }
                        case 2: {
                            r.setAuthStateName("\u8ba4\u8bc1\u5931\u8d25");
                            break;
                        }
                    }
                }
                if (r.getDeductionState() != null) {
                    switch (r.getDeductionState()) {
                        case 0: {
                            r.setDeductionStateName("\u672a\u62b5\u6263");
                            break;
                        }
                        case 1: {
                            r.setDeductionStateName("\u5df2\u62b5\u6263");
                            break;
                        }
                    }
                }
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("reportReceivePool-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/invoiceReceiveRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> invoiceReceiveRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getOrderMap().put("create_time", "desc");
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("myselfCreate") && "1".equals(conditionMap.get("myselfCreate").toString())) {
                queryParam.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            }
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
            }
            if (null != conditionMap.get("taxCostFlag")) {
                queryParam.getParams().put("taxCostFlag", new Parameter("ne", (Object)1));
                queryParam.getParams().remove("flag");
                queryParam.getParams().remove("type");
            }
        }
        IPage page = this.service.queryPage(queryParam);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List invoiceReceivePoolVOList = BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceivePoolVO.class);
        if (CollectionUtils.isNotEmpty((Collection)invoiceReceivePoolVOList)) {
            invoiceReceivePoolVOList.forEach(t -> t.setSurplusInvoiceTaxMny(MathUtil.safeSub(t.getInvoiceTaxMny(), t.getUsedInvoiceTaxMny())));
        }
        pageData.setRecords(invoiceReceivePoolVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

