/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.bean.ContractChangeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractClauseEntity;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.bean.ContractFeeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractRecordEntity;
import com.ejianc.business.promaterial.contract.bean.ContractStageEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.mapper.ContractChangeMapper;
import com.ejianc.business.promaterial.contract.service.IContractChangeService;
import com.ejianc.business.promaterial.contract.service.IContractClauseService;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractFeeService;
import com.ejianc.business.promaterial.contract.service.IContractRecordService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.service.IContractStageService;
import com.ejianc.business.promaterial.contract.vo.ContractChangeClauseVO;
import com.ejianc.business.promaterial.contract.vo.ContractChangeCompareVO;
import com.ejianc.business.promaterial.contract.vo.ContractChangeDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractChangeFeeVO;
import com.ejianc.business.promaterial.contract.vo.ContractChangeStageVO;
import com.ejianc.business.promaterial.contract.vo.ContractChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractChangeService")
public class ContractChangeServiceImpl
extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity>
implements IContractChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "proMaterialContractBill";
    private static final String CONTRACT_MATERIAL = "BT211227000000003";
    private static final String CONTRACT_MATERIAL_RECORD = "BT220105000000028";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractRecordService contractRecordService;
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractFeeService contractFeeService;
    @Autowired
    private IContractStageService contractStageService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public ContractChangeVO insertOrUpdate(ContractChangeVO contractChangeVO, Boolean isControl) {
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractChangeVO.getContractId()));
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        this.contractService.checkContract(contractChangeVO.getContractId(), contractChangeVO.getId());
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(ContractChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)contractChangeVO.getId());
        }
        lambdachange.and(c -> (LambdaQueryWrapper)c.notIn(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        LambdaQueryWrapper lambdaQuery2 = Wrappers.lambdaQuery();
        lambdaQuery2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery2.eq(ContractEntity::getMainContractId, (Object)contractChangeVO.getContractId());
        lambdaQuery2.and(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int nums = this.contractService.count((Wrapper)lambdaQuery2);
        if (nums > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        ContractEntity pcentity = (ContractEntity)((Object)this.contractService.selectById(contractChangeVO.getContractId()));
        if (!isControl.booleanValue() && (StringUtils.isBlank((CharSequence)contractChangeVO.getBillCode()) || contract.getBillCode().equals(contractChangeVO.getBillCode()))) {
            QueryParam billCodeParam = new QueryParam();
            billCodeParam.getParams().put("contract_id", new Parameter("eq", (Object)contractChangeVO.getContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            billCodeParam.getParams().put("bill_state", new Parameter("in", billStateList));
            List billCodeChangeEntityList = super.queryList(billCodeParam, false);
            String changeNum = "";
            changeNum = billCodeChangeEntityList.size() < 9 ? changeNum + "0" + (billCodeChangeEntityList.size() + 1) : changeNum + (billCodeChangeEntityList.size() + 1);
            String type = "-1-";
            contractChangeVO.setBillCode(contract.getBillCode() + type + changeNum);
        }
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractChangeEntity::getBillCode, (Object)contractChangeVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(ContractChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getContractId()));
            entitiesc = this.contractService.queryList(queryParam, false);
            pcentity.setId(contractChangeVO.getContractId());
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, (Object)contractChangeVO.getBillCode());
            lambda.ne(ContractChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getContractId()));
            entitiesc = this.contractService.queryList(queryParam, false);
            pcentity.setId(contractChangeVO.getContractId());
            pcentity.setChangeVersion(contractChangeVO.getChangeVersion() + 1);
            contractChangeVO.setChangeVersion(Integer.valueOf(contractChangeVO.getChangeVersion() + 1));
            if (isControl.booleanValue()) {
                contractChangeVO.setId(Long.valueOf(IdWorker.getId()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractDetailList())) {
            contractChangeVO.getContractDetailList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractFeeList())) {
            contractChangeVO.getContractFeeList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractClauseList())) {
            contractChangeVO.getContractClauseList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractStageList())) {
            contractChangeVO.getContractStageList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (ContractChangeEntity)((Object)BeanMapper.map((Object)contractChangeVO, ContractChangeEntity.class));
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)entity, false);
        }
        pcentity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        pcentity.setChangingMny(entity.getContractMny());
        pcentity.setChangingMnyWithTax(entity.getContractTaxMny());
        pcentity.setChangeDate(entity.getChangeDate());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        if (!isControl.booleanValue()) {
            this.contractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        }
        ContractChangeVO res = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class);
        return res;
    }

    private boolean isInsertContractChange(ContractChangeVO contractChangeVO) {
        return contractChangeVO.getId() == null || contractChangeVO.getId() == 0L;
    }

    @Override
    public ContractChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ContractChangeVO changeVO = new ContractChangeVO();
        BigDecimal baseTaxMoney = contractEntity.getBaseMoneyWithTax() == null ? BigDecimal.ZERO : contractEntity.getBaseMoneyWithTax();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        changeVO.setId(id);
        changeVO.setContractId(id);
        changeVO.setBaseMoneyWithTax(baseTaxMoney);
        changeVO.setContractTaxMny(contractTaxMny);
        changeVO.setAllChangeAmt(contractTaxMny.subtract(baseTaxMoney));
        changeVO.setOrgId(contractEntity.getParentOrgId());
        if (changeVO.getAllChangeAmt().compareTo(BigDecimal.ZERO) != 0 && baseTaxMoney.compareTo(BigDecimal.ZERO) != 0) {
            changeVO.setChangeAmtRate(new BigDecimal(100).multiply(changeVO.getAllChangeAmt().divide(baseTaxMoney, 8, 5)));
        } else {
            changeVO.setChangeAmtRate(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractChangeEntity::getContractId, (Object)id);
        lambda.in(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)entities)) {
            changeVO.setChangeList(BeanMapper.mapList((Iterable)entities, ContractChangeVO.class));
            changeVO.setChangeNum(Integer.valueOf(entities.size()));
        } else {
            changeVO.setChangeNum(Integer.valueOf(0));
        }
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    @Override
    public ContractChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)changeId));
        queryParam.getOrderMap().put("createTime", "desc");
        List recordList = this.contractRecordService.queryList(queryParam);
        ContractChangeVO changeVO = new ContractChangeVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            changeVO = (ContractChangeVO)BeanMapper.map(recordList.get(0), ContractChangeVO.class);
        }
        return changeVO;
    }

    @Override
    public ContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        ContractChangeVO purchaseChangeVo = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class);
        purchaseChangeVo.setContractId(purchaseChangeVo.getId());
        purchaseChangeVo.setId(null);
        purchaseChangeVo.setBillState(null);
        purchaseChangeVo.setCreateUserCode(null);
        purchaseChangeVo.setCreateTime(null);
        purchaseChangeVo.setUpdateUserCode(null);
        purchaseChangeVo.setUpdateTime(null);
        purchaseChangeVo.setChangeDate(new Date());
        purchaseChangeVo.setBeforeContractName(entity.getContractName());
        purchaseChangeVo.setBeforeChangeMny(entity.getContractMny());
        purchaseChangeVo.setBeforeChangeMnyWithTax(entity.getContractTaxMny());
        purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());
        purchaseChangeVo.setBeforeChangeTax(entity.getContractTax());
        purchaseChangeVo.setContractType(entity.getContractType());
        purchaseChangeVo.setDueDate(entity.getDueDate());
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, (Object)contractId);
        lambda.ne(ContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u4e2d\u6b62\u9879);
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            purchaseChangeVo.setContractDetailList(BeanMapper.mapList((Iterable)details, ContractChangeDetailVO.class));
            purchaseChangeVo.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setChangeType("0");
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        } else {
            purchaseChangeVo.setContractDetailList(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractFeeList())) {
            purchaseChangeVo.getContractFeeList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractClauseList())) {
            purchaseChangeVo.getContractClauseList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractStageList())) {
            purchaseChangeVo.getContractStageList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        return purchaseChangeVo;
    }

    public Boolean editChangeFlag(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getPerformanceStatus())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractChangeEntity::getContractId, (Object)contractId);
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<String, String>();
        orderByParams.put("treeIndex", "asc");
        HashMap<String, LinkedHashMap<String, String>> orders = new HashMap<String, LinkedHashMap<String, String>>();
        orders.put("detailList", orderByParams);
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)super.selectById((Serializable)id, orders));
        ContractChangeCompareVO changeCompareVO = (ContractChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), ContractChangeCompareVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ContractChangeCompareVO beforeChangeVO = new ContractChangeCompareVO();
        HashMap beforeDetailMap = new HashMap();
        HashMap beforeFeeMap = new HashMap();
        HashMap beforeClauseMap = new HashMap();
        HashMap beforeStageMap = new HashMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            ArrayList newDetail = new ArrayList();
            HashMap finalBeforeDetailMap = beforeDetailMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractDetailList())) {
                changeCompareVO.getContractDetailList().stream().forEach(detail -> {
                    if (!detail.getChangeType().equals(String.valueOf(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode()))) {
                        if (detail.getSrcTblId() == null) {
                            newDetail.add(detail);
                        }
                        if (finalBeforeDetailMap.containsKey(detail.getSrcTblId())) {
                            detail.setBeforeChangeRate(((ContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getDetailTaxRate());
                            detail.setBeforeChangePrice(((ContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getPrice());
                            detail.setBeforeChangeNum(((ContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getNum());
                            newDetail.add(detail);
                            finalBeforeDetailMap.remove(detail.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setContractDetailList(newDetail);
            ArrayList newFee = new ArrayList();
            HashMap finalBeforeFeeMap = beforeFeeMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractFeeList())) {
                changeCompareVO.getContractFeeList().stream().forEach(fee -> {
                    if (!String.valueOf(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode()).equals(fee.getChangeType())) {
                        if (fee.getSrcTblId() == null) {
                            newFee.add(fee);
                        }
                        if (finalBeforeFeeMap.containsKey(fee.getSrcTblId())) {
                            fee.setBeforeChangeCostRate(((ContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreeTaxRate());
                            fee.setBeforeChangeCostPrice(((ContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreePrice());
                            fee.setBeforeChangeCostNum(((ContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreeNum());
                            newFee.add(fee);
                            finalBeforeFeeMap.remove(fee.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setContractFeeList(newFee);
            ArrayList newClauses = new ArrayList();
            HashMap finalBeforeClauseMap = beforeClauseMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractClauseList())) {
                changeCompareVO.getContractClauseList().stream().forEach(clause -> {
                    if (clause.getSrcTblId() == null) {
                        clause.setChangeType("\u589e\u8865\u9879");
                        newClauses.add(clause);
                    } else if (finalBeforeClauseMap.containsKey(clause.getSrcTblId())) {
                        if (!((ContractChangeClauseVO)finalBeforeClauseMap.get(clause.getSrcTblId())).getClauseContent().equals(clause.getClauseContent())) {
                            clause.setBeforeChangeClauseContent(((ContractChangeClauseVO)finalBeforeClauseMap.get(clause.getSrcTblId())).getClauseContent());
                            clause.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                            newClauses.add(clause);
                        }
                        finalBeforeClauseMap.remove(clause.getSrcTblId());
                    }
                });
            }
            if (MapUtils.isNotEmpty(finalBeforeClauseMap)) {
                finalBeforeClauseMap.values().forEach(c -> {
                    c.setChangeType("\u5220\u9664\u9879");
                    newClauses.add(c);
                });
            }
            changeCompareVO.setContractClauseList(newClauses);
            ArrayList<ContractChangeStageVO> newStageList = new ArrayList<ContractChangeStageVO>();
            HashMap finalBeforeStageMap = beforeStageMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractStageList())) {
                ContractChangeStageVO beforeItem = null;
                for (ContractChangeStageVO curItem : changeCompareVO.getContractStageList()) {
                    if (curItem.getSrcTblId() == null) {
                        curItem.setChangeType("\u589e\u8865\u9879");
                        newStageList.add(curItem);
                        continue;
                    }
                    if (!finalBeforeStageMap.containsKey(curItem.getSrcTblId())) continue;
                    beforeItem = (ContractChangeStageVO)finalBeforeStageMap.get(curItem.getSrcTblId());
                    if (!beforeItem.getStageName().equals(curItem.getStageName()) || !beforeItem.getStageScale().equals(curItem.getStageScale())) {
                        curItem.setBeforePaymentName(beforeItem.getStageName());
                        curItem.setBeforePaymentScale(beforeItem.getStageScale());
                        curItem.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                        newStageList.add(curItem);
                    }
                    finalBeforeStageMap.remove(curItem.getSrcTblId());
                }
            }
            if (MapUtils.isNotEmpty(finalBeforeStageMap)) {
                finalBeforeStageMap.values().forEach(c -> {
                    c.setChangeType("\u5220\u9664\u9879");
                    newStageList.add((ContractChangeStageVO)c);
                });
            }
            changeCompareVO.setContractStageList(newStageList);
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ContractChangeEntity entity = (ContractChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractEntity.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)query);
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingMnyWithTax(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeContractName(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType) {
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, "proMaterialContractBill");
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "proMaterialContractBill", targetBillId, targetBillTypeCode, "proMaterialContractBill", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        return null;
    }

    @Override
    public ContractChangeVO queryDetail(Long id) {
        ContractChangeEntity entity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(id));
        ContractChangeVO vo = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class);
        return vo;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long billId, String billTypeCode, Boolean commitState, Boolean filingFlag) {
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)super.selectById((Serializable)billId));
        CommonResponse resp = null;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ContractRecordEntity recordEntity = (ContractRecordEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractRecordEntity.class));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- changeEntity:" + (Object)((Object)changeEntity) + "  contractEntity:" + (Object)((Object)contractEntity));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getContractDetailList())) {
            recordEntity.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractFeeList())) {
            recordEntity.getContractFeeList().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractClauseList())) {
            recordEntity.getContractClauseList().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractStageList())) {
            recordEntity.getContractStageList().forEach(vo -> {
                vo.setContractStageId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        this.contractRecordService.saveOrUpdate((Object)recordEntity, false);
        String contractBillType = "";
        if (0 == contractEntity.getFrameFlag()) {
            contractBillType = CONTRACT_MATERIAL;
            String contractRecordBillType = CONTRACT_MATERIAL_RECORD;
            resp = this.copyFile(contractEntity.getId().toString(), contractBillType, recordEntity.getId().toString(), contractRecordBillType, "proMaterialContractBill");
            if (resp != null) {
                return resp;
            }
        }
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setDetailTaxMny(changeEntity.getDetailTaxMny());
        contractEntity.setDetailMny(changeEntity.getDetailMny());
        contractEntity.setDetailTax(changeEntity.getDetailTax());
        contractEntity.setFreeTaxMny(changeEntity.getFreeTaxMny());
        contractEntity.setFreeMny(changeEntity.getFreeMny());
        contractEntity.setFreeTax(changeEntity.getFreeTax());
        contractEntity.setPurchaseId(changeEntity.getPurchaseId());
        contractEntity.setPurchaseName(changeEntity.getPurchaseName());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
        contractEntity.setPricingType(changeEntity.getPricingType());
        contractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        contractEntity.setSupplierEmployeeMobile(changeEntity.getSupplierEmployeeMobile());
        contractEntity.setProjectPlace(changeEntity.getProjectPlace());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingMnyWithTax(null);
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setEffectiveDate(new Date());
        if (0 == contractEntity.getFrameFlag()) {
            this.copyFile(billId.toString(), billTypeCode, contractEntity.getId().toString(), contractBillType, "materialChangeContractFile");
        }
        if (resp != null) {
            return resp;
        }
        changeEntity.setChangeDate(new Date());
        this.contractChangeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--2");
        this.contractClauseService.deleteByContractId(changeEntity.getContractId());
        this.contractFeeService.deleteByContractId(changeEntity.getContractId());
        this.contractStageService.deleteByContractId(changeEntity.getContractId());
        contractEntity.setContractClauseList(null);
        contractEntity.setContractFeeList(null);
        contractEntity.setContractStageList(null);
        if (CollectionUtils.isNotEmpty(changeEntity.getContractDetailList())) {
            this.logger.info("\u590d\u5236\u5b50\u8868\u5f00\u59cb--" + changeEntity.getContractDetailList());
            changeEntity.getContractDetailList().forEach(vo -> {
                this.logger.info("\u590d\u5236\u5b50\u8868--" + vo.getContractDetailId() + "---type" + vo.getChangeType());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = contractEntity.getContractDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setContractDetailList(BeanMapper.mapList(changeEntity.getContractDetailList(), ContractDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractFeeList())) {
            changeEntity.getContractFeeList().forEach(vo -> vo.setId(null));
            contractEntity.setContractFeeList(BeanMapper.mapList(changeEntity.getContractFeeList(), ContractFeeEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractClauseList())) {
            changeEntity.getContractClauseList().forEach(vo -> vo.setId(null));
            contractEntity.setContractClauseList(BeanMapper.mapList(changeEntity.getContractClauseList(), ContractClauseEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractStageList())) {
            changeEntity.getContractStageList().forEach(vo -> vo.setId(null));
            contractEntity.setContractStageList(BeanMapper.mapList(changeEntity.getContractStageList(), ContractStageEntity.class));
        }
        boolean flag = this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }
}

