/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.finance.bean.PayInvoiceEntity;
import com.ejianc.business.promaterial.finance.mapper.PayInvoiceMapper;
import com.ejianc.business.promaterial.finance.service.IPayInvoiceService;
import com.ejianc.business.promaterial.finance.vo.PayInvoiceVO;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.promaterial.taxnew.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.promaterial.utils.BigDecimalUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payInvoiceService")
public class PayInvoiceServiceImpl
extends BaseServiceImpl<PayInvoiceMapper, PayInvoiceEntity>
implements IPayInvoiceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;

    @Override
    public void updateInvoiceUsedMnyBySave(List<PayInvoiceVO> voList, Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("payapplyId", new Parameter("eq", (Object)id));
        List oldInvoiceList = id != null ? this.queryList(param, false) : null;
        HashMap invoiceUpdateMap = new HashMap();
        if (CollectionUtils.isNotEmpty(voList)) {
            HashMap oldInvoiceMap = CollectionUtils.isNotEmpty((Collection)oldInvoiceList) ? oldInvoiceList.stream().collect(Collectors.toMap(PayInvoiceEntity::getInvoiceId, PayInvoiceEntity::getUsedInvoiceTaxMny)) : new HashMap();
            voList.forEach(t -> {
                Long invoiceId = t.getInvoiceId();
                BigDecimal nowUesdInvoiceTaxMny = (BigDecimal)invoiceUpdateMap.get(invoiceId);
                nowUesdInvoiceTaxMny = "del".equals(t.getRowState()) && t.getId() != null ? ComputeUtil.safeAdd((BigDecimal)nowUesdInvoiceTaxMny, (BigDecimal)BigDecimalUtil.convertToMinusNumber((BigDecimal)oldInvoiceMap.get(invoiceId))) : ComputeUtil.safeAdd((BigDecimal)nowUesdInvoiceTaxMny, (BigDecimal)BigDecimalUtil.safeSub(t.getUsedInvoiceTaxMny(), (BigDecimal)oldInvoiceMap.get(invoiceId)));
                invoiceUpdateMap.put(invoiceId, nowUesdInvoiceTaxMny);
                oldInvoiceMap.remove(invoiceId);
            });
            if (oldInvoiceMap != null && oldInvoiceMap.size() > 0) {
                for (Map.Entry t2 : oldInvoiceMap.entrySet()) {
                    invoiceUpdateMap.put(t2.getKey(), BigDecimalUtil.convertToMinusNumber((BigDecimal)t2.getValue()));
                }
            }
        } else if (CollectionUtils.isNotEmpty((Collection)oldInvoiceList)) {
            oldInvoiceList.forEach(t -> invoiceUpdateMap.put(t.getInvoiceId(), BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny())));
        }
        if (!invoiceUpdateMap.isEmpty()) {
            ArrayList<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS = new ArrayList<InvoiceReceiveFlagVO>();
            for (Map.Entry t2 : invoiceUpdateMap.entrySet()) {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId((Long)t2.getKey());
                v.setNowUesdInvoiceTaxMny((BigDecimal)t2.getValue());
                invoiceReceiveFlagVOS.add(v);
            }
            if (CollectionUtils.isNotEmpty(invoiceReceiveFlagVOS)) {
                List list = BeanMapper.mapList(invoiceReceiveFlagVOS, InvoiceReceivePoolEntity.class);
                List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.in(BaseEntity::getId, ids);
                List entities = this.invoiceReceivePoolService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)entities)) {
                    Map maps = entities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
                    for (InvoiceReceiveFlagVO i : invoiceReceiveFlagVOS) {
                        Long invoiceReceiveId = i.getId();
                        InvoiceReceivePoolEntity e = (InvoiceReceivePoolEntity)((Object)maps.get(invoiceReceiveId));
                        if (e == null) continue;
                        BigDecimal use = ComputeUtil.safeAdd((BigDecimal)e.getUsedInvoiceTaxMny(), (BigDecimal)i.getNowUesdInvoiceTaxMny());
                        if (ComputeUtil.isLessThan((BigDecimal)e.getInvoiceTaxMny(), (BigDecimal)use)) {
                            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff1a\u53d1\u7968\u3010\u53f7\u7801\uff1a" + e.getInvoiceNumber() + "\u3011\u7684\u5269\u4f59\u91d1\u989d\u4e3a\uff1a" + ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)e.getInvoiceTaxMny(), (BigDecimal)e.getUsedInvoiceTaxMny())) + "\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9\uff01");
                        }
                        i.setNowUesdInvoiceTaxMny(use);
                        i.setFlag(Integer.valueOf(ComputeUtil.equals((BigDecimal)e.getInvoiceTaxMny(), (BigDecimal)use) ? 1 : 0));
                    }
                }
                for (InvoiceReceiveFlagVO i : invoiceReceiveFlagVOS) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(BaseEntity::getId, (Object)i.getId());
                    updateWrapper.set(InvoiceReceivePoolEntity::getFlag, (Object)i.getFlag());
                    updateWrapper.set(InvoiceReceivePoolEntity::getUsedInvoiceTaxMny, (Object)i.getNowUesdInvoiceTaxMny());
                    this.invoiceReceivePoolService.update((Wrapper)updateWrapper);
                }
            }
        }
    }

    @Override
    public void updateInvoiceUsedMnyByDel(List<Long> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("payapplyId", new Parameter("in", ids));
        List invoiceEntityList = this.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)invoiceEntityList)) {
            ArrayList invoiceReceiveFlagVOS = new ArrayList();
            invoiceEntityList.forEach(t -> {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                invoiceReceiveFlagVOS.add(v);
            });
            if (CollectionUtils.isNotEmpty(invoiceReceiveFlagVOS)) {
                List list = BeanMapper.mapList(invoiceReceiveFlagVOS, InvoiceReceivePoolEntity.class);
                List receivePoolIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.in(BaseEntity::getId, receivePoolIds);
                List entities = this.invoiceReceivePoolService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)entities)) {
                    Map maps = entities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
                    for (InvoiceReceiveFlagVO i : invoiceReceiveFlagVOS) {
                        Long invoiceReceiveId = i.getId();
                        InvoiceReceivePoolEntity e = (InvoiceReceivePoolEntity)((Object)maps.get(invoiceReceiveId));
                        if (e == null) continue;
                        BigDecimal use = ComputeUtil.safeAdd((BigDecimal)e.getUsedInvoiceTaxMny(), (BigDecimal)i.getNowUesdInvoiceTaxMny());
                        if (ComputeUtil.isLessThan((BigDecimal)e.getInvoiceTaxMny(), (BigDecimal)use)) {
                            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff1a\u53d1\u7968\u3010\u53f7\u7801\uff1a" + e.getInvoiceNumber() + "\u3011\u7684\u5269\u4f59\u91d1\u989d\u4e3a\uff1a" + ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)e.getInvoiceTaxMny(), (BigDecimal)e.getUsedInvoiceTaxMny())) + "\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9\uff01");
                        }
                        i.setNowUesdInvoiceTaxMny(use);
                        i.setFlag(Integer.valueOf(ComputeUtil.equals((BigDecimal)e.getInvoiceTaxMny(), (BigDecimal)use) ? 1 : 0));
                    }
                }
                for (InvoiceReceiveFlagVO i : invoiceReceiveFlagVOS) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(BaseEntity::getId, (Object)i.getId());
                    updateWrapper.set(InvoiceReceivePoolEntity::getFlag, (Object)i.getFlag());
                    updateWrapper.set(InvoiceReceivePoolEntity::getUsedInvoiceTaxMny, (Object)i.getNowUesdInvoiceTaxMny());
                    this.invoiceReceivePoolService.update((Wrapper)updateWrapper);
                }
            }
        }
    }
}

