/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.promaterial.contract.service.IGroupPriceDetailService;
import com.ejianc.business.promaterial.contract.vo.ChangeDataVO;
import com.ejianc.business.promaterial.contract.vo.GroupPriceDetailVO;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.bean.OrderProductDetailEntity;
import com.ejianc.business.promaterial.order.service.IOrderProductDetailService;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="order")
public class OrderBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderService service;
    @Autowired
    private IOrderProductDetailService orderProductDetailService;
    @Autowired
    private IGroupPriceDetailService groupPriceDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(billId));
        orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.service.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(billId));
        if (null != entity.getDeliverModel() && entity.getDeliverModel() == 1) {
            this.logger.info("\u751f\u6210\u8ba2\u5355\u5b50\u8868");
            ArrayList<OrderProductDetailEntity> orderProductDetailEntityList = new ArrayList<OrderProductDetailEntity>();
            List orderDetailVOS = BeanMapper.mapList(entity.getOrderDetailList(), OrderDetailVO.class);
            ArrayList<ChangeDataVO> changeDataVOS = new ArrayList<ChangeDataVO>();
            for (OrderDetailVO e : orderDetailVOS) {
                if (null == e.getContractDetailTreeId()) continue;
                ChangeDataVO dataVO = new ChangeDataVO();
                dataVO.setTreeId(Long.valueOf(e.getContractDetailTreeId()));
                dataVO.setNum(e.getNum());
                changeDataVOS.add(dataVO);
            }
            if (CollectionUtils.isNotEmpty(changeDataVOS)) {
                List<GroupPriceDetailVO> resList = this.groupPriceDetailService.changeDetailData(changeDataVOS);
                this.logger.info("\u67e5\u51fa\u6e05\u5355\u7ec4\u4ef7\u5b50\u8868-----------{}", (Object)JSONObject.toJSONString(resList));
                if (CollectionUtils.isNotEmpty(resList)) {
                    Map orderDetailMap = orderDetailVOS.stream().collect(Collectors.toMap(OrderDetailVO::getContractDetailTreeId, Function.identity(), (key1, key2) -> key2));
                    for (GroupPriceDetailVO groupPriceDetailVO : resList) {
                        if (!orderDetailMap.containsKey(groupPriceDetailVO.getParentID())) continue;
                        this.logger.info("\u8d4b\u503c");
                        OrderProductDetailEntity productDetailEntity = (OrderProductDetailEntity)((Object)BeanMapper.map(orderDetailMap.get(groupPriceDetailVO.getParentID()), OrderProductDetailEntity.class));
                        productDetailEntity.setOrderDetailSourceId(productDetailEntity.getId());
                        productDetailEntity.setId(IdWorker.getId());
                        productDetailEntity.setMaterialTypeId(groupPriceDetailVO.getMaterialTypeId());
                        productDetailEntity.setMaterialTypeName(groupPriceDetailVO.getMaterialTypeName());
                        productDetailEntity.setMaterialTypeCode(groupPriceDetailVO.getMaterialTypeCode());
                        productDetailEntity.setMaterialName(groupPriceDetailVO.getMaterialName());
                        productDetailEntity.setSpec(groupPriceDetailVO.getSpec());
                        productDetailEntity.setSpecif(groupPriceDetailVO.getSpecif());
                        productDetailEntity.setUnit(groupPriceDetailVO.getUnitName());
                        productDetailEntity.setBrand(groupPriceDetailVO.getBrand());
                        productDetailEntity.setParentMaterialName(groupPriceDetailVO.getParentMaterialName());
                        productDetailEntity.setOrderNum(groupPriceDetailVO.getNum());
                        productDetailEntity.setDetailOrderMny(groupPriceDetailVO.getMoney());
                        productDetailEntity.setDetailOrderTaxMny(groupPriceDetailVO.getDetailTaxMny());
                        productDetailEntity.setDetailTax(groupPriceDetailVO.getDetailTax());
                        productDetailEntity.setUnDeliverNum(groupPriceDetailVO.getNum());
                        orderProductDetailEntityList.add(productDetailEntity);
                    }
                    this.logger.info("orderProductDetailEntityList-----------{}", (Object)JSONObject.toJSONString(orderProductDetailEntityList));
                    this.orderProductDetailService.saveOrUpdateBatch(orderProductDetailEntityList, orderProductDetailEntityList.size(), false);
                    this.logger.info("\u4fdd\u5b58\u5b50\u8868\u7ed3\u675f\uff01");
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u4e0d\u5141\u8bb8\u56de\u9000!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

