/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.plan.bean.PlanChangeDetailEntity;
import com.ejianc.business.promaterial.plan.bean.PlanChangeEntity;
import com.ejianc.business.promaterial.plan.bean.PlanEntity;
import com.ejianc.business.promaterial.plan.enums.ChangeStatusEnum;
import com.ejianc.business.promaterial.plan.mapper.PlanChangeMapper;
import com.ejianc.business.promaterial.plan.service.IPlanChangeDetailService;
import com.ejianc.business.promaterial.plan.service.IPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IPlanService;
import com.ejianc.business.promaterial.plan.vo.PlanChangeDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanChangeRecordVO;
import com.ejianc.business.promaterial.plan.vo.PlanChangeVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.business.promaterial.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planChangeService")
public class PlanChangeServiceImpl
extends BaseServiceImpl<PlanChangeMapper, PlanChangeEntity>
implements IPlanChangeService {
    private static String PROGRESS_TOTAL_CHANGE_CODE = "PLAN_CHANGE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IPlanChangeDetailService planChangeDetailService;

    @Override
    public List<PlanChangeRecordVO> queryDetailRecord(Long planId) {
        List planChangeVOS = null;
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(planId));
        if (null != planEntity.getChangeVersion() && planEntity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(PlanChangeEntity::getTotalId, (Object)planId);
            lambda.in(PlanChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List entities = super.list((Wrapper)lambda);
            entities.forEach(changevo -> {
                if (changevo.getChangeVersion() < 10) {
                    changevo.setTotalCode(changevo.getTotalCode() + "-0" + changevo.getChangeVersion());
                } else {
                    changevo.setTotalCode(changevo.getTotalCode() + "-" + changevo.getChangeVersion());
                }
            });
            planChangeVOS = BeanMapper.mapList((Iterable)entities, PlanChangeRecordVO.class);
        }
        return planChangeVOS;
    }

    private void saveWritePlan(PlanChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(PlanEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(PlanEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(PlanEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(PlanEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getTotalId());
        this.planService.update((Wrapper)updateWrapper);
    }

    @Override
    public PlanChangeVO insertOrUpdate(PlanChangeVO planChangeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entitiesc = null;
        List entities = null;
        this.checkTotalUsed(planChangeVO.getTotalId(), planChangeVO.getId());
        if (StringUtils.isEmpty((CharSequence)planChangeVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PROGRESS_TOTAL_CHANGE_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                planChangeVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PlanChangeEntity::getBillCode, (Object)planChangeVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(PlanChangeEntity::getTotalId, (Object)planChangeVO.getTotalId());
        entities = super.list((Wrapper)lambda);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("bill_code", new Parameter("eq", (Object)planChangeVO.getBillCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)planChangeVO.getTotalId()));
        entitiesc = this.planService.queryList(queryParam, false);
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u5355\u636e\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        PlanChangeEntity changeEntity = (PlanChangeEntity)((Object)BeanMapper.map((Object)planChangeVO, PlanChangeEntity.class));
        List<PlanChangeDetailEntity> beforeDetails = changeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == changeEntity.getId()) {
            for (PlanChangeDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate((Object)changeEntity, false);
        List<PlanChangeDetailEntity> changeDetailEntities = changeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (PlanChangeDetailEntity cdEntity : changeDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (PlanChangeDetailEntity cdEntity : changeDetailEntities) {
                cdEntity.setCode(cdEntity.getName());
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            List resultMapList = BeanMapper.mapList(changeDetailEntities, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            List<Map<String, Object>> ListCodeDate = this.creatCode(treeData, null, null);
            ArrayList<PlanChangeDetailEntity> entityList = new ArrayList<PlanChangeDetailEntity>();
            this.treeToList(ListCodeDate, entityList);
            this.planChangeDetailService.saveOrUpdateBatch(entityList, entityList.size(), false);
        }
        this.saveWritePlan(changeEntity);
        return this.queryDetail(changeEntity.getId());
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String structCode, String innerCode) {
        for (Map<String, Object> ypd : list) {
            if (StringUtils.isNotEmpty((CharSequence)structCode)) {
                ypd.put("structCode", structCode + "&&" + ypd.get("code"));
            } else {
                ypd.put("structCode", ypd.get("code"));
            }
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") == null) continue;
            List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), null, ypd.get("innerCode").toString());
            ypd.put("children", child);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> treeData, List<PlanChangeDetailEntity> detailEntities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), detailEntities);
            }
            if (3 <= (Integer)ypd.get("nodeLevel")) continue;
            detailEntities.add((PlanChangeDetailEntity)((Object)BeanMapper.map(ypd, PlanChangeDetailEntity.class)));
        }
    }

    @Override
    public PlanChangeVO addConvertByConId(Long planId) {
        PlanVO planVO = this.planService.queryDetail(planId, false);
        PlanChangeVO changeVO = (PlanChangeVO)BeanMapper.map((Object)planVO, PlanChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setTotalId(changeVO.getId());
        changeVO.setTotalCode(changeVO.getBillCode());
        changeVO.setId(null);
        changeVO.setBillCode(null);
        changeVO.setChangeTime(null);
        changeVO.setChangeDescription(null);
        changeVO.setChangeReason(null);
        changeVO.setChangeVersion(Integer.valueOf(changeVO.getChangeVersion() == null ? 1 : changeVO.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeTime(new Date());
        List changeDetailList = changeVO.getDetailList();
        List resultMapList = BeanMapper.mapList((Iterable)changeDetailList, Map.class);
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        ArrayList<PlanChangeDetailEntity> detailEntities = new ArrayList<PlanChangeDetailEntity>();
        this.treeToList(treeData, detailEntities);
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            detailEntities.forEach(detailEntity -> {
                detailEntity.setTotalId(detailEntity.getTotalId());
                detailEntity.setTotalChangeBid(detailEntity.getId());
                detailEntity.setTid(detailEntity.getId().toString());
                detailEntity.setTpid(detailEntity.getParentId() != null && detailEntity.getParentId() > 0L ? detailEntity.getParentId().toString() : "");
                detailEntity.setRowState("add");
                detailEntity.setChangeType(null);
            });
        }
        List<PlanChangeDetailVO> detailVOList = this.entryListToVoWithSort(detailEntities);
        changeVO.setDetailList(TreeNodeBUtil.buildTree(detailVOList));
        return changeVO;
    }

    private List<PlanChangeDetailVO> entryListToVoWithSort(List<PlanChangeDetailEntity> detailEntities) {
        List detailVOList = BeanMapper.mapList(detailEntities, PlanChangeDetailVO.class);
        detailVOList.sort((o1, o2) -> {
            String[] sufArrs;
            String[] preArrs = o1.getDetailIndex().split("\\.");
            int len = preArrs.length > (sufArrs = o2.getDetailIndex().split("\\.")).length ? preArrs.length : sufArrs.length;
            for (int i = 0; i < len; ++i) {
                int preNum = 0;
                int sufNum = 0;
                if (i < preArrs.length) {
                    preNum = Integer.parseInt(preArrs[i]);
                }
                if (i < sufArrs.length) {
                    sufNum = Integer.parseInt(sufArrs[i]);
                }
                if (preNum > sufNum) {
                    return 1;
                }
                if (preNum >= sufNum) continue;
                return -1;
            }
            return 0;
        });
        return detailVOList;
    }

    @Override
    public PlanChangeVO queryDetail(Long id) {
        PlanChangeEntity changeEntity = (PlanChangeEntity)((Object)super.selectById((Serializable)id));
        PlanChangeVO changeVO = (PlanChangeVO)BeanMapper.map((Object)((Object)changeEntity), PlanChangeVO.class);
        List<PlanChangeDetailEntity> detailList = changeEntity.getDetailList();
        ArrayList<PlanChangeDetailEntity> detailListAct = new ArrayList<PlanChangeDetailEntity>();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (PlanChangeDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
                if (3 <= cdEntity.getNodeLevel()) continue;
                detailListAct.add(cdEntity);
            }
            List<PlanChangeDetailVO> resultMapList = this.entryListToVoWithSort(detailListAct);
            changeVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<PlanChangeVO> vos) {
        PlanChangeEntity entity = (PlanChangeEntity)((Object)super.selectById((Serializable)vos.get(0).getId()));
        PlanEntity pcentity = (PlanEntity)((Object)this.planService.selectById(entity.getTotalId()));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PlanChangeEntity::getTotalId, (Object)entity.getTotalId());
        List changeList = ((PlanChangeMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        pcentity.setId(entity.getTotalId());
        pcentity.setChangeVersion(pcentity.getChangeVersion() - 1);
        pcentity.setChangeStatus(changeList.size() > 1 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        this.planService.saveOrUpdate((Object)pcentity);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public void checkTotalUsed(Long planId, Long changeId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(PlanChangeEntity::getTotalId, (Object)planId);
        if (changeId != null && changeId > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)changeId);
        }
        lambdachange.notIn(PlanChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u8ba1\u5212\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
    }
}

