/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.promaterial.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.promaterial.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"invoiceReceiveRegist"})
public class InvoiceReceiveRegistController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> saveOrUpdate(@RequestBody InvoiceReceiveRegistVO saveorUpdateVO) {
        InvoiceReceiveRegistEntity entity = (InvoiceReceiveRegistEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceReceiveRegistEntity.class));
        this.service.insertOrUpdate(entity);
        InvoiceReceiveRegistVO vo = (InvoiceReceiveRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveRegistVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryDetail(Long id) {
        InvoiceReceiveRegistEntity entity = (InvoiceReceiveRegistEntity)((Object)this.service.selectById(id));
        InvoiceReceiveRegistVO vo = (InvoiceReceiveRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveRegistVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u4f9b\u65b9\u63d0\u4ea4\u6216\u8005\u91c7\u8d2d\u65b9\u9a73\u56de")
    @RequestMapping(value={"/submitGF"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> submitGF(@RequestBody InvoiceReceiveRegistVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        updateWrapper.set(InvoiceReceiveRegistEntity::getChangState, (Object)saveOrUpdateVO.getChangState());
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getReturnReason())) {
            updateWrapper.set(InvoiceReceiveRegistEntity::getReturnReason, (Object)saveOrUpdateVO.getReturnReason());
        }
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveRegistVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("sellerName");
        param.getFuzzyFields().add("buyerName");
        param.getFuzzyFields().add("processPersonName");
        if (param.getParams().get("hasMyRegist") != null) {
            if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("1")) {
                param.getParams().put("processPersonId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("0")) {
                param.getParams().put("processPersonId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<String> supState = new ArrayList<String>();
        supState.add("checking");
        supState.add("pass");
        param.getComplexParams().add(this.getPageQueryParam(supState));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceiveRegistVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getPageQueryParam(List<String> supState) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("eq", (Object)1));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c3.getParams().put("changState", new Parameter("in", supState));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @RequestMapping(value={"/queryGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryGFList(@RequestBody QueryParam param) {
        CommonResponse commonResponse;
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("sellerName");
        param.getFuzzyFields().add("buyerName");
        param.getFuzzyFields().add("processPersonName");
        if (param.getParams().get("hasMyRegist") != null) {
            if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("1")) {
                param.getParams().put("processPersonId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("0")) {
                param.getParams().put("processPersonId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("sellerId", new Parameter("eq", (Object)supplierId));
        param.getComplexParams().add(this.getGFPageQueryParam());
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceiveRegistVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getGFPageQueryParam() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("eq", (Object)1));
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"receivePool-import.xlsx", (String)"\u6536\u7968\u767b\u8bb0\u53d1\u7968\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<InvoiceReceivePoolVO> errorList = new ArrayList<InvoiceReceivePoolVO>();
        ArrayList<InvoiceReceivePoolVO> successList = new ArrayList<InvoiceReceivePoolVO>();
        CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String, String> defMap = this.getDefMap((List)defList.getData());
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                InvoiceReceivePoolVO s = new InvoiceReceivePoolVO();
                List row = (List)result.get(i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)row.get(0))) || !"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968".equals(row.get(0)) && !"\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968".equals(row.get(0)) && !"\u5176\u5b83".equals(row.get(0))) {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53d1\u7968\u7c7b\u578b\u9009\u62e9\u4e0d\u6b63\u786e\uff01");
                } else {
                    String invoiceType = defMap.get(row.get(0));
                    s.setInvoiceType(Long.valueOf(invoiceType));
                }
                s.setInvoiceTypeName((String)row.get(0));
                s.setInvoiceCode((String)row.get(1));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)row.get(2)))) {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    s.setInvoiceNumber((String)row.get(2));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)row.get(3)))) {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        s.setInvoiceDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)((String)row.get(3))));
                    }
                    catch (ParseException e) {
                        s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        s.setInvoiceDate(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)row.get(4)))) {
                    s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        s.setInvoiceMny(ComputeUtil.scale((BigDecimal)new BigDecimal((String)row.get(4)), (int)2));
                    }
                    catch (NumberFormatException e) {
                        s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u662f\u6b63\u786e\u7684\u6570\u5b57\u683c\u5f0f\uff01");
                        s.setInvoiceMny(null);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)row.get(5)))) {
                    try {
                        s.setTaxMny(ComputeUtil.scale((BigDecimal)new BigDecimal((String)row.get(5)), (int)2));
                    }
                    catch (NumberFormatException e) {
                        s.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7a0e\u989d\u4e0d\u662f\u6b63\u786e\u7684\u6570\u5b57\u683c\u5f0f\uff01");
                        s.setTaxMny(null);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)row.get(6)))) {
                    s.setContent((String)row.get(6));
                }
                if (s.getInvoiceMny() != null && s.getTaxMny() != null) {
                    s.setInvoiceTaxMny(s.getTaxMny().add(s.getInvoiceMny()));
                }
                if (StringUtils.isEmpty((CharSequence)s.getErrorMessage())) {
                    successList.add(s);
                    continue;
                }
                errorList.add(s);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("sellerName");
        queryParam.getFuzzyFields().add("buyerName");
        queryParam.getFuzzyFields().add("processPersonName");
        if (queryParam.getParams().get("hasMyRegist") != null) {
            if (((Parameter)queryParam.getParams().get("hasMyRegist")).getValue().equals("1")) {
                queryParam.getParams().put("processPersonId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if (((Parameter)queryParam.getParams().get("hasMyRegist")).getValue().equals("0")) {
                queryParam.getParams().put("processPersonId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            }
            queryParam.getParams().remove("hasMyRegist");
        }
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceiveRegistVO r = (InvoiceReceiveRegistVO)BeanMapper.map((Object)pool, InvoiceReceiveRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceive-export.xlsx", beans, response);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }
}

