/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.promaterial.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.promaterial.taxnew.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.promaterial.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.promaterial.utils.ConvertUpMoney;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl
extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity>
implements IInvoiceReceiveRegistService {
    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "tax-receive-pool-001";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "tax-receive-code-001";
    private static final String configCodeDm = "TAX_FPDM";
    private static final String configCodeHm = "TAX_FPHM";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean insertOrUpdate(InvoiceReceiveRegistEntity entity) {
        List list;
        Long invoiceQuantity = 0L;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(InvoiceReceiveRegistEntity::getContractId, (Object)entity.getContractId());
        wrapper.notIn(InvoiceReceiveRegistEntity::getBillState, new Object[]{1, 3});
        if (null != entity.getId()) {
            wrapper.ne(BaseEntity::getId, (Object)entity.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)wrapper)))) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode;
            Long tenantid = InvocationInfoProxy.getTenantid();
            if ("2".equals(entity.getSourceType())) {
                tenantid = entity.getTenantId();
            }
            if ((billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantid)).isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (ListUtil.isNotEmpty(entity.getInvoiceReceiveList())) {
            CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String, String> defMap = this.getDefMap((List)defList.getData());
            this.checkPool(entity.getInvoiceReceiveList());
            invoiceQuantity = entity.getInvoiceReceiveList().stream().filter(e -> !"del".equals(e.getRowState())).count();
            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceiveList()) {
                if ("add".equals(poolEntity.getRowState())) {
                    CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    poolEntity.setBillCode((String)billCode.getData());
                    BigDecimal taxMny = poolEntity.getTaxMny();
                    String memo = poolEntity.getMemo();
                    List attachIds = poolEntity.getAttachIds();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)poolEntity), (String[])new String[]{"invoiceType", "invoiceTypeName"});
                    poolEntity.setAttachIds(attachIds);
                    poolEntity.setMemo(memo);
                    poolEntity.setTaxMny(taxMny);
                    poolEntity.setId(null);
                    poolEntity.setBillState(0);
                }
                poolEntity.setInvoiceTypeName(defMap.get(poolEntity.getInvoiceType() + ""));
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setContractId(entity.getContractId());
                poolEntity.setContractName(entity.getContractName());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
                poolEntity.setCustomerId(entity.getBuyerId());
                poolEntity.setCustomerName(entity.getBuyerName());
                poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setRegist(false);
                poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
                poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
                poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
                poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
                poolEntity.setAuthState(0);
                poolEntity.setDeductionState(0);
                poolEntity.setFlag(0);
                poolEntity.setTaxCostFlag(0);
                if (entity.getPurchaseType() != null) {
                    poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
                }
                if (entity.getDependOnProject() != null) {
                    poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
                }
                if (poolEntity.getContractId() != null) {
                    poolEntity.setType(1);
                } else {
                    poolEntity.setType(2);
                }
                poolEntity.setOrgId(entity.getOrgId());
                poolEntity.setOrgName(entity.getOrgName());
                poolEntity.setProjectId(entity.getProjectId());
                poolEntity.setProjectName(entity.getProjectName());
                poolEntity.setContractCode(entity.getContractCode());
                poolEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                poolEntity.setSupplierEmployeeId(entity.getSupplierEmployeeId());
                poolEntity.setSupplierEmployeeName(entity.getSupplierEmployeeName());
                poolEntity.setSourceType(entity.getSourceType());
                poolEntity.setChangState(entity.getChangState());
            }
        }
        entity.setInvoiceQuantity(invoiceQuantity.intValue());
        return super.saveOrUpdateNoES((Object)entity);
    }

    public void checkPool(List<InvoiceReceivePoolEntity> poolList) {
        ArrayList<String> invoiceNumberList = new ArrayList<String>();
        for (InvoiceReceivePoolEntity vo : poolList) {
            String invoiceNumber;
            if ("del".equals(vo.getRowState()) || !StringUtils.isNotEmpty((String)(invoiceNumber = vo.getInvoiceNumber()))) continue;
            if (invoiceNumberList.contains(invoiceNumber)) {
                throw new BusinessException("\u53d1\u7968\u53f7\u7801\u3010" + invoiceNumber + "\u3011\u5f55\u5165\u91cd\u590d\uff01");
            }
            invoiceNumberList.add(invoiceNumber);
            LambdaQueryWrapper invoiceNumberQueryWrapper = new LambdaQueryWrapper();
            invoiceNumberQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getInvoiceNumber, (Object)invoiceNumber);
            invoiceNumberQueryWrapper.ne(vo.getReceiveBillId() != null, InvoiceReceivePoolEntity::getReceiveBillId, (Object)vo.getReceiveBillId());
            int count = this.invoiceReceivePoolService.count((Wrapper)invoiceNumberQueryWrapper);
            if (count <= 0) continue;
            throw new BusinessException("\u53d1\u7968\u53f7\u7801\u3010" + vo.getInvoiceNumber() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public Map<String, String> getDefMapName(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    @Override
    public List<InvoiceReceivePoolEntity> generateInvoiceReceivePool(InvoiceReceiveRegistEntity entity) {
        InvoiceReceivePoolEntity poolEntity = new InvoiceReceivePoolEntity();
        poolEntity.setOriginType(0);
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        poolEntity.setBillCode((String)billCode.getData());
        poolEntity.setId(null);
        poolEntity.setReceiveBillCode(entity.getCode());
        poolEntity.setReceiveBillId(entity.getId());
        poolEntity.setType(2);
        poolEntity.setBillState(0);
        CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String, String> defMap = this.getDefMapName((List)defList.getData());
        String invoiceType = defMap.get("\u5176\u4ed6");
        if (!StringUtils.isNotEmpty((String)invoiceType)) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u53d1\u7968\u7c7b\u578b\u83b7\u53d6\u5931\u8d25");
        }
        poolEntity.setInvoiceType(Long.valueOf(invoiceType));
        poolEntity.setInvoiceTypeName("\u5176\u4ed6");
        poolEntity.setInvoiceCode(this.getBillCode(configCodeDm));
        poolEntity.setInvoiceNumber(this.getBillCode(configCodeHm));
        poolEntity.setInvoiceDate(new Date());
        poolEntity.setInvoiceMny(ComputeUtil.nullToZero((BigDecimal)entity.getCurrentReceiveMny()));
        poolEntity.setTaxMny(ComputeUtil.nullToZero((BigDecimal)entity.getTaxMny()));
        poolEntity.setInvoiceTaxMny(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)poolEntity.getInvoiceMny(), (BigDecimal)poolEntity.getTaxMny())));
        if (new BigDecimal(poolEntity.getInvoiceTaxMny().intValue()).compareTo(poolEntity.getInvoiceTaxMny()) == 0) {
            poolEntity.setInvoiceTaxMnys(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()) + "\u6574");
        } else {
            poolEntity.setInvoiceTaxMnys(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()));
        }
        poolEntity.setContractId(entity.getContractId());
        poolEntity.setContractCode(entity.getContractCode());
        poolEntity.setContractName(entity.getContractName());
        poolEntity.setSupplierId(entity.getSellerId());
        poolEntity.setSupplierName(entity.getSellerName());
        poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
        poolEntity.setCustomerId(entity.getBuyerId());
        poolEntity.setCustomerName(entity.getBuyerName());
        poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
        poolEntity.setEmployeeId(entity.getProcessPersonId());
        poolEntity.setEmployeeName(entity.getProcessPersonName());
        poolEntity.setRegist(false);
        poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
        poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
        poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
        poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
        poolEntity.setAuthState(0);
        poolEntity.setDeductionState(0);
        poolEntity.setFlag(0);
        if (entity.getPurchaseType() != null) {
            poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
        }
        if (entity.getDependOnProject() != null) {
            poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
        }
        if (poolEntity.getContractId() != null) {
            poolEntity.setType(1);
        } else {
            poolEntity.setType(2);
        }
        poolEntity.setOrgId(entity.getOrgId());
        poolEntity.setOrgName(entity.getOrgName());
        poolEntity.setProjectId(entity.getProjectId());
        poolEntity.setProjectName(entity.getProjectName());
        poolEntity.setSupplierEmployeeId(entity.getSupplierEmployeeId());
        poolEntity.setSupplierEmployeeName(entity.getSupplierEmployeeName());
        poolEntity.setSourceType(entity.getSourceType());
        poolEntity.setChangState(entity.getChangState());
        ArrayList<InvoiceReceivePoolEntity> list = new ArrayList<InvoiceReceivePoolEntity>();
        list.add(poolEntity);
        return list;
    }

    public String getBillCode(String code) {
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            return (String)billCode.getData();
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

